<div class="app" id="wrapper">
    <header id="header" class="header no-print">
        <?php
        if (FatApp::getConfig('CONF_AUTO_RESTORE_ON', FatUtility::VAR_INT, 1) && CommonHelper::demoUrl()) {
            $isAdmin = true;

            $tplFile = str_replace(CONF_APPLICATION_PATH, CONF_INSTALLATION_PATH . CONF_FRONT_END_APPLICATION_DIR, CONF_THEME_PATH);
            $tplFile .= 'default/restore-system/top-header.php';
            include_once $tplFile;
        } ?>
        <div class="header-top">
            <div class="header-start">

                <?php
                // $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_ADMIN_LOGO, 0, 0, $adminLangId, false);
                // $aspectRatioArr = AttachedFile::getRatioTypeArray($adminLangId);
                $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_FRONT_LOGO, 0, 0, $adminLangId, true);
                $aspectRatioArr = AttachedFile::getRatioTypeArray($adminLangId, true);
                $sizeType = 'CUSTOM';
                if ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_RECTANGULAR) {
                    $sizeType = '16X9';
                } elseif ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_SQUARE) {
                    $sizeType = '1X1';
                }

                $uploadedTime = AttachedFile::setTimeParam($fileData['afile_updated_at']);
                $siteLogo = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'siteLogo', array($adminLangId, $sizeType), CONF_WEBROOT_FRONT_URL) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
                ?>
                <a href="<?php echo UrlHelper::generateUrl('home'); ?>">
                    <img class="logo" <?php if ($fileData['afile_aspect_ratio'] > 0 && !empty($aspectRatioArr[$fileData['afile_aspect_ratio']])) { ?>
                            data-ratio="<?php echo $aspectRatioArr[$fileData['afile_aspect_ratio']]; ?>" <?php } ?>
                        src="<?php echo $siteLogo; ?>" alt="">
                </a>

            </div>
            <!-- <div class="header-center">
            <button class="search-btn" type="button" aria-label="Search" data-bs-toggle="modal"
                data-bs-target="#searchModal">
                <span class="search-btn-left">
                    <svg class="svg" width="18" height="18" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                        fill="currentColor">
                        <path
                            d="M18.031 16.6168L22.3137 20.8995L20.8995 22.3137L16.6168 18.031C15.0769 19.263 13.124 20 11 20C6.032 20 2 15.968 2 11C2 6.032 6.032 2 11 2C15.968 2 20 6.032 20 11C20 13.124 19.263 15.0769 18.031 16.6168ZM16.0247 15.8748C17.2475 14.6146 18 12.8956 18 11C18 7.1325 14.8675 4 11 4C7.1325 4 4 7.1325 4 11C4 14.8675 7.1325 18 11 18C12.8956 18 14.6146 17.2475 15.8748 16.0247L16.0247 15.8748Z">
                        </path>
                    </svg>
                    <span class="search-btn-placeholder">Search</span>
                </span>
                <span class="search-btn-keys">
                    <kbd class="DocSearch-Button-Key">Ctrl K</kbd>
                </span>
            </button>
        </div> -->
            <div class="header-end">
                <a class="side-links" title="<?php echo Labels::getLabel('LBL_View_Store', $adminLangId); ?>"
                    href="<?php echo CONF_WEBROOT_FRONT_URL; ?>" target="_blank">
                    <svg class="svg" width="16" height="16" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                        fill="currentColor">
                        <path
                            d="M21 13.2422V20H22V22H2V20H3V13.2422C1.79401 12.435 1 11.0602 1 9.5C1 8.67286 1.22443 7.87621 1.63322 7.19746L4.3453 2.5C4.52393 2.1906 4.85406 2 5.21132 2H18.7887C19.1459 2 19.4761 2.1906 19.6547 2.5L22.3575 7.18172C22.7756 7.87621 23 8.67286 23 9.5C23 11.0602 22.206 12.435 21 13.2422ZM19 13.9725C18.8358 13.9907 18.669 14 18.5 14C17.2409 14 16.0789 13.478 15.25 12.6132C14.4211 13.478 13.2591 14 12 14C10.7409 14 9.5789 13.478 8.75 12.6132C7.9211 13.478 6.75911 14 5.5 14C5.331 14 5.16417 13.9907 5 13.9725V20H19V13.9725ZM5.78865 4L3.35598 8.21321C3.12409 8.59843 3 9.0389 3 9.5C3 10.8807 4.11929 12 5.5 12C6.53096 12 7.44467 11.3703 7.82179 10.4295C8.1574 9.59223 9.3426 9.59223 9.67821 10.4295C10.0553 11.3703 10.969 12 12 12C13.031 12 13.9447 11.3703 14.3218 10.4295C14.6574 9.59223 15.8426 9.59223 16.1782 10.4295C16.5553 11.3703 17.469 12 18.5 12C19.8807 12 21 10.8807 21 9.5C21 9.0389 20.8759 8.59843 20.6347 8.19746L18.2113 4H5.78865Z">
                        </path>
                    </svg>
                </a>
                <button class="side-links" title="<?php echo Labels::getLabel('LBL_Clear_Cache', $adminLangId); ?>"
                    type="button" onclick="clearCache()">

                    <svg class="svg" width="16" height="16" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                        fill="currentColor">
                        <path
                            d="M8.58564 8.85449L3.63589 13.8042L8.83021 18.9985L9.99985 18.9978V18.9966H11.1714L14.9496 15.2184L8.58564 8.85449ZM9.99985 7.44027L16.3638 13.8042L19.1922 10.9758L12.8283 4.61185L9.99985 7.44027ZM13.9999 18.9966H20.9999V20.9966H11.9999L8.00229 20.9991L1.51457 14.5113C1.12405 14.1208 1.12405 13.4877 1.51457 13.0971L12.1212 2.49053C12.5117 2.1 13.1449 2.1 13.5354 2.49053L21.3136 10.2687C21.7041 10.6592 21.7041 11.2924 21.3136 11.6829L13.9999 18.9966Z">
                        </path>
                    </svg>

                </button>
                <div class="dropdown">
                    <button class="side-links" onclick="getNotifications()" title="Message" type="button"
                        data-bs-toggle="dropdown" aria-expanded="false">

                        <svg class="svg" width="16" height="16" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                            fill="currentColor">
                            <path
                                d="M22 20H2V18H3V11.0314C3 6.04348 7.02944 2 12 2C16.9706 2 21 6.04348 21 11.0314V18H22V20ZM5 18H19V11.0314C19 7.14806 15.866 4 12 4C8.13401 4 5 7.14806 5 11.0314V18ZM9.5 21H14.5C14.5 22.3807 13.3807 23.5 12 23.5C10.6193 23.5 9.5 22.3807 9.5 21Z">
                            </path>
                        </svg>

                        <span class="message-badge"><?php echo CommonHelper::displayBadgeCount($notifyCount); ?></span>
                    </button>
                    <div class="dropdown-menu dropdown-menu-fit dropdown-menu-right dropdown-menu-anim">
                        <div class="dropdown-menu-head">
                            <?php echo Labels::getLabel('LBL_Notifications', $adminLangId); ?>
                        </div>
                        <div class="dropdown-menu-body" id="notificationList"></div>
                        <div class="dropdown-menu-foot">
                            <a href="<?php echo UrlHelper::generateUrl('notifications', ''); ?>"
                                class="btn btn-secondary btn-block redirect--js"><?php echo Labels::getLabel('LBL_View_all', $adminLangId); ?></a>
                        </div>
                    </div>
                </div>
                <div class="dropdown">
                    <button class="side-links" title="Language" type="button" data-bs-toggle="dropdown"
                        aria-expanded="false">
                        <svg class="svg" width="16" height="16" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                            fill="currentColor">
                            <path
                                d="M6.23509 6.45329C4.85101 7.89148 4 9.84636 4 12C4 16.4183 7.58172 20 12 20C13.0808 20 14.1116 19.7857 15.0521 19.3972C15.1671 18.6467 14.9148 17.9266 14.8116 17.6746C14.582 17.115 13.8241 16.1582 12.5589 14.8308C12.2212 14.4758 12.2429 14.2035 12.3636 13.3943L12.3775 13.3029C12.4595 12.7486 12.5971 12.4209 14.4622 12.1248C15.4097 11.9746 15.6589 12.3533 16.0043 12.8777C16.0425 12.9358 16.0807 12.9928 16.1198 13.0499C16.4479 13.5297 16.691 13.6394 17.0582 13.8064C17.2227 13.881 17.428 13.9751 17.7031 14.1314C18.3551 14.504 18.3551 14.9247 18.3551 15.8472V15.9518C18.3551 16.3434 18.3168 16.6872 18.2566 16.9859C19.3478 15.6185 20 13.8854 20 12C20 8.70089 18.003 5.8682 15.1519 4.64482C14.5987 5.01813 13.8398 5.54726 13.575 5.91C13.4396 6.09538 13.2482 7.04166 12.6257 7.11976C12.4626 7.14023 12.2438 7.12589 12.012 7.11097C11.3905 7.07058 10.5402 7.01606 10.268 7.75495C10.0952 8.2232 10.0648 9.49445 10.6239 10.1543C10.7134 10.2597 10.7307 10.4547 10.6699 10.6735C10.59 10.9608 10.4286 11.1356 10.3783 11.1717C10.2819 11.1163 10.0896 10.8931 9.95938 10.7412C9.64554 10.3765 9.25405 9.92233 8.74797 9.78176C8.56395 9.73083 8.36166 9.68867 8.16548 9.64736C7.6164 9.53227 6.99443 9.40134 6.84992 9.09302C6.74442 8.8672 6.74488 8.55621 6.74529 8.22764C6.74529 7.8112 6.74529 7.34029 6.54129 6.88256C6.46246 6.70541 6.35689 6.56446 6.23509 6.45329ZM12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22Z">
                            </path>
                        </svg>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-fit dropdown-menu-right dropdown-menu-anim">
                        <?php
                        foreach ($languages as $langId => $language) { ?>
                            <li class="dropdown-menu-item" <?php echo ($adminLangId == $langId) ? 'class="is--active"' : ''; ?>>
                                <button class="dropdown-menu-link" type="button"
                                    onClick="setSiteDefaultLang(<?php echo $langId; ?>)">
                                    <?php if (!empty($language['language_country_code'])) { ?>
                                        <img class="icon-img" width="16" height="16"
                                            alt="<?php echo Labels::getLabel('LBL_Language_Flag', $adminLangId); ?>"
                                            src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/flags/<?php echo FatApp::getConfig('CONF_COUNTRY_FLAG_TYPE', FatUtility::VAR_STRING, 'round'); ?>/<?php echo $language['language_country_code']; ?>.svg">

                                    <?php } ?>
                                    <?php echo $language['language_name']; ?>
                                </button>
                            </li>
                        <?php } ?>
                    </ul>
                </div>
                <div class="my-account dropstart">
                    <button class="my-account-btn" data-bs-toggle="dropdown" data-bs-auto-close="outside" type="button"
                        id="my-account-target" aria-expanded="false">
                        <img class="my-account-avatar" id="leftmenuimgtag"
                            src="<?php echo UrlHelper::generateUrl('image', 'profileImage', array(AdminAuthentication::getLoggedAdminId(), "THUMB", true)); ?>"
                            alt="">

                    </button>
                    <div class="my-account-target dropdown-menu dropdown-menu-fit dropdown-menu-right dropdown-menu-anim"
                        aria-labelledby="my-account-target">
                        <div class="profile">
                            <div class="profile-img">
                                <img src="<?php echo UrlHelper::generateUrl('image', 'profileImage', array(AdminAuthentication::getLoggedAdminId(), "THUMB", true)); ?>"
                                    alt="">
                            </div>
                            <div class="profile-detail">
                                <h6 class="h6"> <?php echo Labels::getLabel('LBL_Welcome', $adminLangId); ?> </h6>
                                <span
                                    class="text-muted"><?php echo AdminAuthentication::getLoggedAdminAttribute("admin_name"); ?>
                                </span>

                            </div>
                        </div>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-menu-link"
                            href="<?php echo UrlHelper::generateUrl('profile', 'changePassword'); ?>">

                            <svg class="svg" width="14" height="14" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 24 24" fill="currentColor">
                                <path
                                    d="M7 10H20C20.5523 10 21 10.4477 21 11V21C21 21.5523 20.5523 22 20 22H4C3.44772 22 3 21.5523 3 21V11C3 10.4477 3.44772 10 4 10H5V9C5 5.13401 8.13401 2 12 2C14.7405 2 17.1131 3.5748 18.2624 5.86882L16.4731 6.76344C15.6522 5.12486 13.9575 4 12 4C9.23858 4 7 6.23858 7 9V10ZM5 12V20H19V12H5ZM10 15H14V17H10V15Z">
                                </path>
                            </svg>
                            <?php echo Labels::getLabel('LBL_Change_Password', $adminLangId); ?>
                        </a>
                        <a class="dropdown-menu-link" href="<?php echo UrlHelper::generateUrl('profile'); ?>">
                            <svg class="svg" width="14" height="14" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 24 24" fill="currentColor">
                                <path
                                    d="M20 22H18V20C18 18.3431 16.6569 17 15 17H9C7.34315 17 6 18.3431 6 20V22H4V20C4 17.2386 6.23858 15 9 15H15C17.7614 15 20 17.2386 20 20V22ZM12 13C8.68629 13 6 10.3137 6 7C6 3.68629 8.68629 1 12 1C15.3137 1 18 3.68629 18 7C18 10.3137 15.3137 13 12 13ZM12 11C14.2091 11 16 9.20914 16 7C16 4.79086 14.2091 3 12 3C9.79086 3 8 4.79086 8 7C8 9.20914 9.79086 11 12 11Z">
                                </path>
                            </svg>
                            <?php echo Labels::getLabel('LBL_View_Profile', $adminLangId); ?></a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-menu-link" href="<?php echo UrlHelper::generateUrl('profile', 'logout'); ?>">

                            <svg class="svg" width="14" height="14" xmlns="http://www.w3.org/2000/svg"
                                viewBox="0 0 24 24" fill="currentColor">
                                <path
                                    d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C15.2713 2 18.1757 3.57078 20.0002 5.99923L17.2909 5.99931C15.8807 4.75499 14.0285 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20C14.029 20 15.8816 19.2446 17.2919 17.9998L20.0009 17.9998C18.1765 20.4288 15.2717 22 12 22ZM19 16V13H11V11H19V8L24 12L19 16Z">
                                </path>

                            </svg>
                            <?php echo Labels::getLabel('LBL_Logout', $adminLangId); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <?php $this->includeTemplate('_partial/header/left-navigation.php') ?>
    <main class="main main-js" id="body">