<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>

<div class='page'>
    <div class='content content-space'>
        <div class="row">
            <div class="col-lg-12 col-md-12 space">
                <div class="page-title">
                    <div class="row">
                        <div class="col--first col-lg-6">

                            <h5><?php echo Labels::getLabel('LBL_Abandoned_Cart', $adminLangId); ?> </h5>
                            <?php $this->includeTemplate('_partial/header/header-breadcrumb.php'); ?>
                        </div>
                    </div>
                </div>
                <section class="card searchform_filter advance-search">
                    <div class="card-head">
                        <h4> <?php echo Labels::getLabel('LBL_Search...', $adminLangId); ?></h4>
                    </div>
                    <div class="card-body extra togglewrap">
                        <?php
                        $frmSearch->setFormTagAttribute('onsubmit', 'searchAbandonedCart(this,1); return(false);');
                        $frmSearch->setFormTagAttribute('class', 'form web_form');
                        $frmSearch->developerTags['colClassPrefix'] = 'col-md-';
                        $frmSearch->developerTags['fld_default_col'] = 12;

                        $buyerFld = $frmSearch->getField('user_name');
                        $buyerFld->developerTags['col'] = 4;

                        $sellerProductFld = $frmSearch->getField('seller_product');
                        $sellerProductFld->developerTags['col'] = 4;

                        //$actionFld = $frmSearch->getField('abandonedcart_action');
                        //$actionFld->developerTags['col'] = 4;
                        
                        $dateFromFld = $frmSearch->getField('date_from');
                        $dateFromFld->setFieldTagAttribute('class', 'calender field--calender');
                        $dateFromFld->developerTags['col'] = 4;

                        $dateToFld = $frmSearch->getField('date_to');
                        $dateToFld->setFieldTagAttribute('class', 'calender field--calender');
                        $dateToFld->developerTags['col'] = 4;

                        $submitBtnFld = $frmSearch->getField('btn_submit');
                        $submitBtnFld->developerTags['col'] = 4;

                        $btn_clear = $frmSearch->getField('btn_clear');
                        $btn_clear->addFieldTagAttribute('onclick', 'clearAbandonedCartSearch()');

                        echo $frmSearch->getFormHtml();
                        ?>
                    </div>
                </section>

                <section class="card section">
                    <div class="card-head">
                        <h4><?php echo Labels::getLabel('LBL_Abandoned_Cart_List', $adminLangId); ?> </h4>
                        <?php
                        $data = [
                            'adminLangId' => $adminLangId,
                            'statusButtons' => false,
                            'deleteButton' => false,
                            'otherButtons' => [
                                [
                                    'attr' => [
                                        'href' => commonHelper::generateUrl('AbandonedCart', 'products'),
                                        'title' => Labels::getLabel('LBL_View_By_Product', $adminLangId)
                                    ],
                                    'label' => '<svg class="svg" width="18" height="18"><use xlink:href="' . CONF_WEBROOT_FRONT_URL . 'images/admin/retina/sprite-actions.svg#percent"></use></svg>'
                                ],
                            ]
                        ];
                        $this->includeTemplate('_partial/action-buttons.php', $data, false);
                        ?>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive table-scrollable js-scrollable tablewrap">
                            <div class="need-remove">
                                <ul class="nav-tabs nav-tabs-line tabs_nav tabs_nav-js">
                                    <li class="nav-tabs-item">
                                        <a class="nav-tabs-link" href="javascript:void(0);" onclick="submitForm(1);">
                                            <?php echo Labels::getLabel('LBL_Abandoned_Cart', $adminLangId); ?>
                                        </a>
                                    </li>
                                    <li class="nav-tabs-item">
                                        <a class="nav-tabs-link" href="javascript:void(0);" onclick="submitForm(2);">
                                            <?php echo Labels::getLabel('LBL_Removed_From_Cart', $adminLangId); ?>
                                        </a>
                                    </li>
                                    <li class="nav-tabs-item">
                                        <a class="nav-tabs-link" href="javascript:void(0);" onclick="submitForm(3);">
                                            <?php echo Labels::getLabel('LBL_Cart_Recoverd', $adminLangId); ?>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                            <div id="abandonedCartListing">
                                <?php echo Labels::getLabel('LBL_Processing...', $adminLangId); ?>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
</div>