<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$yesNoArr = applicationConstants::getYesNoArr($adminLangId);
?>
<div class='page'>
    <div class='content content-space'>
        <div class="row">
            <div class="col-lg-12 col-md-12 space">
                <div class="page-title">
                    <div class="row">
                        <div class="col--first col-lg-6">
                            <h5><?php echo Labels::getLabel('LBL_Manage_Addons', $adminLangId); ?> </h5>
                            <?php $this->includeTemplate('_partial/header/header-breadcrumb.php'); ?>
                        </div>
                    </div>
                </div>
                <section class="card section">
                    <div class="card-head">
                        <h4><a href="<?php echo UrlHelper::generateUrl('AddonProducts', 'listing'); ?>" class="btn-back"
                                title="
                                <?php echo Labels::getLabel('LBL_Back_to_listing', $adminLangId); ?>">
                                <svg class="svg" width="24" height="24">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_FRONTEND; ?>images/admin/retina/sprite-actions.svg#back">
                                    </use>
                                </svg>
                            </a>
                            <?php echo Labels::getLabel('LBL_Addons_View', $adminLangId); ?> </h4>
                    </div>
                    <div class="card-body extra">
                        <div class="form-section">
                            <form class="form web_form form_horizontal">
                                <div class="row">
                                    <div class="col-md-12">
                                        <h3 class="h3">
                                            <?php echo Labels::getLabel('LBL_Product_Information', $adminLangId); ?>
                                        </h3>
                                    </div>
                                </div>
                                <div class="rowbody">
                                    <div class="listview">
                                        <?php


                                        if (!empty($addonProdData)) {
                                            foreach ($addonProdData as $key => $addonProd) {
                                                switch ($key) {
                                                    case 'addonprod_title':
                                                        ?>
                                                        <dl class="list">
                                                            <dt><?php echo Labels::getLabel('LBL_Product_Name', $adminLangId); ?>
                                                            </dt>
                                                            <dd><?php echo $addonProd[$adminLangId] ?? $addonProdData['selprod_identifier']; ?></dd>
                                                        </dl>
                                                        <?php
                                                        break;
                                                    case 'taxcat_name':
                                                        ?>
                                                        <dl class="list">
                                                            <dt><?php echo Labels::getLabel('LBL_Tax_Category_Name', $adminLangId); ?>
                                                            </dt>
                                                            <dd><?php echo $addonProd; ?></dd>
                                                        </dl>
                                                        <?php
                                                        break;
                                                    case 'addonprod_price':
                                                        ?>
                                                        <dl class="list">
                                                            <dt><?php echo Labels::getLabel('LBL_Product_Price', $adminLangId); ?>
                                                            </dt>
                                                            <dd><?php echo $addonProd; ?></dd>
                                                        </dl>
                                                        <?php
                                                        break;
                                                    case 'addonprod_description_' . $adminLangId:
                                                        if (!empty($addonProd)) {
                                                            ?>
                                                            <dl class="list">
                                                                <dt><?php echo Labels::getLabel('LBL_Product_Description', $adminLangId); ?>
                                                                </dt>
                                                                <dd><?php echo CommonHelper::renderHtml($addonProd); ?></dd>
                                                            </dl>
                                                            <?php
                                                        }
                                                        break;
                                                    case 'selprod_is_eligible_cancel':

                                                        ?>
                                                        <dl class="list">
                                                            <dt><?php echo Labels::getLabel('LBL_Is_Eligible_For_Cancel', $adminLangId); ?>
                                                            </dt>
                                                            <dd><?php echo CommonHelper::renderHtml($yesNoArr[$addonProd]); ?></dd>
                                                        </dl>
                                                        <?php
                                                        break;
                                                    case 'selprod_is_eligible_refund':
                                                        ?>
                                                        <dl class="list">
                                                            <dt><?php echo Labels::getLabel('LBL_Is_Eligible_For_Refund', $adminLangId); ?>
                                                            </dt>
                                                            <dd><?php echo CommonHelper::renderHtml($yesNoArr[$addonProd]); ?></dd>
                                                        </dl>
                                                        <?php
                                                        break;
                                                } ?>
                                            <?php }
                                        } ?>
                                    </div>
                                </div>
                            </form>
                        </div>

                    </div>
                </section>
            </div>
        </div>
    </div>
</div>