<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$btnFld = $frmForgot->getField('btn_forgot');
$btnFld->addFieldTagAttribute('class', 'btn btn-brand btn-submit btn-block');
?>
<script src='https://www.google.com/recaptcha/api.js'></script>
<?php ?>
<div class="page-main">
    <div class="page-main-single">
        <div class="card login-card">
            <header class="card-head">
                <figure class="logo-wrap">
                    <?php
                    // $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_ADMIN_LOGO, 0, 0, $adminLangId, false);
                    // $aspectRatioArr = AttachedFile::getRatioTypeArray($adminLangId);
                    $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_FRONT_LOGO, 0, 0, $adminLangId, true);
                    $aspectRatioArr = AttachedFile::getRatioTypeArray($adminLangId, true);
                    $sizeType = 'CUSTOM';
                    if ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_RECTANGULAR) {
                        $sizeType = '16X9';
                    } elseif ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_SQUARE) {
                        $sizeType = '1X1';
                    }
                    $uploadedTime = AttachedFile::setTimeParam($fileData['afile_updated_at']);
                    $siteLogo = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'siteLogo', array($adminLangId, $sizeType), CONF_WEBROOT_FRONT_URL) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
                    ?>
                    <img class="logo"
                        <?php if ($fileData['afile_aspect_ratio'] > 0 && !empty($aspectRatioArr[$fileData['afile_aspect_ratio']])) { ?>
                        data-ratio="<?php echo $aspectRatioArr[$fileData['afile_aspect_ratio']]; ?>" <?php } ?>
                        src="<?php echo $siteLogo; ?>"
                        alt="">
                </figure>

            </header>
            <div class="card-body">
                <div class="title">
                    <h2><?php echo Labels::getLabel('LBL_Forgot_Your_Password?', CommonHelper::getLangId()); ?> </h2>
                    <p><?php echo Labels::getLabel('LBL_Enter_The_E-mail_Address_Associated_With_Your_Account', $adminLangId) ?>
                    </p>
                </div>
                <?php echo $frmForgot->getFormTag(); ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <?php
                            echo $frmForgot->getFieldHTML('admin_email');
                            echo $frmForgot->getFieldHTML('g-recaptcha-response');
                            ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <?php echo $frmForgot->getFieldHTML('btn_forgot'); ?>
                        </div>
                    </div>
                </div>
                <?php echo $frmForgot->getExternalJS(); ?>
                </form>
            </div>
            <div class="card-foot">
                <p>
                    <a class="link-underline"
                        href="<?php echo UrlHelper::generateUrl('adminGuest', 'loginForm'); ?>"><?php echo Labels::getLabel('LBL_Back_to_Login', $adminLangId); ?>
                    </a>
                </p>
            </div>
        </div> <?php include_once(CONF_THEME_PATH . 'default/_partial/copyright.php'); ?>
    </div>


    <?php
    $siteKey = FatApp::getConfig('CONF_RECAPTCHA_SITEKEY', FatUtility::VAR_STRING, '');
    $secretKey = FatApp::getConfig('CONF_RECAPTCHA_SECRETKEY', FatUtility::VAR_STRING, '');
    if (!empty($siteKey) && !empty($secretKey)) { ?>
        <script>
            langLbl.captchaSiteKey = "<?php echo FatApp::getConfig('CONF_RECAPTCHA_SITEKEY', FatUtility::VAR_STRING, ''); ?>";
        </script>
        <script src='https://www.google.com/recaptcha/api.js?onload=googleCaptcha&render=<?php echo $siteKey; ?>'></script>
    <?php } ?>