<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<form class="form">
    <?php
    $arr_flds = array(
        'listserial' => Labels::getLabel('LBL_#', $adminLangId),
        'module' => Labels::getLabel('LBL_Module', $adminLangId),
        'permission' => Labels::getLabel('LBL_Permissions', $adminLangId),
    );
    $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
    $th = $tbl->appendElement('thead')->appendElement('tr');
    foreach ($arr_flds as $val) {
        $e = $th->appendElement('th', array(), $val);
    }

    $sr_no = 0;
    foreach ($arr_listing as $sn => $row) {
        $sr_no++;
        $tr = $tbl->appendElement('tr');

        foreach ($arr_flds as $key => $val) {
            $td = $tr->appendElement('td');
            switch ($key) {
                case 'listserial':
                    $td->appendElement('plaintext', array(), $sr_no);
                    break;
                case 'module':
                    $td->appendElement('plaintext', array(), $row, true);
                    break;
                case 'permission':
                    if ($canViewAdminPermissions) {
                        $listing = AdminPrivilege::getPermissionArr();
                        $options = '';
                        foreach ($listing as $key => $list) {

                            if (
                                in_array($sn, AdminPrivilege::getWriteOnlyPermissionModulesArr())
                                && $key == AdminPrivilege::PRIVILEGE_READ
                            ) {
                                continue;
                            }

                            $checked = '';
                            if (isset($userData[$sn]) && !empty($userData[$sn]) && $userData[$sn]['admperm_value'] == $key) {
                                $checked = 'checked';
                            }
                            $options .= '<li>
                                <label class="radio">
                                <input type="radio" name="'.$sn.'" value="'.$key .'" '.$checked.' onchange="updatePermission(' . $sn . ',this.value)">'.$list.'
                                </label>
                            </li>';

                        }
                        $td->appendElement('plaintext', array(), '<ul class="list-radio justify-content-end">' . $options . '</ul>', true);
                    }
                    break;
            }
        }
    }
    echo $tbl->getHtml();
    if (count($arr_listing) == 0) {
        $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
    }
   
    ?></form>