<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
$arr_flds = array(
    'select_all' => Labels::getLabel('LBL_Select_all', $adminLangId),
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'admin_name' => Labels::getLabel('LBL_Full_Name', $adminLangId),
    'admin_username' => Labels::getLabel('LBL_Username', $adminLangId),
    'admin_email' => Labels::getLabel('LBL_Email', $adminLangId),
    'admin_active' => Labels::getLabel('LBL_Status', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);

if (!$canEdit) {
    unset($arr_flds['select_all'], $arr_flds['action']);
}

$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $key => $val) {
    if ('select_all' == $key) {
        $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $val . '" type="checkbox" onclick="selectAll( $(this) )" class="selectAll-js"></label>', true);
    } else {
        $e = $th->appendElement('th', array(), $val);
    }
}

$sr_no = $recordCount;
foreach ($arr_listing as $sn => $row) {
    $tr = $tbl->appendElement('tr');

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'select_all':
                if ($row['admin_id'] > 1) {
                    $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="admin_ids[]" value=' . $row['admin_id'] . '></label>', true);
                }
                break;
            case 'admin_active':
                if ($row['admin_id'] > 1) {
                    $active = "";
                    if ($row['admin_active']) {
                        $active = 'checked';
                    }
                    $statusAct = ($canEdit === true) ? 'toggleStatus(event,this,' . applicationConstants::YES . ')' : 'toggleStatus(event,this,' . applicationConstants::NO . ')';
                    $statusClass = ($canEdit === false) ? 'disabled' : '';
                    $str = '<label class="switch switch-sm switch-icon ' . $statusClass . '">
                    <input ' . $active . ' type="checkbox" id="' . $row['admin_id'] . '" value="' . $row['admin_id'] . '" onclick="' . $statusAct . '" class="switch-labels"/>
                    </label>';
                    $td->appendElement('plaintext', array(), $str, true);
                }
                
                break;
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
                case 'action':
                    if ($canEdit) {
                        $actionArr = [
                            [
                                "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                                "onclick" => "editAdminUserForm(" . $row['admin_id'] . ")"
                            ],
                            [
                                "title" => Labels::getLabel('LBL_Change_Password', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#password'></use></svg>",
                                "onclick" => "changePasswordForm(" . $row['admin_id'] . ")",
                            ],
                        ];
                        if ($row['admin_id'] > 1 && $row['admin_id'] != $adminLoggedInId) {
                            $actionArr[] = 
                            [
                                "title" => Labels::getLabel('LBL_Permissions', $adminLangId),
                                "icon"=> "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#user-permission'></use></svg>",
                                "href" => UrlHelper::generateUrl('AdminUsers', 'permissions', array($row['admin_id'])),
                            ];
                        }
     
                        $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$row['admin_id']], false);
    
                    }
                    break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
    $sr_no--;
}

$frm = new Form('frmAdmUsersListing', array('id' => 'frmAdmUsersListing'));
$frm->setFormTagAttribute('class', 'form web_form last_td_nowrap actionButtons-js');
$frm->setFormTagAttribute('onsubmit', 'formAction(this, reloadList ); return(false);');
$frm->setFormTagAttribute('action', UrlHelper::generateUrl('AdminUsers', 'toggleBulkStatuses'));
$frm->addHiddenField('', 'status');

echo $frm->getFormTag();
echo $frm->getFieldHtml('status');
echo $tbl->getHtml(); 
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}

?>
</form>
</div>