<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$imagesFrm->setFormTagAttribute('class', 'form web_form form_horizontal images-form');
$imagesFrm->developerTags['colClassPrefix'] = 'col-md-';
$imagesFrm->developerTags['fld_default_col'] = 12;

$img_fld = $imagesFrm->getField('post_image');
$img_fld->addFieldTagAttribute('class', 'btn btn-brand btn-sm');
$img_fld->addFieldTagAttribute('onChange', 'popupImage(this)');

$langFld = $imagesFrm->getField('lang_id');
$langFld->addFieldTagAttribute('class', 'language-js');

$preferredDimensionsStr = '<small class="text--small form-text text-muted">' . sprintf(Labels::getLabel('LBL_Preferred_Dimensions', $adminLangId), '1000*563') . '</small>';
$htmlAfterField = $preferredDimensionsStr;
$img_fld->htmlAfterField = $htmlAfterField;


$featuredImageFrm->setFormTagAttribute('class', 'form web_form form_horizontal');
$featuredImageFrm->developerTags['colClassPrefix'] = 'col-md-';
$featuredImageFrm->developerTags['fld_default_col'] = 12;

$featLangFld = $featuredImageFrm->getField('lang_id');
$featLangFld->addFieldTagAttribute('class', 'language-featured-js');

$imageFld = $featuredImageFrm->getField('post_image');
$imageFld->addFieldTagAttribute('class', 'btn btn-brand btn-sm');
$imageFld->addFieldTagAttribute('onChange', 'popupFeaturedImage(this)');

$languageFld = $featuredImageFrm->getField('lang_id');
$recordId = (int) $post_id;
$formTitle = Labels::getLabel('LBL_Blog_Post_Setup', $adminLangId);
$tabsButtons = [
    [
        'attr' => [
            'onclick' => 'blogPostForm(' . $post_id . ')',
            'title' => Labels::getLabel('LBL_General', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_General', $adminLangId),
        'isActive' => false,
        'isPrimary' => true
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'linksForm(' . $recordId . ')' : '',
            'title' => Labels::getLabel('LBL_Link_Category', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Link_Category', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'langForm("' . $recordId . '","' . FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1) . '")' : '',
            'title' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'postImages(' . $recordId . ')' : '',
            'title' => Labels::getLabel('LBL_Post_Images', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Post_Images', $adminLangId),
        'isActive' => true
    ],
];
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>
<script type="text/javascript">
    $('.images-form input[name=min_width]').val(1000);
    $('.images-form input[name=min_height]').val(563);
    var aspectRatio = 1000 / 563;
    $(function () {
        $("#sortable").sortable({
            stop: function () {
                var mysortarr = new Array();
                $(this).find('li').each(function () {
                    mysortarr.push($(this).attr("id"));
                });
                var post_id = $('#imageFrm input[name=post_id]').val();
                var sort = mysortarr.join('-');
                data = '&post_id=' + post_id + '&ids=' + sort;
                fcom.updateWithAjax(fcom.makeUrl('BlogPosts', 'setImageOrder'), data, function (t) {
                    postImages(post_id);
                });
            }
        }).disableSelection();
    });
</script>
<div id="cropperBox-js"></div>
<section class="section" id="mediaForm-js">
    <div class="row">
        <?php
        /* [ MEDIA INSTRUCTIONS START HERE */
        $tpl = new FatTemplate('', '');
        $tpl->set('adminLangId', $adminLangId);
        echo $tpl->render(false, false, '_partial/imageUploadInstructions.php', true, true);
        /* ] */ ?>
    </div>
    <div class="col-sm-12 form-section">
        <h5><?php echo Labels::getLabel('LBL_Post_Featured_Image', $adminLangId); ?></h5>
        <?php echo $featuredImageFrm->getFormHtml(); ?>
        <div id="featured-image-listing"></div>
    </div>
    <div class="col-sm-12 form-section">
        <hh5><?php echo Labels::getLabel('LBL_Post_Images', $adminLangId); ?></hh5>
        <?php echo $imagesFrm->getFormHtml(); ?>
        <div id="image-listing"></div>
    </div>
    </div>
</section>
<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>