<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$frm->setFormTagAttribute('id', 'prodBrand');
$frm->setFormTagAttribute('class', 'form web_form  form_horizontal layout--' . $formLayout);
$frm->setFormTagAttribute('dir', $formLayout);
$frm->setFormTagAttribute('onsubmit', 'setupBrandLang(this); return(false);');
$frm->developerTags['colClassPrefix'] = 'col-md-';
$frm->developerTags['fld_default_col'] = 12;
$langFld = $frm->getField('lang_id');
$langFld->setfieldTagAttribute('onChange', "brandLangForm(" . $brand_id . ", this.value);");
$recordId = (int) $brand_id;
$tabsButtons = [
    [
        'attr' => [
            'onclick' => 'brandForm('.$recordId.')',
            'title' => Labels::getLabel('LBL_General', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_General', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'brandLangForm("'.$recordId.'","'.FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1).'")' : '',
            'title' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        'isActive' => true
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'brandMediaForm("'.$recordId.'")' : '',
            'title' => Labels::getLabel('LBL_Media', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Media', $adminLangId),
        'isActive' => false
    ],
];
$formTitle = Labels::getLabel('LBL_Product_Brand_Setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>
<?php
$translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
$siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
if (!empty($translatorSubscriptionKey) && $brand_lang_id != $siteDefaultLangId) { ?>
    <div class="row justify-content-end">
        <div class="col-auto mb-4">
            <button type="button" class="btn btn-outline-gray btn-icon btn-language" onClick="brandLangForm(<?php echo $brand_id; ?>, <?php echo $brand_lang_id; ?>, 1)" title="<?php echo Labels::getLabel('LBL_AUTOFILL_LANGUAGE_DATA', $adminLangId); ?>" data-action="">
                <svg class="svg" width="24" height="24">
                    <use xlink:href="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/retina/sprite-actions.svg#translate"></use>
                </svg>
            </button>
        </div>
    </div>
<?php } ?>
<?php echo $frm->getFormHtml(); ?>
<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>