<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>

<div class="table-responsive table-scrollable js-scrollable tablewrap">

<?php

$arr_flds = array(
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'shop_name' => Labels::getLabel('LBL_Requested_BY', $adminLangId),
    'brand_logo' => Labels::getLabel('LBL_Logo', $adminLangId),
    'brand_identifier' => Labels::getLabel('LBL_Brand_Name', $adminLangId),
    'brand_requested_on' => Labels::getLabel('LBL_Requested_On', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);

if (!$canEdit) {
    unset($arr_flds['action']);
}

$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $key => $val) {
    if ($key == "brand_logo") {
        $e = $th->appendElement('th', array('style' => 'text-align:center; width: 20px;'), $val);
    } else {
        $e = $th->appendElement('th', array(), $val);
    }
}

$sr_no = ($page > 1) ? $recordCount - (($page - 1) * $pageSize) : $recordCount;
foreach ($arr_listing as $sn => $row) {
    $tr = $tbl->appendElement('tr');
    $tr->setAttribute("id", $row['brand_id']);

    foreach ($arr_flds as $key => $val) {
        if ($key == "brand_logo") {
            $td = $tr->appendElement('td', array('style' => 'text-align:center;'));
        } else {
            $td = $tr->appendElement('td');
        }
        switch ($key) {
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'shop_name':
                $shopName = "<a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Shops') . "\", " . $row['shop_id'] . ")'>" . $row['shop_name'] . "</a>";
                $userName = "<a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Users') . "\", " . $row['shop_user_id'] . ")'>" . $row['user_name'] . "</a>";
                $td->appendElement('plaintext', array(), html_entity_decode($shopName) . ' (' . $userName . ')', true);
                /*$name = html_entity_decode($row['shop_name']) . '(' . $row['user_name'] . ')';
                $td->appendElement('plaintext', array(), $name);*/
                break;
            case 'brand_logo':
                $td->appendElement(
                    'plaintext',
                    array('style' => 'text-align:center'),
                    '<img  class="max-img"  src="' . UrlHelper::generateUrl('image', 'brand', array($row['brand_id'], $adminLangId, 'MINITHUMB'), CONF_WEBROOT_FRONT_URL) . '">',
                    true
                );
                break;
            case 'brand_identifier':
                if ($row['brand_name'] != '') {
                    $td->appendElement('plaintext', array(), $row['brand_name'], true);
                    $td->appendElement('br', array());
                    $td->appendElement('plaintext', array(), '(' . $row[$key] . ')', true);
                } else {
                    $td->appendElement('plaintext', array(), $row[$key], true);
                }
                break;
            case 'brand_active':
                $active = "";
                if ($row['brand_active']) {
                    $active = 'checked';
                }
                $statucAct = ($canEdit === true) ? 'toggleStatus(this)' : '';
                $statusClass = ($canEdit === false) ? 'disabled' : '';

                $str = '<label class="switch switch-sm switch-icon ' . $statusClass . '">
                      <input ' . $active . ' type="checkbox" id="switch' . $row['brand_id'] . '" value="' . $row['brand_id'] . '" onclick="' . $statucAct . '" class="switch-labels"/>
                      </label> ';

                //  $str = '<div class="checkbox-switch"><input ' . $active . ' type="checkbox" id="switch' . $row['brand_id'] . '" value="' . $row['brand_id'] . '" onclick="' . $statucAct . '"/><label for="switch' . $row['brand_id'] . '">Toggle</label></div>';

                $td->appendElement('plaintext', array(), $str, true);
                break;
            case 'brand_requested_on':
                $date = FatDate::format($row[$key]);
                $dateHtml = "";
                if (strpos($date, ' ') !== false) {
                    list($formattedDate, $formattedTime) = explode(' ', $date);
                    $dateHtml = "<date class='date'>" . $formattedDate . " <time>" . $formattedTime . "</time></date>";
                } else {
                    $dateHtml = "<date class='date'>" . $date . "</date>";
                }
                $td->appendElement('plaintext', array(), $dateHtml, true);
                break;
            case 'action':
                if ($canEdit) {
                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                            "onclick" => "addBrandRequestForm(" . $row['brand_id'] . ")"
                        ]
                    ];
                    if ($row['brand_status'] == ProductCategory::REQUEST_PENDING) {

                        $actionArr[] =
                            [
                                "title" => Labels::getLabel('LBL_Approve_Request', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#check'></use></svg>",
                                "onclick" => "changeRequestStatus(" . $row['brand_id'] . "," . ProductCategory::REQUEST_APPROVED . ")"
                            ];
                        $actionArr[] =
                            [
                                "title" => Labels::getLabel('LBL_Cancel_Request', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#close'></use></svg>",
                                "onclick" => "changeRequestStatus(" . $row['brand_id'] . "," . ProductCategory::REQUEST_CANCELLED . ")"
                            ];

                    }
                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['brand_id']], false);

                }
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
    $sr_no--;
}
echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</div>
<?php
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmBrandSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);

