
<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
    <?php

        $arr_flds = array(
            'select_all' => Labels::getLabel('LBL_Select_all', $adminLangId),
            'listserial' => Labels::getLabel('LBL_#', $adminLangId),
        // 'brand_logo' => Labels::getLabel('LBL_Logo', $adminLangId),
            'brand_identifier' => Labels::getLabel('LBL_Brand_Name', $adminLangId),
            'brand_active' => Labels::getLabel('LBL_Status', $adminLangId),
            'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
        );
        if (!$canEdit) {
            unset($arr_flds['select_all'], $arr_flds['action']);
        }
        $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
        $th = $tbl->appendElement('thead')->appendElement('tr');
        foreach ($arr_flds as $key => $val) {
			if ('select_all' == $key) {
                $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $val . '" type="checkbox" onclick="selectAll( $(this) )" class="selectAll-js"></label>', true);
            } else {
                $e = $th->appendElement('th', array(), $val);
            }
        }

        $sr_no = ($page > 1) ? $recordCount - (($page - 1) * $pageSize) : $recordCount;
        foreach ($arr_listing as $sn => $row) {
            $tr = $tbl->appendElement('tr');
            $tr->setAttribute("id", $row['brand_id']);

            foreach ($arr_flds as $key => $val) {
                if ($key == "brand_logo") {
                    $td = $tr->appendElement('td', array('style' => 'text-align:center;'));
                } else {
                    $td = $tr->appendElement('td');
                }
                switch ($key) {
                    case 'select_all':
                        $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="brandIds[]" value=' . $row['brand_id'] . '></label>', true);
                        break;
                    case 'listserial':
                        $td->appendElement('plaintext', array(), $sr_no);
                        break;
                    case 'brand_logo':
                        $td->appendElement(
                            'plaintext',
                            array('style' => 'text-align:center'),
                            '<img class="max-img" src="' . UrlHelper::generateUrl('image', 'brand', array($row['brand_id'], $adminLangId, 'MINITHUMB'), CONF_WEBROOT_FRONT_URL) . '?q=' . strtotime($fileData['afile_updated_at']) . '">',
                            true
                        );
                        break;
                    case 'brand_identifier':
                        if ($row['brand_name'] != '') {
                            $strTxt = '<div class="title">' . $row['brand_name'].'<br><span class="text-muted form-text">(' . $row[$key] . ')</span></div>';
                        } else {
                            $strTxt = '<div class="title">' . $row[$key].'</div>';
                        }
                        $str = '<div class="brand-profile">
                                    <div class="brand-profile-thumbnail">
                                    <a target="_blank" href="' . UrlHelper::generateUrl('image', 'brand', array($row['brand_id'], $adminLangId, 'ORIGINAL'), CONF_WEBROOT_FRONT_URL) . '?t=' . time() . '">
                                        <img src="' . UrlHelper::generateUrl('image', 'brand', array($row['brand_id'], $adminLangId, 'MINITHUMB'), CONF_WEBROOT_FRONT_URL) . '?t=' . time() . '"/>
                                    </a>
                                </div>
                                <div class="brand-profile-data">
                                    '.$strTxt.'
                                </div>
                        </div>';
                    $td->appendElement('plaintext', array(), $str, true);
                        break;
                    case 'brand_active':
                        $active = "";
                        if ($row['brand_active']) {
                            $active = 'checked';
                        }
                        $statusAct = ($canEdit === true) ? 'toggleStatus(event,this,' . applicationConstants::YES . ')' : 'toggleStatus(event,this,' . applicationConstants::NO . ')';
                        $statusClass = ($canEdit === false) ? 'disabled' : '';
                        $str = '<label class="switch switch-sm switch-icon ' . $statusClass . '">
                        <input ' . $active . ' type="checkbox" id="switch' . $row['brand_id'] . '" value="' . $row['brand_id'] . '" onclick="' . $statusAct . '" class="switch-labels"/>
                        </label>';
                        $td->appendElement('plaintext', array(), $str, true);
                        break;
                    case 'action':
                        if ($canEdit) {

                            $actionArr = [
                                [
                                    "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                                    "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                                    "onclick" => "addBrandForm(" . $row['brand_id'] . ")"
                                ],
                                [
                                    "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                                    "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                                    "onclick" => "deleteRecord(" . $row['brand_id'] . ")"
                                ]
                            ];
                            $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$row['brand_id']], false);

                        }
                        break;
                    default:
                        $td->appendElement('plaintext', array(), $row[$key], true);
                        break;
                }
            }
            $sr_no--;
        }
    
        $frm = new Form('frmBrandListing', array('id' => 'frmBrandListing'));
        $frm->setFormTagAttribute('class', 'form web_form last_td_nowrap actionButtons-js');
        $frm->setFormTagAttribute('onsubmit', 'formAction(this, reloadList ); return(false);');
        $frm->setFormTagAttribute('action', UrlHelper::generateUrl('Brands', 'toggleBulkStatuses'));
        $frm->addHiddenField('', 'status');

        echo $frm->getFormTag();
        echo $frm->getFieldHtml('status');
        echo $tbl->getHtml();
        if (count($arr_listing) == 0) {
            $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
        }
        ?>
    </form>
</div>
    <?php $postedData['page'] = $page;
    echo FatUtility::createHiddenFormFromData($postedData, array(
        'name' => 'frmBrandSearchPaging'
    ));
    $pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
    $this->includeTemplate('_partial/pagination.php', $pagingArr, false);

