<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
$arr_flds = array(
    'dragdrop' => '',
    'select_all' => Labels::getLabel('LBL_Select_all', $adminLangId),
    // 'listserial' => Labels::getLabel('LBL_Display_Order', $adminLangId),
    'collection_identifier' => Labels::getLabel('LBL_Collection_Identifier/Name', $adminLangId),
    'collection_type' => Labels::getLabel('LBL_Type', $adminLangId),
    'collection_layout_type' => Labels::getLabel('LBL_Layout_Type', $adminLangId),
    'collection_active' => Labels::getLabel('LBL_Status', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);

if (!$canEdit || empty($arr_listing)) {
    unset($arr_flds['dragdrop']);
    unset($arr_flds['select_all']);
}
if (!$canEdit) {
    unset($arr_flds['action']);
}
$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified', 'id' => 'collectionList'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $key => $val) {
    if ('select_all' == $key) {
        $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $val . '" type="checkbox" onclick="selectAll( $(this) )" class="selectAll-js"></label>', true);
    } else {
        $e = $th->appendElement('th', array(), $val);
    }
}

$sr_no = $page == 1 ? 0 : $pageSize * ($page - 1);
foreach ($arr_listing as $sn => $row) {
    $sr_no++;
    $tr = $tbl->appendElement('tr');
    $tr->setAttribute("id", $row['collection_id']);

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'dragdrop':
                if ($row['collection_active'] == applicationConstants::ACTIVE) {
                    $td->appendElement('svg', array('width'=>'16','height'=>'16'),"<use xlink:href='".CONF_WEBROOT_FRONT_URL."images/admin/retina/sprite.svg#drag-move-2'></use>",true);
                    $td->setAttribute("class", 'dragHandle');
                }
                break;
            case 'select_all':
                $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="collection_ids[]" value=' . $row['collection_id'] . '></label>', true);
                break;
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'collection_identifier':
                $td->appendElement('plaintext', array(), $row['collection_name'] . '<br>', true);
                $td->appendElement('plaintext', array(), '(' . $row[$key] . ')', true);
                break;
            case 'collection_type':
                $td->appendElement('plaintext', array(), Collections::getTypeArr($adminLangId)[$row[$key]]);
                break;
            case 'collection_layout_type':
                $layoutName = (isset($layoutNameArr[$row[$key]])) ? $layoutNameArr[$row[$key]] : '';
                $td->appendElement('plaintext', array(), $layoutName);

                /* $td->appendElement('plaintext', array(), Collections::getLayoutTypeArr($adminLangId)[$row[$key]]); */
                break;
            case 'action':
                if ($canEdit) {

                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                            "onclick" => "collectionForm(" . $row['collection_type'] . "," . $row['collection_layout_type'] . "," . $row['collection_id'] . ")"
                        ],
                        [
                            "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                            "onclick" => "deleteRecord(" . $row['collection_id'] . ")"
                        ]
                    ];
                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$row['collection_id']], false);

                }
                break;
            case 'collection_active':
            case 'collection_active':
                $active = "";
                if ($row['collection_active']) {
                    $active = 'checked';
                }
                $statusAct = ($canEdit === true) ? 'toggleStatus(event,this,' . applicationConstants::YES . ')' : 'toggleStatus(event,this,' . applicationConstants::NO . ')';
                $statusClass = ($canEdit === false) ? 'disabled' : '';
                $str = '<label class="switch switch-sm switch-icon ' . $statusClass . '">
                <input ' . $active . ' type="checkbox" id="switch' . $row['collection_id'] . '" value="' . $row['collection_id'] . '" onclick="' . $statusAct . '" class="switch-labels"/>
                </label>';

                $td->appendElement('plaintext', array(), $str, true);
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}


$frm = new Form('frmCollectionListing', array('id' => 'frmCollectionListing'));
$frm->setFormTagAttribute('class', 'form web_form last_td_nowrap actionButtons-js');
$frm->setFormTagAttribute('onsubmit', 'formAction(this, reloadList ); return(false);');
$frm->setFormTagAttribute('action', UrlHelper::generateUrl('Collections', 'toggleBulkStatuses'));
$frm->addHiddenField('', 'status');

echo $frm->getFormTag();
echo $frm->getFieldHtml('status');
echo $tbl->getHtml(); 
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</form>
</div>
<?php
/* $postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData ( $postedData, array (
        'name' => 'frmCollectionSearchPaging'
) );
$pagingArr=array('pageCount'=>$pageCount,'page'=>$page,'recordCount'=>$recordCount,'adminLangId'=>$adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr,false); */
?>
<script>
    $(document).ready(function () {
        $('#collectionList').tableDnD({
            onDrop: function (table, row) {
                fcom.displayProcessing();
                var order = $.tableDnD.serialize('id');
                fcom.ajax(fcom.makeUrl('Collections', 'updateOrder'), order, function (res) {
                    var ans = $.parseJSON(res);
                    if (ans.status == 1) {
                        fcom.displaySuccessMessage(ans.msg);
                    } else {
                        fcom.displayErrorMessage(ans.msg);
                    }
                });
            },
            dragHandle: ".dragHandle",
        });
    });
</script>