<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
$arr_flds = array(
    'select_all' => Labels::getLabel('LBL_Select_all', $adminLangId),
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'commsetting_prodcat_id' => Labels::getLabel('LBL_Category', $adminLangId),
    'commsetting_user_id' => Labels::getLabel('LBL_Seller', $adminLangId),
    'commsetting_product_id' => Labels::getLabel('LBL_Product', $adminLangId),
    'commsetting_type' => Labels::getLabel('LBL_Type', $adminLangId),
    'commsetting_fees' => Labels::getLabel('LBL_Fees_[%]', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
if (!$canEdit) {
    unset($arr_flds['select_all']);
}
$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $key => $val) {
    if ('select_all' == $key) {
        $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $val . '" type="checkbox" onclick="selectAll( $(this) )" class="selectAll-js"></label>', true);
    } else {
        $e = $th->appendElement('th', array(), $val);
    }
}
// CommonHelper::printArray($arr_listing, true);
$sr_no = 0;
foreach ($arr_listing as $sn => $row) {
    $sr_no++;
    $tr = $tbl->appendElement('tr');
    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'select_all':
                if ($row['commsetting_is_mandatory'] != 1) {
                    $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="commsetting_ids[]" value=' . $row['commsetting_id'] . '></label>', true);
                }
                break;
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'commsetting_prodcat_id':
                $td->appendElement('plaintext', array(), CommonHelper::displayText($row['prodcat_name']), true);
                break;
            case 'commsetting_user_id':
                /* $td->appendElement('plaintext', array(), CommonHelper::displayText($row['vendor']), true); */
                $td->appendElement('a', array('href' => 'javascript:void(0)', 'onClick' => 'redirectfunc("' . UrlHelper::generateUrl('Users') . '", ' . $row['vendor_id'] . ')'), $row['vendor'], true);
                break;
            case 'commsetting_type':
                $typeStr = (isset($typesArr[$row['commsetting_type']])) ? $typesArr[$row['commsetting_type']] : Labels::getLabel('LBL_N/A', $adminLangId);
                $td->appendElement('plaintext', array(), $typeStr, true);
                break;
            case 'commsetting_product_id':
                $td->appendElement('plaintext', array(), CommonHelper::displayText($row['product_name']), true);
                break;
            case 'action':
                if ($canEdit) {

                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                            "onclick" => "editCommissionForm(" . $row['commsetting_id'] . ")"
                        ],
                        [
                            "title" => Labels::getLabel('LBL_History', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#history'></use></svg>",
                            "onclick" => "viewHistory(" . $row['commsetting_id'] . ")"
                        ]
                    ];

                    if ($row['commsetting_is_mandatory'] != 1) {
                        $actionArr[] = [
                            "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                            "onclick" => "deleteCommission(" . $row['commsetting_id'] . ")"
                        ];
                    }

                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$row['commsetting_id']], false);

                }
                break;
            default:
                $td->appendElement('plaintext', array(), CommonHelper::displayText($row[$key]), true);
                break;
        }
    }
}


$frm = new Form('frmCommissionListing', array('id' => 'frmCommissionListing'));
$frm->setFormTagAttribute('class', 'form web_form last_td_nowrap');
$frm->setFormTagAttribute('onsubmit', 'formAction(this, reloadList ); return(false);');
$frm->setFormTagAttribute('action', UrlHelper::generateUrl('Commission', 'deleteSelected'));
$frm->addHiddenField('', 'status');

echo $frm->getFormTag();
echo $frm->getFieldHtml('status');
echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</form>
</div>