<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$tabsIconArr = Configurations::getTabsIconArr();
?>
<div class='page'>
    <div class='content content-space'>
        <div class="row">
            <div class="col-lg-12 col-md-12 space">
                <div class="page-title">
                    <h5><?php echo Labels::getLabel('LBL_General_Settings', $adminLangId); ?>
                    </h5>
                    <?php $this->includeTemplate('_partial/header/header-breadcrumb.php'); ?>
                </div>
                <div class="grid-layout tabs_nav_container vertical">
                    <div class="grid-layout-left">
                        <div class="card">
                            <div class="card-body p-0">
                                <div class="settings-inner">
                                    <ul class="settings-nav">
                                        <?php
                                        $count = 1;
                                        foreach ($tabs as $formType => $tabName) {
                                            $tabsId = 'tabs_' . $count;
                                            ?>
                                            <?php if ($formType == Configurations::FORM_MEDIA || $formType == Configurations::FORM_SHARING) { ?>
                                                <li class="settings-inner-item">
                                                    <a class="settings-inner-link <?php echo ($activeTab == $formType) ? 'active' : '' ?>"
                                                        rel=<?php echo $tabsId; ?> href="javascript:void(0)"
                                                        data-text="<?php echo $tabName; ?>"
                                                        onClick="getLangForm(<?php echo $formType; ?>, <?php echo $formType != Configurations::FORM_MEDIA ? $adminLangId: 0; ?>, '<?php echo $tabsId; ?>')">

                                                        <i class="settings-inner-icn">
                                                            <svg class="svg" width="18" height="18">
                                                                <use
                                                                    xlink:href="<?php echo CONF_WEBROOT_FRONTEND; ?>images/admin/retina/sprite-settings.svg#<?php echo $tabsIconArr[$formType] ?>">
                                                                </use>
                                                            </svg>
                                                        </i>
                                                        <h6 class="settings-inner-title">
                                                            <?php echo $tabName; ?>
                                                        </h6>
                                                    </a>
                                                </li>
                                            <?php } elseif ($formType == Configurations::FORM_IMPORT_EXPORT) { ?>
                                                <li class="settings-inner-item">
                                                    <a class="settings-inner-link <?php echo ($activeTab == $formType) ? 'active' : '' ?>"
                                                        rel=<?php echo $tabsId; ?> href="javascript:void(0)"
                                                        data-text="<?php echo $tabName; ?>"
                                                        onClick="generalInstructions(<?php echo $formType; ?>)">
                                                        <i class="settings-inner-icn">
                                                            <svg class="svg" width="18" height="18">
                                                                <use
                                                                    xlink:href="<?php echo CONF_WEBROOT_FRONTEND; ?>images/admin/retina/sprite-settings.svg#<?php echo $tabsIconArr[$formType] ?>">
                                                                </use>
                                                            </svg></i>
                                                        <h6 class="settings-inner-title">
                                                            <?php echo $tabName; ?>
                                                        </h6>
                                                    </a>
                                                </li>
                                            <?php } else { ?>
                                                <li class="settings-inner-item">
                                                    <a class=" settings-inner-link <?php echo ($activeTab == $formType) ? 'active' : '' ?>"
                                                        rel=<?php echo $tabsId; ?> href="javascript:void(0)"
                                                        data-text="<?php echo $tabName; ?>"
                                                        onClick="getForm(<?php echo $formType; ?>, '<?php echo $tabsId; ?>')">
                                                        <i class="settings-inner-icn">
                                                            <svg class="svg" width="18" height="18">
                                                                <use
                                                                    xlink:href="<?php echo CONF_WEBROOT_FRONTEND; ?>images/admin/retina/sprite-settings.svg#<?php echo $tabsIconArr[$formType] ?>">
                                                                </use>
                                                            </svg>
                                                        </i>
                                                        <h6 class="settings-inner-title">
                                                            <?php echo $tabName; ?>
                                                        </h6>
                                                    </a>
                                                </li>
                                                <?php
                                            }
                                            $count++;
                                        }
                                        ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="grid-layout-right">
                        <div class="card" id="frmBlock"></div>
                    </div>
                </div>
                <!-- <sectioulclass="card section">
                        <div class="card-body">
                            <div class="table-responsive table-scrollable js-scrollable tablewrap">
                                <div id="frmBlock">
                <?php //echo Labels::getLabel('LBL_Processing...',$adminLangId); ?>
                                </div>
                            </div>
                        </div>
                    </sectioulclass=> -->
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    var YES = <?php echo applicationConstants::YES; ?>;
    var NO = <?php echo applicationConstants::NO; ?>;
    var FORM_MEDIA = <?php echo Configurations::FORM_MEDIA; ?>;
    var is_develop = "<?php echo ($isDevelop != '') ? $isDevelop : ""; ?>";
</script>