$(document).ready(function () {
    getForm(1,'tabs_1');

    $(document).on("click", "#testMail-js", function () {
        fcom.ajax(fcom.makeUrl('Configurations', 'testEmail'), '', function (t) {
            var ans = $.parseJSON(t);
            if (ans.status == 1) {
                fcom.displaySuccessMessage(ans.msg);
            } else {
                fcom.displayErrorMessage(ans.msg);
            }
        });
    });

    $(document).on("change", "select[name='CONF_TIMEZONE']", function () {
        var timezone = $("select[name='CONF_TIMEZONE']").val();
        fcom.ajax(fcom.makeUrl('Configurations', 'displayDateTime'), 'time_zone=' + timezone, function (t) {
            var ans = $.parseJSON(t);
            $('#currentDate').html(ans.dateTime);
        });
    });

    $(document).on("change", ".penalty-checkbox--js", function(){           
         if ($(this).is(':checked') && $(this).is('[checked]')) {
            $('#penalty-rules-link--js').attr('class', 'link-brand')
         } else {
            $('#penalty-rules-link--js').attr('class', 'disabled');
         }
    });
    
});

(function () {
    var currentPage = 1;
    var runningAjaxReq = false;
    var dv = '#frmBlock';
    getForm = function (frmType,frmName= '') {
        if(frmName == ''){
            var frmName  = $('.settings-nav .settings-inner-link.active').attr('rel');
        }
        
        
        fcom.resetEditorInstance();
        $(dv).html(fcom.getLoader());
        fcom.ajax(fcom.makeUrl('Configurations', 'form', [frmType,frmName, is_develop]), '', function (t) {
            $(dv).html(t);
            $('.settings-nav .settings-inner-link.active').removeClass('active');
            $('[rel="'+frmName+'"]').addClass('active');
            $('#cart-head-title-js').text($('[rel="'+frmName+'"]').data('text'));
            jscolor.installByClassName('jscolor');
            // window.scrollTo({
            //     top: 0,
            //     bc // Add smooth scrolling
            // });
            //fcom.closeProcessing();
        });
    };

    getLangForm = function (frmType, langId,frmName='', autoFillLangData = 0) {
        if(frmName == ''){
            var frmName  = $('.settings-nav .settings-inner-link.active').attr('rel');
        }
        fcom.resetEditorInstance();
        $(dv).html(fcom.getLoader());
        fcom.ajax(fcom.makeUrl('Configurations', 'langForm', [frmType, langId,frmName, autoFillLangData]), '', function (t) {
            $(dv).html(t);
            $('.settings-nav .settings-inner-link.active').removeClass('active');
            $('[rel="'+frmName+'"]').addClass('active');
            $('#cart-head-title-js').text($('[rel="'+frmName+'"]').data('text'));
            fcom.setEditorLayout(langId);
            if (frmType == FORM_MEDIA) {
                $('input[name=btn_submit]').hide();
            }
            var frm = $(dv + ' form')[0];
            var validator = $(frm).validation({
                errordisplay: 3
            });
            $(frm).submit(function (e) {
                e.preventDefault();
                if (validator.validate() == false) {
                    return;
                }
                var data = fcom.frmData(frm);
                fcom.updateWithAjax(fcom.makeUrl('Configurations', 'setupLang'), data, function (t) {
                    runningAjaxReq = false;
                    fcom.resetEditorInstance();
                    if (t.langId > 0 && t.shopId > 0) {
                        shopLangForm(t.shopId, t.langId);
                        return;
                    }
                });
            });
        });
        $.systemMessage.close();
    }

    setup = function (frm) {
		
		var formType = $("input[name='form_type']").val();
		var flag = 1;
		if(formType == 4) {
			var selRentalDurCount = 0;
			$("input[name='CONF_DURATION_TYPES[]']:checked").each(function (index, obj) {
				selRentalDurCount += 1;
			});
			if(selRentalDurCount < 1) {
				$('.duration-types-js').after('<ul class="errorlist duration-type-error"><li><a href="javascript:void(0);">'+langLbl.atleastOneRecord+'</a></li></ul>');
				flag = 0;
			}
		}
		
        if (!$(frm).validate()) {
			flag = 0;
        }
		
		if(flag == 0) {
			return;
		}
		
        var data = fcom.frmData(frm);
        fcom.updateWithAjax(fcom.makeUrl('Configurations', 'setup'), data, function (t) {
            if (t.langId > 0 && t.frmType > 0) {
                getLangForm(t.frmType, t.langId);
                return;
            }
            if (t.frmType > 0) {
                getForm(t.frmType);
                return;
            }
            $(document).trigger('close.facebox');
        });
    }

    setupLang = function (frm) {
        if (!$(frm).validate()) {
            return;
        }
        var data = fcom.frmData(frm);
        fcom.updateWithAjax(fcom.makeUrl('Configurations', 'setupLang'), data, function (t) {
            if (t.langId > 0 && t.frmType > 0) {
                getLangForm(t.frmType, t.langId);
                return;
            }
            if (t.frmType > 0) {
                getForm(t.frmType);
                return;
            }
            $(document).trigger('close.facebox');
        });
    }

    removeSiteAdminLogo = function (lang_id) {
        if (!confirm(langLbl.confirmDeleteImage)) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Configurations', 'removeSiteAdminLogo', [lang_id]), '', function (t) {
            getLangForm(document.frmConfiguration.form_type.value, lang_id);
        });
    };

    removeDesktopLogo = function (lang_id) {
        if (!confirm(langLbl.confirmDeleteImage)) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Configurations', 'removeDesktopLogo', [lang_id]), '', function (t) {
            getLangForm(document.frmConfiguration.form_type.value, lang_id);
        });
    };

    removeEmailLogo = function (lang_id) {
        if (!confirm(langLbl.confirmDeleteImage)) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Configurations', 'removeEmailLogo', [lang_id]), '', function (t) {
            getLangForm(document.frmConfiguration.form_type.value, lang_id);
        });
    };

    removeFavicon = function (lang_id) {
        if (!confirm(langLbl.confirmDeleteImage)) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Configurations', 'removeFavicon', [lang_id]), '', function (t) {
            getLangForm(document.frmConfiguration.form_type.value, lang_id);
        });
    };

    removeSocialFeedImage = function (lang_id) {
        if (!confirm(langLbl.confirmDeleteImage)) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Configurations', 'removeSocialFeedImage', [lang_id]), '', function (t) {
            getLangForm(document.frmConfiguration.form_type.value, lang_id);
        });
    };

    removePaymentPageLogo = function (lang_id) {
        if (!confirm(langLbl.confirmDeleteImage)) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Configurations', 'removePaymentPageLogo', [lang_id]), '', function (t) {
            getLangForm(document.frmConfiguration.form_type.value, lang_id);
        });
    };

    removeWatermarkImage = function (lang_id) {
        if (!confirm(langLbl.confirmDeleteImage)) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Configurations', 'removeWatermarkImage', [lang_id]), '', function (t) {
            getLangForm(document.frmConfiguration.form_type.value, lang_id);
        });
    };

    removeAppleTouchIcon = function (lang_id) {
        if (!confirm(langLbl.confirmDeleteImage)) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Configurations', 'removeAppleTouchIcon', [lang_id]), '', function (t) {
            getLangForm(document.frmConfiguration.form_type.value, lang_id);
        });
    };

    removeMobileLogo = function (lang_id) {
        if (!confirm(langLbl.confirmDeleteImage)) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Configurations', 'removeMobileLogo', [lang_id]), '', function (t) {
            getLangForm(document.frmConfiguration.form_type.value, lang_id);
        });
    };

    removeInvoiceLogo = function (lang_id) {
        if (!confirm(langLbl.confirmDeleteImage)) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Configurations', 'removeInvoiceLogo', [lang_id]), '', function (t) {
            getLangForm(document.frmConfiguration.form_type.value, lang_id);
        });
    };

    removeCollectionBgImage = function (lang_id) {
        if (!confirm(langLbl.confirmDeleteImage)) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Configurations', 'removeCollectionBgImage', [lang_id]), '', function (t) {
            getLangForm(document.frmConfiguration.form_type.value, lang_id);
        });
    };

    removeBrandCollectionBgImage = function (lang_id) {
        if (!confirm(langLbl.confirmDeleteImage)) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Configurations', 'removeBrandCollectionBgImage', [lang_id]), '', function (t) {
            getLangForm(document.frmConfiguration.form_type.value, lang_id);
        });
    };

    removeFirstPurchaseCoupon = function (lang_id) {
        if (!confirm(langLbl.confirmDeleteImage)) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Configurations', 'removeFirstPurchaseCoupon', [lang_id]), '', function (t) {
            getLangForm(document.frmConfiguration.form_type.value, lang_id);
        });
    };

    removeMetaImage = function (lang_id) {
        if (!confirm(langLbl.confirmDeleteImage)) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Configurations', 'removeMetaImage', [lang_id]), '', function (t) {
            getLangForm(document.frmConfiguration.form_type.value, lang_id);
        });
    };

    changedMessageAutoCloseSetting = function (val) {
        if (val == YES) {

        }
        if (val == NO) {
            $("input[name='CONF_TIME_AUTO_CLOSE_SYSTEM_MESSAGES']").val(0);
        }
    };

    generalInstructions = function (frmType) {
        fcom.resetEditorInstance();
        $(dv).html(fcom.getLoader());
        fcom.ajax(fcom.makeUrl('Configurations', 'generalInstructions', [frmType]), '', function (t) {
            $(dv).html(t);
        });
    };

    removeAppMainScreenImage = function (lang_id) {
        if (!confirm(langLbl.confirmDeleteImage)) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Configurations', 'removeAppMainScreenImage', [lang_id]), '', function (t) {
            getLangForm(document.frmConfiguration.form_type.value, lang_id);
        });
    };
    removeAppLogo = function (lang_id) {
        if (!confirm(langLbl.confirmDeleteImage)) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Configurations', 'removeAppLogo', [lang_id]), '', function (t) {
            getLangForm(document.frmConfiguration.form_type.value, lang_id);
        });
    };

    popupImage = function (inputBtn) {
        if (inputBtn.files && inputBtn.files[0]) {
            fcom.ajax(fcom.makeUrl('Configurations', 'imgCropper'), '', function (t) {
                var file = inputBtn.files[0];
                if(!file){
                    return false;
                }
                loadCropperSkeleton();
                t = $.parseJSON(t);
                $("#modalBoxJs .modal-body").html(t.body);
                $("#modalBoxJs .modal-footer").html(t.footer);
                
                var minWidth = $(inputBtn).attr('data-min_width');
                var minHeight = $(inputBtn).attr('data-min_height');
                if ($(inputBtn).attr('data-file_type') == 21) {
                    aspectRatio = 1;
                }
                var options = {
                    aspectRatio: aspectRatio,
                    data: {
                        width: minWidth,
                        height: minHeight,
                    },
                    minCropBoxWidth: minWidth,
                    minCropBoxHeight: minHeight,
                    minContainerHeight: 350,
                    toggleDragModeOnDblclick: false,
                    imageSmoothingQuality: 'high',
                    imageSmoothingEnabled: true,
                };
                if(aspectRatio.toString() == ""){
                    delete options.aspectRatio;
                    delete options.minCropBoxWidth;
                    delete options.minCropBoxHeight;
                }
                $(inputBtn).val('');
                setTimeout(function () { cropImage(file, options, "uploadConfImages", inputBtn) }, 200);
                return ;
            });
        }
    };

    uploadConfImages = function (formData) {
        var langId = document.frmConfiguration.lang_id.value;
        var formType = document.frmConfiguration.form_type.value;
        var fldName = "ratio_type_" + formData.get('file_type');
        var ratio_type = $('input[name="' + fldName + '"]:checked').val();

        formData.append('lang_id', langId);
        formData.append('form_type', formType);
        formData.append('ratio_type', ratio_type);
        $.ajax({
            url: fcom.makeUrl('Configurations', 'uploadMedia'),
            type: 'post',
            dataType: 'json',
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            beforeSend: function () {
                $('#loader-js').html(fcom.getLoader());
            },
            complete: function () {
                $('#loader-js').html(fcom.getLoader());
            },
            success: function (ans) {
                if (!ans.status) {
                    fcom.displaySuccessMessage(ans.msg);
                    return;
                }
                fcom.displaySuccessMessage(ans.msg);
                getLangForm(formType, langId);
                $("#modalBoxJs").modal("hide");
            },
            error: function (xhr, ajaxOptions, thrownError) {
                if (xhr.responseText) {
                    fcom.displayErrorMessage(xhr.responseText);
                    return;
                }
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    }

    deleteVerificationFile = function (fileType) {
        if (!confirm(langLbl.confirmDelete)) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Configurations', 'deleteVerificationFile', [fileType]), '', function (t) {
            getForm(document.frmConfiguration.form_type.value);
        });
    };

})();


form = function (form_type) {
    if (typeof form_type == undefined || form_type == null) {
        form_type = 1;
    }
    jQuery.ajax({
        type: "POST",
        data: {
            form: form_type,
            fIsAjax: 1
        },
        url: fcom.makeUrl("configurations", "form"),
        success: function (json) {
            json = $.parseJSON(json);
            if ("1" == json.status) {
                $("#tabs_0" + form_type).html(json.msg);
            } else {
                jsonErrorMessage(json.msg)
            }
        }
    });
}

submitForm = function (form, v) {
    $(form).ajaxSubmit({
        delegation: true,
        beforeSubmit: function () {
            v.validate();
            if (!v.isValid()) {
                return false;
            }
        },
        success: function (json) {
            json = $.parseJSON(json);

            if (json.status == "1") {
                jsonSuccessMessage(json.msg)

            } else {
                jsonErrorMessage(json.msg);
            }
        }
    });
    return false;
}

getCountryStates = function (countryId, stateId, dv) {
    fcom.displayProcessing();
    fcom.ajax(fcom.makeUrl('Configurations', 'getStates', [countryId, stateId]), '', function (res) {
        $(dv).empty();
        $(dv).append(res);
        fcom.closeProcessing();
    });
    $.systemMessage.close();
};

updateVerificationFile = function (inputBtn, fileType) {
    var formData = new FormData();
    formData.append('fileType', fileType);
    var file = inputBtn.files[0];
    if(!file){
        return false;
    }
    
    if (inputBtn.files && inputBtn.files[0]) {
        var file = inputBtn.files[0];
        fcom.displayProcessing(langLbl.processing, ' ', true);
        formData.append('verification_file', file);
        $.ajax({
            url: fcom.makeUrl('Configurations', 'updateVerificationFile'),
            type: 'post',
            dataType: 'json',
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            success: function (ans) {
                if (!ans.status) {
                    fcom.displayErrorMessage(ans.msg);
                    return;
                }
                fcom.displaySuccessMessage(ans.msg);
                getForm(document.frmConfiguration.form_type.value);
                $(document).trigger('close.facebox');
                fcom.closeProcessing();
            },
            error: function (xhr, ajaxOptions, thrownError) {
                if (xhr.responseText) {
                    fcom.displayErrorMessage(xhr.responseText);
                    return;
                }
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    }
}
analyticsSettings = function(exPageId) {
    $.bootstrapModal(function() {
        fcom.displayProcessing();
        data = 'exPageId=' + exPageId;
        fcom.ajax(fcom.makeUrl('Configurations', 'analyticsSettings'), data, function(t) {
            fcom.updateFaceboxContent(t);
            fcom.closeProcessing();
        });
    });
};
function stylePhoneNumberFld(element = "input[name='user_phone']", destroy = false, fax = false) {
    var inputList = document.querySelectorAll(element);
    var country = ('' == langLbl.defaultCountryCode || undefined == langLbl.defaultCountryCode ) ? 'in' : langLbl.defaultCountryCode;
    var country2 = ('' == langLbl.defaultCountryCode2 || undefined == langLbl.defaultCountryCode2 ) ? 'in' : langLbl.defaultCountryCode2;
    inputList.forEach(function (input) {
        if (true == destroy) {
            $(input).removeAttr('style');
            var clone = input.cloneNode(true);
            $('.iti').replaceWith(clone);
        } else {

            if(fax == false) {
                var iti = window.intlTelInput(input, {
                    separateDialCode: true,
                    initialCountry: country,
                });

                $('<input>').attr({
                    type: 'hidden',
                    name: 'CONF_SITE_PHONE_CODE',
                    value: "+" + iti.getSelectedCountryData().dialCode
                }).insertAfter(input);

                $('<input>').attr({
                    type: 'hidden',
                    name: 'CONF_SITE_PHONE_ISO',
                    value: iti.getSelectedCountryData().iso2
                }).insertAfter(input);
               
            }else {

                var iti = window.intlTelInput(input, {
                    separateDialCode: true,
                    initialCountry: country2,
                });

                $('<input>').attr({
                    type: 'hidden',
                    name: 'CONF_SITE_FAX_CODE',
                    value: "+" + iti.getSelectedCountryData().dialCode
                }).insertAfter(input);

                $('<input>').attr({
                    type: 'hidden',
                    name: 'CONF_SITE_FAX_ISO',
                    value: iti.getSelectedCountryData().iso2
                }).insertAfter(input);
    
            }
            
            input.addEventListener('countrychange', function (e) {
                if (typeof iti.getSelectedCountryData().dialCode !== 'undefined') {
                    if(fax == false) {
                        input.closest('form').CONF_SITE_PHONE_CODE.value = "+" + iti.getSelectedCountryData().dialCode;
                        input.closest('form').CONF_SITE_PHONE_ISO.value = iti.getSelectedCountryData().iso2;
                    }else {
                        input.closest('form').CONF_SITE_FAX_CODE.value = "+" + iti.getSelectedCountryData().dialCode;
                        input.closest('form').CONF_SITE_FAX_ISO.value = iti.getSelectedCountryData().iso2;
                    }
                }
            });
        }
    });
}


$(document).on('click', '.uploadFile-pwa-Js', function(e) {
    e.preventDefault();
    // e.preventDefault();
    let timer = new Date();
    $('#form-upload').remove();
    var node = this;
    var file_type = $(node).attr('data-file_type');

    var frm = `<form enctype="multipart/form-data" id="form-upload" style="position:absolute; top:-100px;" >
<input type="file" name="cropped_image" accept=".jpg,.jpeg,.png"   />
<input type="hidden" name="file_type" value="${file_type}"/>
</form>`;

    $('body').prepend(frm);

    $('#form-upload input[name="cropped_image"]').trigger('click');

    // if (typeof timer != 'undefined') {
    //     clearInterval(timer);
    // }


    timer = setInterval(function() {
        if ($('#form-upload input[name="cropped_image"]').val() != '') {
            clearInterval(timer);

            var fileInput = $('#form-upload input[name="cropped_image"]')[0];
            var file = fileInput.files[0];
            var allowedFileTypes = ['image/jpeg', 'image/png'];
            if (!allowedFileTypes.includes(file.type)) {
                fcom.displayErrorMessage('WebP image not allowed.');
                $('#form-upload').remove();
                return;
            }

            console.log(timer);
            $val = $(node).val();
            $.ajax({
                url: fcom.makeUrl('Configurations', 'uploadMedia'),
                type: 'post',
                dataType: 'json',
                async: false,
                data: new FormData($('#form-upload')[0]),
                cache: false,
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $(node).val('Loading');
                },
                complete: function() {
                    $(node).val($val);
                    $('#form-upload').remove();
                },
                success: function(ans) {
                    if (ans.status == true) {
                        const d = new Date();
                        let url = fcom.makeUrl('image', 'pwaImage', [file_type]) + "?t=" + d.getTime();
                        $(".uploaded--image--" + file_type).html(`<img src="${url}">`);
                        fcom.displaySuccessMessage(ans.msg);
                    } else {
                        fcom.displayErrorMessage(ans.msg);
                    }
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
                }
            });
        }
    }, 100);
});