<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>


<div class="tabs_body form">
    <div class="row">
        <div class="col-md-8">
            <div class="row">
                <div class="col-md-12">
                    <div class="field-set">
                        <div class="caption-wraper">
                            <label class="form-label">
                                <?php echo Labels::getLabel('LBL_Add_Associated_Product_Option_Groups', $adminLangId); ?></label>
                        </div>
                        <div class="field-wraper">
                            <div class="field_cover">
                                <?php
                                $optionData = array();
                                foreach ($productOptions as $key => $data) {
                                    $optionData[$key]['id'] = $data['option_id'];
                                    $optionData[$key]['value'] = $data['option_name'] . '(' . $data['option_identifier'] . ')';
                                }
                                ?>
                                <input type="text" name="option_groups"
                                    value='<?php echo htmlspecialchars(json_encode($optionData)); ?>'>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-md-12 mb-4" id="upc-listing"> </div>
            </div>
        </div>
        <?php
        $tagData = array();
        foreach ($productTags as $key => $data) {
            $tagData[$key]['id'] = $data['tag_id'];
            $tagData[$key]['value'] = $data['tag_identifier'];
        }
        ?>
        <div class="col-md-4">
            <div class="row">
                <div class="col-md-12">
                    <div class="field-set">
                        <div class="caption-wraper">
                            <label
                                class="form-label"><?php echo Labels::getLabel('LBL_Product_Tags', $adminLangId); ?></label>
                        </div>
                        <div class="field-wraper">
                            <div class="field_cover">
                                <input class="tag_name" type="text" name="tag_name" id="get-tags"
                                    value='<?php echo htmlspecialchars(json_encode($tagData), ENT_QUOTES, 'UTF-8'); ?>'>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row tabs_footer">
    <div class="col-6">
        <div class="field-set">
            <div class="caption-wraper"><label class="form-label"></label></div>
            <div class="field-wraper">
                <div class="field_cover">
                    <input type="button" class="btn btn-outline-brand"
                        onClick="productAttributeAndSpecificationsFrm(<?php echo $preqId; ?>)"
                        value="<?php echo Labels::getLabel('LBL_Back', $adminLangId); ?>">
                </div>
            </div>
        </div>
    </div>
    <div class="col-6 text-right">
        <div class="field-set">
            <div class="caption-wraper"><label class="form-label"></label></div>
            <div class="field-wraper">
                <div class="field_cover">
                    <input type="hidden" name="preq_id" value="<?php echo $preqId; ?>">
                    <input type="button" class="btn btn-brand" onClick="productShipping(<?php echo $preqId; ?>)"
                        value="<?php echo Labels::getLabel('LBL_Save_And_Next', $adminLangId); ?>">
                </div>
            </div>
        </div>
    </div>
</div>


<script type="text/javascript">
    $("document").ready(function () {
        var preq_id = '<?php echo $preqId; ?>';

        upcListing(preq_id);

        addTagData = function (e) {
            var tag_id = e.detail.tag.id;
            var tag_name = e.detail.tag.title;
            if (tag_id == '') {
                var data = 'tag_id=0&tag_identifier=' + tag_name;
                var o = $.extend(true, {
                    fOutMode: 'json'
                });
                fcom.ajax(fcom.makeUrl('Tags', 'setup'), data, function (t) {
                    if (t.status != 1) {
                        tagify.removeTags(e.detail.tag);
                        $(document).trigger('close.mbsmessage');
                        fcom.displayErrorMessage(t.msg);
                        return false;
                    }
                    var dataLang = 'tag_id=' + t.tagId + '&tag_name=' + tag_name + '&lang_id=0';
                    fcom.updateWithAjax(fcom.makeUrl('Tags', 'langSetup'), dataLang, function (t2) {
                        fcom.updateWithAjax(fcom.makeUrl('CustomProducts',
                            'updateCustomCatalogTag'), 'preq_id=' + preq_id +
                            '&tag_id=' + t.tagId,
                            function (t3) {
                                $(e.detail.tag).attr('id', t.tagId);
                            });
                    });
                }, o);
            } else {
                fcom.updateWithAjax(fcom.makeUrl('CustomProducts', 'updateCustomCatalogTag'), 'preq_id=' +
                    preq_id + '&tag_id=' + tag_id,
                    function (t) { });
            }
        }
        removeTagData = function (e) {
            var tag_id = e.detail.tag.id;
            if (tag_id == '') {
                return false;
            }
            removeProductTag(preq_id, tag_id);
        }


        getTagsAutoComplete = function (e) {
            var keyword = e.detail.value;
            tagify.loading(true).dropdown.hide.call(tagify)
            var list = [];
            fcom.ajax(fcom.makeUrl('CustomProducts', 'tagsAutoComplete'), {
                keyword: keyword
            }, function (t) {
                var ans = $.parseJSON(t);
                for (i = 0; i < ans.length; i++) {
                    list.push({
                        "id": ans[i].id,
                        "value": ans[i].tag_identifier,
                    });
                }
                tagify.settings.whitelist = list;
                tagify.loading(false).dropdown.show.call(tagify, keyword);
            });
        }

        tagify = new Tagify(document.querySelector('input[name=tag_name]'), {
            whitelist: [],
            delimiters: "#",
            editTags: false,
        }).on('add', addTagData).on('remove', removeTagData).on('input', getTagsAutoComplete);



        addOption = function (e) {
            var option_id = e.detail.tag.id;
            if (option_id == '') {
                $(e.detail.tag).remove();
            } else {
                updateProductOption(preq_id, option_id, e);
            }
        }

        removeOption = function (e) {
            var option_id = e.detail.tag.id;
            removeProductOption(preq_id, option_id);
        }


        getOptionsAutoComplete = function (e) {
            var keyword = e.detail.value;
            tagifyOption.loading(true).dropdown.hide.call(tagifyOption);
            var listOptions = [];
            fcom.ajax(fcom.makeUrl('CustomProducts', 'autoCompleteOptions', [<?php echo $preq_user_id; ?>]), {
                keyword: keyword
            }, function (t) {
                var ans = $.parseJSON(t);
                for (i = 0; i < ans.length; i++) {
                    listOptions.push({
                        "id": ans[i].id,
                        "value": ans[i].name + '(' + ans[i].option_identifier + ')',
                    });
                }
                tagifyOption.settings.whitelist = listOptions;
                tagifyOption.loading(false).dropdown.show.call(tagifyOption, keyword);
            });

        };
        tagifyOption = new Tagify(document.querySelector('input[name=option_groups]'), {
            whitelist: [],
            delimiters: "#",
            editTags: false,
        }).on('add', addOption).on('remove', removeOption).on('input', getOptionsAutoComplete);

    });
</script>