<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
$arr_flds = array(
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'product_identifier' => Labels::getLabel('LBL_Product', $adminLangId),
    'shop_name' => Labels::getLabel('LBL_Shop', $adminLangId),
    'preq_added_on' => Labels::getLabel('LBL_Added_on', $adminLangId),
    'preq_requested_on' => Labels::getLabel('LBL_Requested_on', $adminLangId),
    'preq_status' => Labels::getLabel('LBL_Status', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId)
);
if (!$canEdit) {
    unset($arr_flds['action']);
}

$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-justified'));
$th = $tbl->appendElement('thead')->appendElement('tr', array('class' => 'hide--mobile'));
foreach ($arr_flds as $val) {
    $e = $th->appendElement('th', array(), $val);
}

$sr_no = ($page > 1) ? $recordCount - (($page - 1) * $pageSize) : $recordCount;
foreach ($arr_listing as $sn => $row) {
    $tr = $tbl->appendElement('tr', array('class' => ''));

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'product_identifier':
                $html = '<div class="item">
                <div class="item__description">
                    <div class="item__title">' . $row['product_name'] . '</div>
                    <div class="item__brand"> (' . $row[$key] . ') </div>
                </div></div>';
                $td->appendElement('plaintext', array(), $html, true);
                break;
            case 'shop_name':
                $shopName = "<a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Shops') . "\", " . $row['shop_id'] . ")'>" . $row['shop_name'] . "</a>";
                $td->appendElement('plaintext', array(), $shopName . '<br>', true);
                /* if ($row['shop_name'] > 0) { */
                $userName = "<a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Users') . "\", " . $row['user_id'] . ")'>" . $row['user_name'] . "</a>";
                $td->appendElement('plaintext', array(), '(' . (!empty($row['shop_name']) ? $userName : Labels::getLabel('LBL_ADMIN', $adminLangId)) . ')', true);
                /* } */
                break;
            case 'preq_status':
                $statusHtml = HtmlHelper::getStatusHtml($row[$key], $reqStatusArr[$row[$key]]);
                $statusHtml .= '<br>';
                $statusHtml .= '<span class="date text--small form-text text-muted">' . FatDate::Format($row['preq_status_updated_on']) . '</span>';
                $td->appendElement('plaintext', [], $statusHtml, true);
                break;
            case 'preq_added_on':
                $date = FatDate::format($row[$key]);
                $dateHtml = "";
                if (strpos($date, ' ') !== false) {
                    list($formattedDate, $formattedTime) = explode(' ', $date);
                    $dateHtml = "<date class='date'>" . $formattedDate . " <time>" . $formattedTime . "</time></date>";
                } else {
                    $dateHtml = "<date class='date'>" . $date . "</date>";
                }
                $td->appendElement('plaintext', array(), $dateHtml, true);
                break;
            case 'preq_requested_on':
                $date = FatDate::format($row[$key]);
                $dateHtml = "";
                if (strpos($date, ' ') !== false) {
                    list($formattedDate, $formattedTime) = explode(' ', $date);
                    $dateHtml = "<date class='date'>" . $formattedDate . " <time>" . $formattedTime . "</time></date>";
                } else {
                    $dateHtml = "<date class='date'>" . $date . "</date>";
                }
                $td->appendElement('plaintext', array(), $dateHtml, true);
                break;
            case 'action':
                if ($row['preq_status'] != ProductRequest::STATUS_APPROVED) {
                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                            "href" => UrlHelper::generateUrl('CustomProducts', 'Form', array($row['preq_id']))
                        ],
                        [
                            "title" => Labels::getLabel('LBL_Images', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#multi-image'></use></svg>",
                            "onclick" => "productImagesForm(" . $row['preq_id'] . ")"
                        ],
                        [
                            "title" => Labels::getLabel('LBL_Change_Status', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#toggle-off'></use></svg>",
                            "onclick" => 'updateStatusForm(' . $row['preq_id'] . ')'
                        ]
                    ];
                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['preq_id']], false);
                }
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
    $sr_no--;
}
echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</div>
<?php
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmCustomProdReqSrchPaging'));

$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId, 'callBackJsFunc' => 'goToCustomCatalogProductSearchPage');
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
