<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php
$arr_flds = array(
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'user' => Labels::getLabel('LBL_User', $adminLangId),
    'type' => Labels::getLabel('LBL_User_Type', $adminLangId),
    'user_regdate' => Labels::getLabel('LBL_Reg._Date', $adminLangId),
    'credential_verified' => Labels::getLabel('LBL_verified', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $val) {
    $e = $th->appendElement('th', array(), $val);
}

$sr_no = $page == 1 ? 0 : $pageSize * ($page - 1);
foreach ($arr_listing as $sn => $row) {

    $sr_no++;
    $tr = $tbl->appendElement('tr', array());

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'user':
                $userDetail = '<strong>' . Labels::getLabel('LBL_N:', $adminLangId) . ' </strong>' . $row['user_name'] . '<br/>';
                $userDetail .= '<strong>' . Labels::getLabel('LBL_UN:', $adminLangId) . ' </strong>' . $row['credential_username'] . '<br/>';
                $userDetail .= '<strong>' . Labels::getLabel('LBL_Email:', $adminLangId) . ' </strong>' . $row['credential_email'] . '<br/>';
                $userDetail .= '<strong>' . Labels::getLabel('LBL_User_ID:', $adminLangId) . ' </strong>' . $row['user_id'] . '<br/>';
                $td->appendElement('plaintext', array(), $userDetail, true);
                break;
            case 'user_regdate':
                $td->appendElement('plaintext', array(), FatDate::format(
                    $row[$key],
                    true,
                    true,
                    FatApp::getConfig('CONF_TIMEZONE', FatUtility::VAR_STRING, date_default_timezone_get())
                ));
                break;
            case 'type':
                $str = '';
                $arr = User::getUserTypesArr($adminLangId);
                if ($row['user_is_buyer']) {
                    $str .= '<li class="chip buyer">' . $arr[User::USER_TYPE_BUYER] . '</li>';
                }
                if ($row['user_is_supplier']) {
                    $str .= '<li class="chip supplier">' . $arr[User::USER_TYPE_SELLER] . '</li>';
                }
                if ($row['user_is_advertiser']) {
                    $str .= '<li class="chip advertiser">' . $arr[User::USER_TYPE_ADVERTISER] . '</li>';
                }
                /* if ($row['user_is_affiliate']) {
                    $str .= '<li class="chip affiliate">' . $arr[User::USER_TYPE_AFFILIATE] . '</li>';
                } */

                if ($str == '' && $row['user_registered_initially_for'] != 0) {
                    $str = '<li class="chip "><span class="badge badge-danger">Signing Up For: ' . User::getUserTypesArr($adminLangId)[$row['user_registered_initially_for']] . '</span></li>';
                }

                $td->appendElement('plaintext', array(), '<ul class="chips">' . $str . '</ul>', true);

                break;
            case 'credential_verified':
                $yesNoArr = applicationConstants::getYesNoArr($adminLangId);
                $td->appendElement('plaintext', array(), $yesNoArr[$row[$key]], true);
                break;
            case 'action':
                if ($canEdit) {
                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_Restore_User', $adminLangId),
                            "icon" => '<svg class="svg" width="18" height="18"><use xlink:href="'.CONF_WEBROOT_FRONT_URL.'images/admin/retina/sprite-actions.svg#recycle"></use></svg>',
                            "onclick" => "restoreUser(" . $row['user_id'] . ")"
                        ]
                    ];
                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['user_id']], false);
                }
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}

echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmDeletedUserSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'pageSize' => $pageSize, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
?>