<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$frmCategory->setFormTagAttribute('class', 'form web_form form_horizontal');
$frmCategory->developerTags['colClassPrefix'] = 'col-md-';
$frmCategory->developerTags['fld_default_col'] = 12;
$fld = $frmCategory->getField('category_name');
$fld->setWrapperAttribute('class', 'ui-front');
$recordId = $coupon_id;
$tabsButtons = [
	[
		'attr' => [
			'onclick' => 'couponLinkProductForm(' . $recordId . ');',
			'title' => Labels::getLabel('LBL_Link_Products', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Link_Products', $adminLangId),
		'isActive' => false
	],
	[
		'attr' => [
			'onclick' => 'couponLinkCategoryForm(' . $recordId . ');',
			'title' => Labels::getLabel('LBL_Link_Categories', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Link_Categories', $adminLangId),
		'isActive' => true
	],
	[
		'attr' => [
			'onclick' => 'couponLinkUserForm(' . $recordId . ');',
			'title' => Labels::getLabel('LBL_Link_Users', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Link_Users', $adminLangId),
		'isActive' => false
	],
	[
		'attr' => [
			'onclick' => 'couponLinkShopForm(' . $recordId . ');',
			'title' => Labels::getLabel('LBL_Link_Shops', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Link_Shops', $adminLangId),
		'isActive' => false
	],
	[
		'attr' => [
			'onclick' => 'couponLinkBrandForm(' . $recordId . ');',
			'title' => Labels::getLabel('LBL_Link_Brands', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Link_Brands', $adminLangId),
		'isActive' => false
	],
];
$formTitle = Labels::getLabel('LBL_Coupon_Setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>
<?php echo $frmCategory->getFormHtml(); ?>
<div id="coupon_categories_list" class="col-xs-9 box-scroller"></div>


<script type="text/javascript">
	$("document").ready(function () {
		reloadCouponCategory(<?php echo $coupon_id; ?>);

		$('input[name=\'category_name\']').autocomplete({
			'classes': {
				"ui-autocomplete": "custom-ui-autocomplete"
			},
			'source': function (request, response) {
				$.ajax({
					url: fcom.makeUrl('ProductCategories', 'autoComplete'),
					data: {
						keyword: request['term'],
						fIsAjax: 1
					},
					dataType: 'json',
					type: 'post',
					success: function (json) {
						response($.map(json, function (item) {
							return {
								label: item['name'],
								value: item['name'],
								id: item['id']
							};
						}));
					},
				});
			},
			select: function (event, ui) {
				updateCouponCategory(<?php echo $coupon_id; ?>, ui.item.id);
				$('input[name=\'category_name\']').val('');
				return false;
			}
		});

	});
</script>


<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>