<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$spPlanFrm->setFormTagAttribute('class', 'form web_form form_horizontal');
$spPlanFrm->developerTags['colClassPrefix'] = 'col-md-';
$spPlanFrm->developerTags['fld_default_col'] = 12;
$fld = $spPlanFrm->getField('plan_name');
$fld->setWrapperAttribute('class', 'ui-front');
$recordId = $coupon_id;
$tabsButtons = [
	[
		'attr' => [
			'onclick' => 'couponLinkPlanForm(' . $recordId . ');',
			'title' => Labels::getLabel('LBL_Link_Products', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Link_Plan', $adminLangId),
		'isActive' => true
	],
];

require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>

<?php echo $spPlanFrm->getFormHtml(); ?>
<div id="coupon_plans_list" class="col-xs-9 box-scroller"></div>

<script type="text/javascript">
	$("document").ready(function () {
		reloadCouponPlan(<?php echo $coupon_id; ?>);

		$('input[name=\'plan_name\']').autocomplete({
			'classes': {
				"ui-autocomplete": "custom-ui-autocomplete"
			},
			'source': function (request, response) {
				$.ajax({
					url: fcom.makeUrl('SellerPackages', 'autoComplete'),
					data: { keyword: request['term'], fIsAjax: 1 },
					dataType: 'json',
					type: 'post',
					success: function (json) {
						response($.map(json, function (item) {
							return { label: item['name'], value: item['name'], id: item['id'] };
						}));
					},
				});
			},
			'select': function (event, ui) {
				updateCouponPlan(<?php echo $coupon_id; ?>, ui.item.id);
				$('input[name=\'plan_name\']').val('');
				return false;
			}
		});

	});
</script>

<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>