<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
?>
<div class='page'>
    <div class='content content-space'>
        <div class="row">
            <div class="col-lg-12 col-md-12 space">
                <div class="page-title">
                    <div class="row">
                        <div class="col--first col-lg-12">

                            <h5><?php echo Labels::getLabel('LBL_Manage_FAQs', $adminLangId); ?>
                            </h5>
                            <div class="breadcrumb-wrap">
                                <?php $this->includeTemplate('_partial/header/header-breadcrumb.php'); ?>
                                <a href="javascript:void(0)" class="btn btn-icon btn-outline-brand" onclick="addFaqForm('<?php echo $faqcat_id; ?>',0)" title="<?php echo Labels::getLabel('LBL_Add_Faq', $adminLangId); ?>" data-bs-toggle="tooltip" data-placement="top" data-bs-original-title="<?php echo Labels::getLabel('LBL_Add_Faq', $adminLangId); ?>">
                                    <svg class="svg bi-plus-circle" xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"></path>
                                        <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4"></path>
                                    </svg>
                                    <span><?php echo Labels::getLabel('Lbl_New', $adminLangId) ?></span>        
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <section class="card searchform_filter advance-search">
                    <div class="card-head">
                        <h4> <?php echo Labels::getLabel('LBL_Search...', $adminLangId); ?>
                        </h4>
                    </div>
                    <div class="card-body extra togglewrap">
                        <?php
                        $srchFrm->setFormTagAttribute('onsubmit', 'searchFaqs(this); return(false);');
                        $srchFrm->setFormTagAttribute('class', 'form web_form');
                        $srchFrm->developerTags['colClassPrefix'] = 'col-md-';
                        $srchFrm->developerTags['fld_default_col'] = 6;
                        echo $srchFrm->getFormHtml();
                        ?>
                    </div>
                </section>
                <section class="card section">
                    <div class="card-head">
                        <h4>
                            <?php $url = UrlHelper::generateUrl('FaqCategories'); ?>
                            <a class="btn-back" href="javascript:void(0)" onclick="redirectUrl('<?php echo $url; ?>')">
                                <svg class="svg" width="24" height="24">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_FRONTEND; ?>images/admin/retina/sprite-actions.svg#back">
                                    </use>
                                </svg>
                            </a>
                            <?php echo Labels::getLabel('LBL_Faq_List', $adminLangId); ?>
                        </h4>

                        <?php

                        $data = [
                            'adminLangId' => $adminLangId,
                            'statusButtons' => false,
                            'deleteButton' => false,
                            'otherButtons' => [
                                /*  [
                                     'attr' => [
                                         'href' => 'javascript:void(0)',
                                         'onclick' => "redirectUrl('" . $url . "')",
                                         'title' => Labels::getLabel('LBL_BACK', $adminLangId)
                                     ],
                                     'label' => '<i class="fas fa-arrow-left"></i>'
                                 ], */
                            ]
                        ];

                        if ($canEdit) {
                            /* $data['otherButtons'][] = [
                                'attr' => [
                                    'href' => 'javascript:void(0)',
                                    'onclick' => "addFaqForm('" . $faqcat_id . "',0)",
                                    'title' => Labels::getLabel('LBL_Add_Faq', $adminLangId)
                                ],
                                'label' => '<svg class="svg bi-plus-circle" xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"></path>
                                    <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4"></path>
                                </svg>'
                            ]; */
                        }

                        $this->includeTemplate('_partial/action-buttons.php', $data, false);
                        ?>
                    </div>
                    <div class="card-table">
                        <div class="table-responsive table-scrollable js-scrollable tablewrap">
                            <div id="listing"> <?php echo Labels::getLabel('LBL_Processing...', $adminLangId); ?>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
</div>