<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
$arr_flds = array(
    'message_sent_by_username' => Labels::getLabel('LBL_From', $adminLangId),
    'message_sent_to_name' => Labels::getLabel('LBL_To', $adminLangId),
    'thread_subject' => Labels::getLabel('LBL_Subject', $adminLangId),
    'message_text' => Labels::getLabel('LBL_Message', $adminLangId),
    'message_date' => Labels::getLabel('LBL_Date', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);

$tbl = new HtmlElement('table', array('class' => 'table table-hovered table-justified', 'id' => 'post'));
$th = $tbl->appendElement('thead')->appendElement('tr', array('class' => 'tr--first'));
foreach ($arr_flds as $val) {
    $e = $th->appendElement('th', array(), $val);
}

$sr_no = $page == 1 ? 0 : $pageSize * ($page - 1);
foreach ($arr_listing as $sn => $row) {
    $sr_no++;
    $tr = $tbl->appendElement('tr');

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'message_sent_by_username':
                $sentByUserName = "<a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Users') . "\", " . $row['message_sent_by'] . ")'>" . $row['message_sent_by_username'] . "</a>";
                $sentByShopName = '';
                $imgUrl = UrlHelper::generateUrl('Image', 'user', array($row['message_sent_by'], 'MINI', true), CONF_WEBROOT_FRONT_URL);
                if ($row['message_from_shop_name'] != '') {
                    $sentByShopName = "<span>" . Labels::getLabel('LBL_Shop', $adminLangId) . ": <a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Shops') . "\", " . $row['message_from_shop_id'] . ")'>" . $row['message_from_shop_name'] . "</a></span>";
                    $imgUrl = UrlHelper::generateUrl('Image', 'user', array($row['message_from_shop_id'], 'MINI', true), CONF_WEBROOT_FRONT_URL);
                }
                $sentUserDetail = '
                <div class="user-profile"> 
                            <a target="_blank" href="' . $imgUrl . '">
                                <figure class="user-profile-thumbnail" data-ratio="1:1">
                                    <img width="40" height="40" title="Buyer1" alt="Buyer1" src="' . $imgUrl . '">
                                </figure>
                            </a>
                            <div class="user-profile-data">
                            ' . $sentByUserName . $sentByShopName . '
                            </div>
                            
                </div>';
                $td->appendElement('plaintext', array(), $sentUserDetail, true);
                break;
            case 'message_sent_to_name':
                $sentToUserName = "<a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Users') . "\", " . $row['message_sent_to'] . ")'>" . $row['message_sent_to_name'] . "</a>";
                $sentByShopName = '';
                $imgUrl = UrlHelper::generateUrl('Image', 'user', array($row['message_sent_to'], 'MINI', true), CONF_WEBROOT_FRONT_URL);
                if ($row['message_to_shop_name'] != '') {
                    $sentByShopName = "<span>Shop: <a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Shops') . "\", " . $row['message_to_shop_id'] . ")'>" . $row['message_to_shop_name'] . "</a></span>";
                    $imgUrl = UrlHelper::generateUrl('Image', 'shopLogo', array($row['message_to_shop_id'], $adminLangId, 'MINI'), CONF_WEBROOT_FRONT_URL);
                }
                $sentUserDetail = '
                <div class="user-profile"> 
                            <a target="_blank" href="' . $imgUrl . '">
                                <figure class="user-profile-thumbnail" data-ratio="1:1">
                                    <img width="40" height="40" title="Buyer1" alt="Buyer1" src="' . $imgUrl . '">
                                </figure>
                            </a>
                            <div class="user-profile-data">
                            ' . $sentToUserName . $sentByShopName . '
                            </div>
                            
                </div>';
                $td->appendElement('plaintext', array(), $sentUserDetail, true);
                break;
            // case 'message_sent_by_username1':
            //     $div_about_me = $td->appendElement('div', array('class' => 'avtar avtar-sm'));
            //     $sentByUserName = "<a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Users') . "\", " . $row['message_sent_by'] . ")'>" . $row['message_sent_by_username'] . "</a>";

            //     if ($row['message_from_shop_name'] != '') {
            //         $sentByShopName = "<a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Shops') . "\", " . $row['message_from_shop_id'] . ")'>" . $row['message_from_shop_name'] . "</a>";

            //         $div_about_me->appendElement('img', array('src' => UrlHelper::generateUrl('Image', 'shopLogo', array($row['message_from_shop_id'], $adminLangId, 'MINI'), CONF_WEBROOT_FRONT_URL)));

            //         $span = $td->appendElement('span', array('class' => 'avtar__name'), $sentByShopName . ' (' . $sentByUserName . ')', true);
            //     } else {
            //         /* $name =  $row['message_sent_by_username']; */
            //         $div_about_me->appendElement('img', array('src' => UrlHelper::generateUrl('Image', 'user', array($row['message_sent_by'], 'MINI', true), CONF_WEBROOT_FRONT_URL)));

            //         $span = $td->appendElement('span', array('class' => 'avtar__name'), $sentByUserName, true);
            //     }


            //     break;
            case 'message_sent_to_name1':
                $figure = $td->appendElement('figure', array('class' => 'avtar bgm-purple'));
                $sentToUserName = "<a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Users') . "\", " . $row['message_sent_to'] . ")'>" . $row['message_sent_to_name'] . "</a>";

                if ($row['message_to_shop_name'] != '') {
                    $sentByShopName = "<a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Shops') . "\", " . $row['message_to_shop_id'] . ")'>" . $row['message_to_shop_name'] . "</a>";

                    $figure->appendElement('img', array('src' => UrlHelper::generateUrl('Image', 'shopLogo', array($row['message_to_shop_id'], $adminLangId, 'MINI'), CONF_WEBROOT_FRONT_URL)));

                    $span = $td->appendElement('span', array('class' => 'avtar__name'), $sentByShopName . ' (' . $sentToUserName . ')', true);
                } else {
                    $figure->appendElement('img', array('src' => UrlHelper::generateUrl('Image', 'user', array($row['message_sent_to'], 'MINI', true), CONF_WEBROOT_FRONT_URL)));
                    /* $name =  $row['message_sent_to_name']; */

                    $span = $td->appendElement('span', array('class' => 'avtar__name'), $sentToUserName, true);
                }

                break;
            case 'message_text':
                $div = $td->appendElement('div', array('class' => 'listing__desc'));
                // $anchor = $div->appendElement('a', array('href'=>'#'));
                $div->appendElement('plaintext', array(), $row['message_text']);
                //$td->appendElement('plaintext', array(), FatDate::format($row['message_text'] , true));
                break;
            case 'message_date':
                $date = FatDate::format($row['message_date'], true);
                $dateHtml = "";
                if (strpos($date, ' ') !== false) {
                    list($formattedDate, $formattedTime) = explode(' ', $date);
                    $dateHtml = "<date class='date'>" . $formattedDate . " <time>" . $formattedTime . "</time></date>";
                } else {
                    $dateHtml = "<date class='date'>" . $date . "</date>";
                }
                $td->appendElement('plaintext', array(), $dateHtml, true);
                /* $td->appendElement('span', array('class' => 'date'), ); */
                break;
            case 'action':
                $actionArr = [
                    [
                        "title" => Labels::getLabel('LBL_View', $adminLangId),
                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#eye'></use></svg>",
                        "href" => UrlHelper::generateUrl('Messages', 'view', array($row['thread_id']))
                    ]
                ];
                $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['thread_id']], false);
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}

echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</div>
<?php
$postedData['page'] = $page;

echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmSearchPaging'
));

$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);

$this->includeTemplate('_partial/pagination.php', $pagingArr, false);