<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$alphabetColors = [];
$colors = [
    '#F45442', '#56a0f8', '#e83e8c', '#ffc107',
	'#FF8C33','#8C33FF','#FF333F'
];
$letters = range('A', 'Z');
foreach ($letters as $index => $letter) {
    $alphabetColors[$letter] = $colors[$index % count($colors)]; // Repeat colors if fewer than 26
}
$arr_flds = array(
	'check' => '',
	'profile' => '',
	'notification_label_key' => '',
	'notification_added_on' => '',
);

$sr_no = $page == 1 ? 0 : $pageSize * ($page - 1);
foreach ($arr_listing as $sn => $row) {
	$sr_no++;
	$uname = ($row['user_name']) ? $row['user_name'] : '- Guest User -';
	$url = UrlHelper::generateUrl($labelArr[$row['notification_label_key']][1]);
	$file_row = AttachedFile::getAttachment(AttachedFile::FILETYPE_USER_PROFILE_IMAGE, $row['notification_user_id']);
		?>
		<div class="notifications__item <?php echo !empty($row['notification_marked_read']) ? 'read':'unread' ?>">
			<label class="checkbox">
				<input type="checkbox" class="check-record" rel="<?php echo $row['notification_id'] ?>">
			</label>
			<div class="avatar avatar--small" style="color: <?php echo $alphabetColors[strtoupper(substr($uname,0,1))] ?>" data-title="<?php echo strtoupper(substr($uname,0,1)) ?>">
				<?php if($file_row['afile_id'] > 0){ ?>
				<img src="<?php echo UrlHelper::generateUrl('Image','user',array($row['notification_user_id'],'MINI',true),CONF_WEBROOT_FRONT_URL).'?t='.strtotime($file_row['afile_updated_at']); ?>"/>
				<?php } ?>
			</div>
			<div class="notifications__summary">
				<a href="javascript:void(0)" onclick="redirectfunc('<?php echo $url ?>' ,'<?php echo $row['notification_record_id'] ?>' , '<?php echo $row['notification_id'] ?>')" >
					<h6><?php echo  $uname; ?></h6><?php echo $labelArr[$row['notification_label_key']][0]; ?>
				</a>
			</div>
			<date class="date small">
				<?php 
				echo FatDate::format($row['notification_added_on'],true,true,FatApp::getConfig('CONF_TIMEZONE', FatUtility::VAR_STRING, date_default_timezone_get()));
				?>
			</date>
		</div>
		<?php
}

if (count($arr_listing) == 0) {
	$this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
	'name' => 'frmSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
?>