<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php
$arr_flds = array(
	'dragdrop' => '',
	'optionvalue_identifier' => Labels::getLabel('LBL_OPTION_VALUE_NAME', $adminLangId),
	'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
if (!$canEdit) {
	unset($arr_flds['dragdrop']);
}
$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified', 'id' => 'optionvalues'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $val) {
	$e = $th->appendElement('th', array(), $val);
}

$sr_no = 0;
foreach ($arr_listing as $sn => $row) {
	$sr_no++;
	$tr = $tbl->appendElement('tr');
	$tr->setAttribute("id", $row['optionvalue_id']);
	foreach ($arr_flds as $key => $val) {
		$td = $tr->appendElement('td');
		switch ($key) {
			case 'dragdrop':
				$td->appendElement('svg', array('width'=>'16','height'=>'16'),"<use xlink:href='".CONF_WEBROOT_FRONT_URL."images/admin/retina/sprite.svg#drag-move-2'></use>",true);
				$td->setAttribute("class", 'dragHandle');
				break;
			case 'optionvalue_identifier':
				if ($row['optionvalue_name'] != '') {
					$td->appendElement('plaintext', array(), $row['optionvalue_name'], true);
					$td->appendElement('br', array());
					$td->appendElement('plaintext', array(), '(' . $row[$key] . ')', true);
				} else {
					$td->appendElement('plaintext', array(), $row[$key], true);
				}
				break;
			case 'action':
				if ($canEdit) {
					$actionArr = [
						[
							"title" => Labels::getLabel('LBL_Edit', $adminLangId),
							"icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
							"onclick" => "optionValueForm(" . $row['optionvalue_option_id'] . "," . $row['optionvalue_id'] . ")"
						],
						[
							"title" => Labels::getLabel('LBL_Delete', $adminLangId),
							"icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
							"onclick" => "deleteOptionValue(" . $row['optionvalue_option_id'] . "," . $row['optionvalue_id'] . ")"
						]
					];
					$this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$row['optionvalue_id']], false);
				}
				break;
			default:
				$td->appendElement('plaintext', array(), $row[$key], true);
				break;
		}
	}
}

echo $tbl->getHtml();
if (count($arr_listing) == 0) {
	$this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
<script>
	$(document).ready(function () {

		$('#optionvalues').tableDnD({
			onDrop: function (table, row) {
				fcom.displayProcessing();
				var order = $.tableDnD.serialize('id');
				fcom.ajax(fcom.makeUrl('OptionValues', 'setOptionsOrder'), order, function (res) {
					var ans = $.parseJSON(res);
					if (ans.status == 1) {
						fcom.displaySuccessMessage(ans.msg);
					} else {
						fcom.displayErrorMessage(ans.msg);
					}
				});
			},
			dragHandle: ".dragHandle",
		});
	});
</script>