
<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
    <?php
    $arr_flds = array(
        'select_all' => Labels::getLabel('LBL_Select_all', $adminLangId),
        'listserial' => Labels::getLabel('LBL_#', $adminLangId),
        'option_identifier' => Labels::getLabel('LBL_Option_Name', $adminLangId),
        'user_name' => Labels::getLabel('LBL_Added_By', $adminLangId),
        'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
    );
    if (!$canEdit) {
        unset($arr_flds['select_all'], $arr_flds['action']);
    }
    $tbl = new HtmlElement(
        'table',
        array('width' => '100%', 'class' => 'table table-hovered table-justified', 'id' => 'options')
    );

    $th = $tbl->appendElement('thead')->appendElement('tr');
    foreach ($arr_flds as $key => $val) {
        if ('select_all' == $key) {
            $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $val . '" type="checkbox" onclick="selectAll( $(this) )" class="selectAll-js"></label>', true);
        } else {
            $e = $th->appendElement('th', array(), $val);
        }
    }

    $sr_no = ($page > 1) ? $recordCount - (($page - 1) * $pageSize) : $recordCount;
    foreach ($arr_listing as $sn => $row) {
        $tr = $tbl->appendElement('tr');
        $tr->setAttribute("id", $row['option_id']);

        foreach ($arr_flds as $key => $val) {
            $td = $tr->appendElement('td');
            switch ($key) {
                case 'select_all':
                    $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="option_ids[]" value=' . $row['option_id'] . '></label>', true);
                    break;
                case 'listserial':
                    $td->appendElement('plaintext', array(), $sr_no);
                    break;
                case 'option_identifier':
                    if ($row['option_name'] != '') {
                        $td->appendElement('plaintext', array(), $row['option_name'], true);
                        $td->appendElement('br', array());
                        $td->appendElement('plaintext', array(), '(' . $row[$key] . ')', true);
                    } else {
                        $td->appendElement('plaintext', array(), $row[$key], true);
                    }
                    break;
                case 'user_name':
                    if ($row['user_name'] != '') {
                        /* $td->appendElement('plaintext', array(), $row['user_name'], true); */
                        $td->appendElement('a', array('href' => 'javascript:void(0)', 'onClick' => 'redirectfunc("' . UrlHelper::generateUrl('Users') . '", ' . $row['option_seller_id'] . ')'), $row['user_name'], true);
                    } else {
                        $td->appendElement('plaintext', array(), 'Admin', true);
                    }
                    break;
                case 'action':
                    if ($canEdit) {

                        $actionArr = [
                            [
                                "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                                "onclick" => "addOptionFormNew(" . $row['option_id'] . ")"
                            ],
                            [
                                "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                                "onclick" => "deleteOptionRecord(" . $row['option_id'] . ")"
                            ]
                        ];
                        $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$row['option_id']], false);

                    }
                    break;
                default:
                    $td->appendElement('plaintext', array(), $row[$key], true);
                    break;
            }
        }
        $sr_no--;
    }
    
    $frm = new Form('frmOptionsListing', array('id' => 'frmOptionsListing'));
    $frm->setFormTagAttribute('class', 'form web_form last_td_nowrap actionButtons-js');
    $frm->setFormTagAttribute('onsubmit', 'formAction(this, reloadList ); return(false);');
    $frm->setFormTagAttribute('action', UrlHelper::generateUrl('Options', 'deleteSelected'));
    $frm->addHiddenField('', 'status');

    echo $frm->getFormTag();
    echo $frm->getFieldHtml('status');
    echo $tbl->getHtml();
    if (count($arr_listing) == 0) {
        $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
    }
     ?>
    </form>
</div>
    <?php $postedData['page'] = $page;
    echo FatUtility::createHiddenFormFromData($postedData, array(
        'name' => 'frmOptionsSearchPaging'
    ));
    $pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
    $this->includeTemplate('_partial/pagination.php', $pagingArr, false);
