<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
$arr_flds = array(
    // 'select_all' => Labels::getLabel('LBL_Select_all', $adminLangId),
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'ocrule_duration_rang' => Labels::getLabel('LBL_Duration_Range(In_Hours)', $adminLangId),
    // 'ocrule_duration_max' => Labels::getLabel('LBL_Duration_Max(In_Hours)', $adminLangId),
    'ocrule_refund_amount' => Labels::getLabel('LBL_Refund_Amount(In_Percentage)', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
if (!$canEdit) {
    unset($arr_flds['select_all'], $arr_flds['action']);
}
$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $key => $val) {
    if ('select_all' == $key) {
        $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $val . '" type="checkbox" onclick="selectAll( $(this) )" class="selectAll-js"></label>', true);
    } else {
        $e = $th->appendElement('th', array(), $val);
    }
}
$sr_no = 1;
foreach ($arr_listing as $sn => $row) {
    $tr = $tbl->appendElement('tr');
    $tr->setAttribute("id", $row['ocrule_id']);
    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'select_all':
                if ($row['ocrule_is_default'] != OrderCancelRule::MIN_VALUE && $row['ocrule_is_default'] != OrderCancelRule::MAX_VALUE) {
                    $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="ocrule_ids[]" value=' . $row['ocrule_id'] . '></label>', true);
                }
                break;
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'ocrule_duration_rang':
                if ($row['ocrule_is_default'] == OrderCancelRule::MAX_VALUE) {
                    $row['ocrule_duration_max'] = "Infinity";
                }
                $td->appendElement('plaintext', array(), $row['ocrule_duration_min'] . ' - ' . $row['ocrule_duration_max']);
                break;
                case 'action':
                    if ($canEdit) {
                        $actionArr = [
                            [
                                "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                                "onclick" => "addEditRuleForm(" . $row['ocrule_id'] . ")"
                            ]
                        ];
                        if ($row['ocrule_is_default'] == applicationConstants::NO) {
                            $actionArr[] = [
                                "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                                "onclick" => "deleteRecord(" . $row['ocrule_id'] . ")"
                            ];
                        }
                        $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$row['ocrule_id']], false);
                    }
                    break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
    $sr_no++;
}


$frm = new Form('frmCancelReasonListing', array('id' => 'frmCancelRuleListing'));
$frm->setFormTagAttribute('class', 'form web_form last_td_nowrap actionButtons-js');
$frm->setFormTagAttribute('onsubmit', 'formAction(this, reloadList ); return(false);');
$frm->setFormTagAttribute('action', UrlHelper::generateUrl('OrderCancelRules', 'deleteSelected'));
$frm->addHiddenField('', 'status');
echo $frm->getFormTag();
echo $frm->getFieldHtml('status');
echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</form>
</div>