<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>

<div class='page'>
	<div class='content content-space'>
		<div class="row">
			<div class="col-lg-12 col-md-12 space">
				<div class="page-title">
					<div class="row">
						<div class="col--first col-lg-6">
							<span class="page__icon">
								<i class="ion-android-star"></i></span>
							<h5><?php echo Labels::getLabel('LBL_Manage_Order_Return_Requests', $adminLangId); ?> </h5>
							<?php
							$breadcrumbData = [];
							if ($isRentalOrder) {
								$breadcrumbData['hrefRental'] = '/rental';
							}
							$this->includeTemplate('_partial/header/header-breadcrumb.php', $breadcrumbData); ?>
						</div>
					</div>
				</div>
				<section class="card searchform_filter advance-search">
					<div class="card-head">
						<h4> <?php echo Labels::getLabel('LBL_Search...', $adminLangId); ?></h4>
					</div>
					<div class="card-body extra togglewrap">
						<?php
						$frmSearch->setFormTagAttribute('onsubmit', 'searchOrderReturnRequests(this); return(false);');
						$frmSearch->setFormTagAttribute('class', 'form web_form');
						$frmSearch->developerTags['colClassPrefix'] = 'col-md-';
						$frmSearch->developerTags['fld_default_col'] = 12;

						$buyerFld = $frmSearch->getField('ref_no');
						$buyerFld->developerTags['col'] = 4;
						$buyerFld->setFieldTagAttribute('placeholder', 'Reference Number');

						$buyerFld = $frmSearch->getField('buyer');
						$buyerFld->developerTags['col'] = 4;
						$buyerFld->setFieldTagAttribute('placeholder', 'Search in Name, User Name, Email, Phone Number');

						$sellerFld = $frmSearch->getField('seller');
						$sellerFld->developerTags['col'] = 4;
						$sellerFld->setFieldTagAttribute('placeholder', 'Search in Name, User Name, Email, Phone Number');

						$productFld = $frmSearch->getField('product');
						$productFld->developerTags['col'] = 4;
						$productFld->setFieldTagAttribute('placeholder', 'Search in Name, Brand, Shop');

						$statusFld = $frmSearch->getField('orrequest_status');
						$statusFld->developerTags['col'] = 4;

						$typeFld = $frmSearch->getField('orrequest_type');
						if (null != $typeFld) {
							$typeFld->developerTags['col'] = 4;
						}

						$dateFromFld = $frmSearch->getField('date_from');
						$dateFromFld->setFieldTagAttribute('class', 'calender field--calender');
						$dateFromFld->developerTags['col'] = 2;

						$dateToFld = $frmSearch->getField('date_to');
						$dateToFld->setFieldTagAttribute('class', 'calender field--calender');
						$dateToFld->developerTags['col'] = 2;

						$submitBtnFld = $frmSearch->getField('btn_submit');
						$submitBtnFld->developerTags['col'] = 4;
						$submitBtnFld->developerTags['noCaptionTag'] = true;
						$btn_clear = $frmSearch->getField('btn_clear');
						$btn_clear->addFieldTagAttribute('onclick', 'clearOrderReturnRequestSearch()');
						echo $frmSearch->getFormHtml();
						?>
					</div>
				</section>
				<section class="card section">
					<div class="card-head">
						<h4><?php echo Labels::getLabel('LBL_Order_Return_Requests_List', $adminLangId); ?> </h4>
					</div>
	 				<div class="card-table">
	                    <div id="requestsListing">
                            <?php echo Labels::getLabel('LBL_Processing...', $adminLangId); ?>
                        </div>
        			</div>
				</section>
			</div>
		</div>
	</div>
</div>