<div class="page">
    <div class="content content-space">
        <div class="row">
            <div class="col-lg-12 col-md-12 space">
                <div class="page-title">
                    <div class="row">
                        <div class="col--first col-lg-6">
                            <h5><?php echo Labels::getLabel('LBL_Order_Details', $adminLangId); ?></h5>
                            <?php
                            $breadcrumbData = [];
                            if ($isRentalOrder) {
                                $breadcrumbData['hrefRental'] = '/rental';
                            }
                            $this->includeTemplate('_partial/header/header-breadcrumb.php', $breadcrumbData);
                            ?>
                        </div>
                    </div>
                </div>
                <section class="card section">
                    <div class="card-head">
                        <?php
                        $actionBack = ($requestRow['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) ? UrlHelper::generateUrl('OrderReturnRequests', 'rental') : UrlHelper::generateUrl('OrderReturnRequests');
                        ?>
                        <a class="btn-back" href="<?php echo $actionBack ?>">
                            <svg class="svg" width="24" height="24">
                                <use
                                    xlink:href="<?php echo CONF_WEBROOT_FRONTEND; ?>images/admin/retina/sprite-actions.svg#back">
                                </use>
                            </svg>
                        </a>
                        <h4><?php echo Labels::getLabel('LBL_View_Return_Order_Request', $adminLangId); ?></h4>
                        <?php


                        $data = [
                            'adminLangId' => $adminLangId,
                            'statusButtons' => false,
                            'deleteButton' => false,
                            // 'otherButtons' => [
                            //     [
                            //         'attr' => [
                            //             'href' => $actionBack,
                            //             'title' => Labels::getLabel('LBL_BACK', $adminLangId)
                            //         ],
                            //         'label' => '<i class="fas fa-arrow-left"></i>'
                            //     ]
                            // ]
                        ];

                        $this->includeTemplate('_partial/action-buttons.php', $data, false);
                        ?>
                    </div>
                    <div class="card-body">
                        <div class="listview listview-3">
                            <dl class="list">
                                <dt><?php echo Labels::getLabel('LBL_REFERENCE_NUMBER', $adminLangId); ?></dt>
                                <dd><?php echo $requestRow["orrequest_reference"]; ?></dd>
                            </dl>
                            <dl class="list">
                                <dt><?php echo Labels::getLabel('LBL_Product', $adminLangId); ?></dt>
                                <dd><?php
                                    $txt = '';
                                    if ($requestRow['op_selprod_title'] != '') {
                                        $txt .= $requestRow['op_selprod_title'] . '<br/>' . '<small>' . $requestRow['op_product_name'] . '</small>';
                                    } else {
                                        $txt .= $requestRow['op_product_name'];
                                    }
                                    if ($requestRow['op_selprod_options'] != '') {
                                        $txt .= '<br/>' . $requestRow['op_selprod_options'];
                                    }
                                    if ($requestRow['op_brand_name'] != '') {
                                        $txt .= '<br/><strong>' . Labels::getLabel('LBL_Brand', $adminLangId) . ':  </strong> ' . $requestRow['op_brand_name'];
                                    }

                                    if ($requestRow['op_shop_name'] != '') {
                                        $txt .= '<br/><strong>' . Labels::getLabel('LBL_Shop', $adminLangId) . ':  </strong> ' . $requestRow['op_shop_name'];
                                    }
                                    echo $txt;
                                    ?></dd>
                            </dl>
                            <dl class="list">
                                <dt><?php echo Labels::getLabel('LBL_Qty', $adminLangId); ?></dt>
                                <dd><?php echo $requestRow["orrequest_qty"]; ?></dd>
                            </dl>
                            <dl class="list">
                                <dt><?php echo Labels::getLabel('LBL_Reason', $adminLangId); ?></dt>
                                <dd><?php echo $requestRow["orreason_title"]; ?></dd>
                            </dl>
                            <dl class="list">
                                <dt><?php echo Labels::getLabel('LBL_Date', $adminLangId); ?></dt>
                                <dd><?php echo $requestRow["orrequest_date"]; ?></dd>
                            </dl>
                            <dl class="list">
                                <dt><?php echo Labels::getLabel('LBL_Status', $adminLangId); ?></dt>
                                <dd><?php echo $requestStatusArr[$requestRow['orrequest_status']]; ?></dd>
                            </dl>
                            <dl class="list">
                                <dt><?php echo Labels::getLabel('LBL_Order_Id/invoice_Number', $adminLangId); ?></dt>
                                <dd><?php echo $requestRow["op_invoice_number"]; ?></dd>
                            </dl>
                            <?php if ($requestRow['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) { ?>
                                <dl class="list">
                                    <dt><?php echo Labels::getLabel('LBL_Security_Amount', $adminLangId); ?></dt>
                                    <dd><?php echo CommonHelper::displayMoneyFormat(($requestRow['opd_rental_security'] * $requestRow['orrequest_qty']), true, false); ?></dd>
                                </dl>
                            <?php } ?>
							<?php if($refundableAddonAmt > 0) { ?>
								<dl class="list">
									<dt><?php echo Labels::getLabel('LBL_Addons', $adminLangId); ?><span class="text-muted">&nbsp;[<?php echo Labels::getLabel('LBL_Refundable_addons', $adminLangId); ?>, <?php echo Labels::getLabel('LBL_Amount_including_tax', $adminLangId); ?>]</span></dt>
                                    <dd><?php echo CommonHelper::displayMoneyFormat($refundableAddonAmt, true, false); ?></dd>
								</dl>
							<?php } ?>
                            <dl class="list">
                                <dt><?php echo Labels::getLabel('LBL_Amount', $adminLangId); ?></dt>
                                <dd><?php $returnDataArr = CommonHelper::getOrderProductRefundAmtArr($requestRow);
                                    echo CommonHelper::displayMoneyFormat($returnDataArr['op_refund_amount'] + $refundableAddonAmt, true, true); ?></dd>
                            </dl>
                            <?php if (isset($attachedFiles) && !empty($attachedFiles)) { ?>
                                <dl class="list">
                                    <dt><?php echo Labels::getLabel('LBL_Download_Attached_Files', $adminLangId); ?></dt>
                                    <dd>
                                    <?php foreach ($attachedFiles as $attachedFile) { ?>
                                        <a download
                                            href="<?php echo UrlHelper::generateUrl('OrderReturnRequests', 'downloadAttachedFileForReturn', array($requestRow["orrequest_id"], 0, $attachedFile['afile_id'])); ?>"
                                            class="button small green" title="<?php echo $attachedFile['afile_name']; ?>">
                                            <?php echo $attachedFile['afile_name']; ?></a> <br />
                                        <?php } ?>
                                    </dd>
                                </dl>
                            <?php } ?>
                        </div>
                    </div>
                </section>

                <div class="row">
                    <div class="col-lg-6">
                        <section class="card section">
                            <div class="card-head">
                                <h4><?php echo Labels::getLabel('LBL_Seller_Details', $adminLangId); ?>
                                </h4>
                            </div>
                            <div class="card-body">
                                <div class="address-group">
                                    <p><strong><?php echo Labels::getLabel('LBL_Shop_Name', $adminLangId); ?>:
                                        </strong><?php echo "<a class='link-brand link-underline' href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Shops') . "\", " . $requestRow['op_shop_id'] . ")'>" . $requestRow['op_shop_name'] . "</a>"; ?><br /><strong><?php echo Labels::getLabel('LBL_Name', $adminLangId); ?>:
                                        </strong>
                                        <?php echo "<a class='link-brand link-underline' href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Users') . "\", " . $requestRow['seller_user_id'] . ")'>" . $requestRow['seller_name'] . "</a>"; ?><br /><strong><?php echo Labels::getLabel('LBL_Email_ID', $adminLangId); ?>:</strong>
                                        <?php echo $requestRow["seller_email"] ?><br /><strong><?php echo Labels::getLabel('LBL_Phone', $adminLangId); ?>:</strong>
                                        <?php echo $requestRow["user_dial_code"] . ' ' . $requestRow["seller_phone"] ?>
                                    </p>
                                </div>

                            </div>
                        </section>
                    </div>
                    <div class="col-lg-6">
                        <section class="card section">
                            <div class="card-head">
                                <h4><?php echo Labels::getLabel('LBL_Customer_Details', $adminLangId); ?>
                                </h4>
                            </div>
                            <div class="card-body">
                                <div class="address-group">
                                    <p><strong><?php echo Labels::getLabel('LBL_Name', $adminLangId); ?>:
                                        </strong><?php echo "<a class='link-brand link-underline' href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Users') . "\", " . $requestRow['buyer_user_id'] . ")'>" . $requestRow['buyer_name'] . "</a>"; ?><br />
                                        <strong><?php echo Labels::getLabel('LBL_Username', $adminLangId); ?>:
                                        </strong><?php echo $requestRow["buyer_username"]; ?><br />
                                        <strong><?php echo Labels::getLabel('LBL_Email_ID', $adminLangId); ?>: </strong>
                                        <?php echo $requestRow["buyer_email"] ?><br /><strong><?php echo Labels::getLabel('LBL_Phone', $adminLangId); ?>:</strong>
                                        <?php echo $requestRow["user_dial_code"] . ' ' . $requestRow["buyer_phone"] ?>
                                    </p>
                                </div>

                            </div>
                        </section>
                    </div>
                </div>

                <?php echo $returnRequestMsgsSrchForm->getFormHtml(); ?>
                <section class="card section">
                    <div class="card-head">
                        <h4><?php echo Labels::getLabel('LBL_Message_Communication', $adminLangId); ?></h4>
                    </div>
                    <div class="card-body">
                        <ul class="messages-list" id="messagesList"></ul>
                    </div>
                    <div id="loadMoreBtnDiv"></div>
                </section>
                <?php if ($canEdit) { ?>
                    <section class="card section" id="frmArea">
                        <div class="card-head">
                            <h4><?php echo FatApp::getConfig("CONF_WEBSITE_NAME_" . $adminLangId); ?>
                                <?php echo Labels::getLabel('LBL_Says', $adminLangId); ?>
                            </h4>
                        </div>
                        <div class="card-body extra">
                            <?php
                            $frmMsg->setFormTagAttribute('class', 'form web_form');
                            $frmMsg->setFormTagAttribute('onSubmit', 'setUpReturnOrderRequestMessage(this); return false;');
                            $frmMsg->developerTags['colClassPrefix'] = 'col-md-';
                            $frmMsg->developerTags['fld_default_col'] = 8;
                            echo $frmMsg->getFormHtml(); ?>
                        </div>
                    </section>
                    <?php if ($requestRow['orrequest_status'] == OrderReturnRequest::RETURN_REQUEST_STATUS_PENDING || $requestRow['orrequest_status'] == OrderReturnRequest::RETURN_REQUEST_STATUS_ESCALATED) { ?>
                        <section class="card section" id="frmArea">
                            <div class="card-head">
                                <h4><?php echo Labels::getLabel('LBL_Update_Status', $adminLangId); ?></h4>
                            </div>
                            <div class="card-body extra">
                                <?php
                                $frmUpdateStatus->setFormTagAttribute('class', 'form web_form');
                                $frmUpdateStatus->setFormTagAttribute('onSubmit', 'setupStatus(this); return false;');
                                $frmUpdateStatus->developerTags['colClassPrefix'] = 'col-md-';
                                $frmUpdateStatus->developerTags['fld_default_col'] = 8;
                                $frmUpdateStatus->getField('orrequest_status')->setFieldTagAttribute('id', 'orrequest_status');
                                $frmUpdateStatus->getField('orrequest_admin_comment')->setWrapperAttribute('class', 'wrapper-orrequest_admin_comment hide');
                                echo $frmUpdateStatus->getFormHtml(); ?>
                            </div>
                        </section>
                    <?php }
                } ?>

            </div>
        </div>
    </div>
</div>