<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
$arr_flds = array(
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'order_id' => Labels::getLabel('LBL_Order_ID', $adminLangId),
    'buyer_user_name' => Labels::getLabel('LBL_Customer_Name', $adminLangId),
    'order_date_added' => Labels::getLabel('LBL_Order_Date', $adminLangId),
    'order_net_amount' => Labels::getLabel('LBL_Total', $adminLangId),
    'order_payment_status' => Labels::getLabel('LBL_Payment_Status', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
if ($deletedOrders) {
    unset($arr_flds['order_payment_status']);
}
$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $val) {
    $e = $th->appendElement('th', array(), $val);
}

$sr_no = ($page > 1) ? $recordCount - (($page - 1) * $pageSize) : $recordCount;
foreach ($ordersList as $sn => $row) {
    $tr = $tbl->appendElement('tr');
    $cartData = !empty($row['order_cart_data']) ? json_decode(trim($row['order_cart_data']), true) : [];
    $checkoutType = !empty($cartData) ? $cartData['shopping_cart']['checkout_type'] : Shipping::FULFILMENT_SHIP;
    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'order_id':
                $td->appendElement('a', array('target' => '_blank', 'href' => UrlHelper::generateUrl('Orders', 'view', array($row[$key]))), $row[$key], true);
                break;
            case 'buyer_user_name':
                if ($canViewUsers) {
                    $td->appendElement('a', array('href' => 'javascript:void(0)', 'onClick' => 'redirectfunc("' . UrlHelper::generateUrl('Users') . '", ' . $row['user_id'] . ')'), $row[$key], true);
                } else {
                    $td->appendElement('plaintext', array(), $row[$key], true);
                }
                $td->appendElement('plaintext', array(), '<br/>' . $row['buyer_email'], true);
                break;
            case 'order_net_amount':
                if($row['order_actual_net_amount'] > 0 && $row['order_actual_net_amount'] != $row['order_net_amount']){
                    $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($row['order_actual_net_amount'], true, true));
                }else{
                    $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($row['order_net_amount'], true, true));
                }
                break;
            case 'order_date_added':
                $date = FatDate::format(
                    $row[$key],
                    true,
                    true,
                    FatApp::getConfig('CONF_TIMEZONE', FatUtility::VAR_STRING, date_default_timezone_get())
                );
                $dateHtml = "";
                if (strpos($date, ' ') !== false) {
                    list($formattedDate, $formattedTime) = explode(' ', $date);
                    $dateHtml = "<date class='date'>" . $formattedDate . " <time>" . $formattedTime . "</time></date>";
                } else {
                    $dateHtml = "<date class='date'>" . $date . "</date>";
                }
                $td->appendElement('plaintext', array(), $dateHtml, true);
                break;
            case 'order_payment_status':
                $cls = 'badge-info';
                switch ($row[$key]) {
                    case Orders::ORDER_PAYMENT_PENDING:
                        $cls = 'badge-info';
                        break;
                    case Orders::ORDER_PAYMENT_PAID:
                        $cls = 'badge-success';
                        break;
                    case Orders::ORDER_PAYMENT_CANCELLED:
                        $cls = 'badge-danger';
                        break;
                }
                if (Orders::ORDER_PAYMENT_CANCELLED == $row["order_payment_status"]) {
                    $value = Labels::getLabel('LBL_CANCELLED', $adminLangId);
                } else {
                    $value = Orders::getOrderPaymentStatusArr($adminLangId)[$row[$key]]??'';
                }

                if (!empty($row['plugin_code']) && in_array(strtolower($row['plugin_code']), ['cashondelivery', 'payatstore'])) {
                    $value .= ' (' . $row['plugin_name'] . ' )';
                }

                $td->appendElement('span', array('class' => 'badge ' . $cls), $value);
                break;
            case 'action':

                $actionArr = [
                    [
                        "title" => Labels::getLabel('LBL_View_Order_Detail', $adminLangId),
                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#eye'></use></svg>",
                        "href" => UrlHelper::generateUrl('Orders', 'view', array($row['order_id'])),
                        'target' => '_blank'
                    ]
                ];

                if (!$row['order_deleted'] && $canViewSellerOrders) {
                    $orderUrl = UrlHelper::generateUrl('SellerOrders', 'index', array($row['order_id']));
                    if ($orderType == applicationConstants::ORDER_TYPE_RENT) {
                        $orderUrl = UrlHelper::generateUrl('SellerOrders', 'rental', array($row['order_id']));
                    }
                    $actionArr[] = [
                        "title" => Labels::getLabel('LBL_View_seller_Order', $adminLangId),
                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#list'></use></svg>",
                        "href" => $orderUrl,
                        'target' => '_blank'
                    ];
                }
                if (!$row['order_deleted'] && $canEdit) {
                    if ($row['order_payment_status'] == Orders::ORDER_PAYMENT_PAID) {
                        $actionArr[] = [
                            "title" => Labels::getLabel('LBL_Cancel_Order', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#close'></use></svg>",
                            "onclick" => "cancelOrder('" . $row['order_id'] . "')",
                        ];
                    }
                    $twoDaysAfter = date('Y-m-d H:i:s', strtotime($row['order_date_added'] . ' + 2 days'));
                    if ($row['order_payment_status'] == Orders::ORDER_PAYMENT_PENDING && $twoDaysAfter < date('Y-m-d')) {
                        $actionArr[] = [
                            "title" => Labels::getLabel('LBL_Delete_Order', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                            "onclick" => "deleteOrder('" . $row['order_id'] . "')"
                        ];
                    }
                }
                $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['order_id']], false);
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
    $sr_no--;
}

echo $tbl->getHtml();
if (count($ordersList) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</div>
<?php
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmOrderSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'pageSize' => $pageSize, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
