<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
$arr_flds = array(
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'addr_id' => Labels::getLabel('LBL_Address', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
if (!$canEdit) {
    unset($arr_flds['action']);
}
$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
$th = $tbl->appendElement('thead')->appendElement('tr');

foreach ($arr_flds as $key => $val) {
    $e = $th->appendElement('th', array(), $val);
}
$sr_no = count($arr_listing);
foreach ($arr_listing as $sn => $row) {
    $tr = $tbl->appendElement('tr');
    $tr->setAttribute("id", $row['addr_id']);

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'addr_id':
                $addr2 = (strlen($row['addr_address2']) > 0) ? ', ' . $row['addr_address2'] . '<br>' : '';
                $addrCity = (strlen($row['addr_city']) > 0) ? $row['addr_city'] . ', ' : '';
                $addrState = (strlen($row['state_name']) > 0) ? $row['state_name'] . ', ' : '';
                $addrCountry = (strlen($row['country_name']) > 0) ? $row['country_name'] . '<br>' : '';
                $addrZip = (strlen($row['addr_zip']) > 0) ? Labels::getLabel('LBL_Zip:', $adminLangId) . ' ' . $row['addr_zip'] : '';
                $addrPhone = (strlen($row['addr_phone']) > 0) ? ', ' . Labels::getLabel('LBL_Phone:', $adminLangId) . ' ' . $row['addr_dial_code'] . ' ' . $row['addr_phone'] : '';
                $address = "<address>
                                <p>" . $row['addr_address1'] . $addr2 . $addrCity . $addrState . $addrCountry . $addrZip . $addrPhone .
                    "</address>";
                $td->appendElement('plaintext', array(), $address, true);
                break;
            case 'action':
                if ($canEdit) {
                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                            "onclick" => "addAddressForm(" . $row['addr_id'] . "," . $row['addr_lang_id'] . ")"
                        ],
                        [
                            "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                            "onclick" => "deleteRecord(" . $row['addr_id'] . ")"
                        ]
                    ];
                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$row['addr_id']], false);
                }
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
    $sr_no--;
}

echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</div>
