<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
if (count($childCategories) > 0) {
    ?>

    <?php foreach ($childCategories as $sn => $row) { ?>
        <li id="<?php echo $row['prodcat_id']; ?>"
            class="sortableListsClosed child-category <?php if ($row['subcategory_count'] == 0) { ?>no-children<?php } ?>">
            <div>
                <div class="sorting-bar">
                    <div class="sorting-title"><span class="clickable"
                            onClick="displaySubCategories(this);"><?php echo $row['prodcat_name']; ?></span> <a
                            href="<?php echo commonHelper::generateUrl('Products', 'index', array($row['prodcat_id'])); ?>"
                            class="badge badge-info badge-pill ms-2 clickable"
                            title="<?php echo Labels::getLabel('LBL_Category_Products', $adminLangId); ?>"><?php echo CommonHelper::displayBadgeCount($row['category_products']); ?></a>
                    </div>
                    <div class="clickable">
                        <div class="sorting-actions clickable">
                            <?php
                            $active = "";
                            if ($row['prodcat_active']) {
                                $active = 'checked';
                            }
                            $statusAct = ($canEdit === true) ? 'toggleStatus(event,this,' . applicationConstants::YES . ')' : 'toggleStatus(event,this,' . applicationConstants::NO . ')';
                            $statusClass = ($canEdit === false) ? 'disabled' : '';
                            ?>
                            <label class="switch switch-sm switch-icon clickable">
                                <input <?php echo $active; ?> type="checkbox" id="switch<?php echo $row['prodcat_id']; ?>"
                                    value="<?php echo $row['prodcat_id']; ?>" onclick="<?php echo $statusAct; ?>"
                                    class="switch-labels clickable"  />

                            </label>
                            <?php if ($canEdit) { ?>
                                <button onClick="goToProduct(<?php echo $row['prodcat_id']; ?>)"
                                    title="<?php echo Labels::getLabel('LBL_Add_Product', $adminLangId); ?>"
                                    class="actions-link clickable"><svg class="svg bi-plus-circle clickable"
                                        xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor"
                                        viewBox="0 0 16 16">
                                        <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"></path>
                                        <path
                                            d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4">
                                        </path>
                                    </svg></button>
                                <a href="<?php echo UrlHelper::generateUrl('ProductCategories', 'form', array($row['prodcat_id'])); ?>"
                                    title="<?php echo Labels::getLabel('LBL_Edit', $adminLangId); ?>"
                                    class="actions-link clickable"><svg class="svg clickable" width="18" height="18">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/retina/sprite-actions.svg#edit">
                                        </use>
                                    </svg></a>
                                <button title="<?php echo Labels::getLabel('LBL_Delete', $adminLangId); ?>"
                                    onclick="deleteRecord(<?php echo $row['prodcat_id']; ?>)" class="actions-link clickable"><svg
                                        class="svg clickable" width="18" height="18">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/retina/sprite-actions.svg#delete">
                                        </use>
                                    </svg></button>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <?php if ($row['subcategory_count'] > 0) { ?>
                    <span class="sortableListsOpener">
                        <i class="sort-icon clickable"  onClick="displaySubCategories(this)">
                            <svg class="svg clickable" width="18" height="18">
                                <use xlink:href="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/retina/sprite-actions.svg#plus">
                                </use>
                            </svg>
                        </i>
                    </span>
                <?php } ?>
            </div>
        </li>
    <?php } ?>

<?php } ?>