$(document).ready(function(){
	setup = function (frm) {
        if (!$(frm).validate()) {
            $('html,body').stop().animate({
                scrollTop: $('.error:first').offset().top - 120,
            });
            return;
        }
		
		fcom.displayProcessing();
        var data = fcom.frmData(frm);
        fcom.ajax(fcom.makeUrl('Products', 'setupProductSingleForm'), data, function (res) {
            ans = JSON.parse(res);
			if (ans.status == true) {
				$.systemMessage.close();
				$.mbsmessage.success(ans.msg);
				var recordId = getProductId();
				if(recordId < 1) {
					window.history.replaceState({},'', fcom.makeUrl('Products', 'singleForm', [ans.productId]));
					if(ans.langId > 0) {
						setTimeout(function () {
							langForm(ans.langId, 0, ans.productId);
						}, 500);
					}
				} else {
					window.location.reload();
				}
			} else {
				$.mbsmessage.error(ans.msg);
			}
        });
    };
	
	langForm = function(langId = 0, autoFillLangData = 0, recordId = 0) {
        recordId = recordId || getProductId();
		langId = langId || $("#addProductfrm [name='lang_id']").val();
        $('.main-js').prepend(fcom.getLoader());
        fcom.updateWithAjax(fcom.makeUrl('Products', 'singleForm', [recordId]), { langId, autoFillLangData }, function(res) {
            $('.main-js').html(res.html);
        });
    };
	
	prodSpecifications = function() {
        var productId = getProductId();
        var langId = $("#addProductfrm [name='lang_id']").val();
        fcom.ajax(fcom.makeUrl('Products', 'prodSpecificationsByLangId'), { product_id: productId, langId:langId, singleCatalogForm: 1 }, function(res) {
            $('#specificationsListJs').html(res);
            if ($('#specificationsListJs').find('table tbody tr').length == 0) {
                $('#specificationsListJs').find('table').addClass('hidden');
                $('#specificationsListSeprJs').addClass('hidden');
            }
        });
    };
	
	fileSpecifications = function() {
        var productId = getProductId();
        var langId = $("#addProductfrm [name='lang_id']").val();

        fcom.ajax(fcom.makeUrl('Products', 'prodSpecificationsMediaByLangId'), { product_id: productId, langId:langId, singleCatalogForm: 1 }, function(res) {
            $('#file-specificationsListJs').html(res);
            if ($('#file-specificationsListJs').find('table tbody tr').length == 0) {
                $('#file-specificationsListJs').find('table').addClass('hidden');
                $('#file-specificationsListSeprJs').addClass('hidden');
            }
        });
    };
	
	addSpecification = function() {
        let appendEle = $('#specificationsListJs');
        let identifier = $('#sp_identifier').val();
        let label = $('#sp_label').val();
        let value = $('#sp_value').val();
        let group = $('#sp_group').val();
        let prodSpecId = parseInt($('#sp_id').val());
        if (prodSpecId == NaN) {
            prodSpecId = 0;
        }
        if (!validateSpeficationForm()) {
            return;
        }

        $('#specificationsListSeprJs').removeClass('hidden');

        let rowCount = appendEle.find('tbody tr.editRowJs').length ? appendEle.find("tbody tr").index($(".editRowJs")) : appendEle.find('tbody tr').length;

        let html = '<tr data-id="' + prodSpecId + '">';
		html += '<td>' + identifier + '</td>';
        html += '<td class="nameJs">' + label + '<input type="hidden" name="specifications[' + rowCount + '][name]" value="' + label + '"  data-fatreq="{&quot;required&quot;:false}"/> <input class="identifierJs" type="hidden" name="specifications[' + rowCount + '][identifier]" value="' + identifier + '"  data-fatreq="{&quot;required&quot;:false}"/></td>';
        html += '<td class="valueJs">' + value + '<input type="hidden" name="specifications[' + rowCount + '][value]" value="' + value + '" data-fatreq="{&quot;required&quot;:false}" /> </td>';
        html += '<td class="groupJs">' + group + '<input type="hidden" name="specifications[' + rowCount + '][group]"  value="' + group + '" data-fatreq="{&quot;required&quot;:false}" /> </td>';
        html += '<td class="align-right"><ul class="actions actions-tbl">' +
            '<li class="actions-item"><input type="hidden" name="specifications[' + rowCount + '][id]" value="' + prodSpecId + '"  data-fatreq="{&quot;required&quot;:false}"/>' +
            '<a class="actions-link" href="javascript:void(0)"  onclick="editProdSpec(this)">' +
            '<svg class="svg" width="18" height="18"><use xlink:href="/images/admin/retina/sprite-actions.svg#edit"></use></svg>' +
            '</a></li>' +
            '<li class="actions-item">' +
            '<a class="actions-link" href="javascript:void(0)" onclick="deleteProdSpec(this)">' +
            '<svg class="svg" width="18" height="18"><use xlink:href="/images/admin/retina/sprite-actions.svg#delete"></use></svg>' +
            '</a></li>' +
            '</td>';
        html += '</ul></tr>';
        if (appendEle.find('.editRowJs').length) {
            appendEle.find('.editRowJs').replaceWith(html);
        } else {
            appendEle.find('tbody').append(html);
        }

        if (appendEle.find('table').hasClass('hidden')) {
            appendEle.find('table').removeClass('hidden');
        }

        $('#sp_identifier').val('');
        $('#sp_label').val('');
        $('#sp_value').val('');
        $('#sp_group').val('');
        $('#sp_id').val(0);
        $('#btnAddSpecJs').text($('#btnAddSpecJs').data('addlbl'));

    };

    validateSpeficationForm = function() {
        let validate = true;
        $('#specificationsFormJs input').each(function() {
            if ($(this).data('change-event-bind') != 1) {
                $("input").change(function() {
                    $(this).siblings('ul').remove();
                });
                $(this).data('change-event-bind', 1);
            }
            $(this).siblings('ul').remove();
            if ($(this).data('required') == 1 && '' == $(this).val()) {
                let caption = $(this).siblings('label').text().trim();
                errorlist = $(document.createElement("ul")).addClass('errorlist').append(
                    $(document.createElement('li')).append($(document.createElement('a')).html(caption + " " + langLbl.isMandatory, ).attr({ 'href': 'javascript:void(0);' }))
                );
                $(this).after(errorlist);
                validate = false;
            }
        });
        return validate;
    };
	
	deleteProdSpec = function(el) {
		var agree = confirm(langLbl.confirmRemoveRecord);
        if (!agree) {
            return false;
        }
		
        let prodSpecId = $(el).closest('tr').data('id');
        let prodSpecLangId = $(el).data('langId');
        let productId = getProductId();

        //if (1 > prodSpecId) {
            $(el).closest('tr').remove();
            if ($('#specificationsListJs').find('table tbody tr').length == 0) {
                $('#specificationsListJs').find('table').addClass('hidden');
                $('#specificationsListSeprJs').addClass('hidden');
            }
            return;
        //}
        /*fcom.updateWithAjax(fcom.makeUrl('Seller', 'deleteProdSpec', [productId]), { prodSpecId, langId: prodSpecLangId }, function(t) {
            prodSpecifications();
        });*/
    };
	
	editProdSpec = function(el) {
        let trEle = $(el).closest('tr');
        let prodSpecId = parseInt(trEle.data('id'));
        if (prodSpecId == NaN) {
            prodSpecId = 0;
        }

        let identifier = trEle.find('.identifierJs').text();
        let label = trEle.find('.nameJs').text();
        let value = trEle.find('.valueJs').text();
        let group = trEle.find('.groupJs').text();
        trEle.siblings().removeClass('editRowJs');
        trEle.addClass('editRowJs');

        $('#sp_identifier').val(identifier);
        $('#sp_label').val(label);
        $('#sp_value').val(value);
        $('#sp_group').val(group);
        $('#sp_id').val(prodSpecId);
        $('#btnAddSpecJs').text($('#btnAddSpecJs').data('updatelbl'));
        $('html,body').stop().animate({
            scrollTop: $('#specifications').offset().top,
        });
    };
	
	clearProdSpecForm = function () {
        $('#sp_label, #sp_identifier, #sp_value, #sp_group').val('');
        $('#sp_id').val(0);
        $('#btnAddSpecJs').text($('#btnAddSpecJs').data('addlbl'));
        $('#specificationsListJs tr.editRowJs').removeClass('editRowJs');
    };
	
	addFileSpecification = function() {
        let appendEle = $('#file-specificationsListJs');
        let identifier = $('#fsp_identifier').val();
        let name = $('#fsp_name').val();
        let fileSpecId = parseInt($('#fsp_id').val());
        if (isNaN(fileSpecId)) {
            fileSpecId = 0;
        }

        let fileSpecFileId = parseInt($('#hiddenSpecFileIdJs').val());
        if (isNaN(fileSpecFileId)) {
            /*alert('Invalid file attached with ' + name);*/
			fileSpecFileId = 0;
        }

        $('#hiddenSpecFileIdJs').val(0);
		
        if (!validateFileSpeficationForm()) {
			if(fileSpecId < 1 && fileSpecFileId < 1 && appendEle.find('tbody tr.editRowJs').length < 1) {
				var errorHtml = '<ul class="errorlist erlist_specification_media"><li><a href="javascript:void(0);">'+specificationFileLbl+'</a></li></ul>';
				$('.erlist_specification_media').remove();
				$('#hiddenSpecFileFrmFileJs').after(errorHtml);
				return false;
			}
            return;
        }

		if(fileSpecId < 1 && fileSpecFileId < 1 && appendEle.find('tbody tr.editRowJs').length < 1) {
			var errorHtml = '<ul class="errorlist erlist_specification_media"><li><a href="javascript:void(0);">'+specificationFileLbl+'</a></li></ul>';
			$('.erlist_specification_media').remove();
			$('#hiddenSpecFileFrmFileJs').after(errorHtml);
            return false;
		}
		
        $('#file-specificationsListSeprJs').removeClass('hidden');

        let rowCount = appendEle.find('tbody tr.editRowJs').length ? appendEle.find("tbody tr").index($(".editRowJs")) : appendEle.find('tbody tr').length;
        let fileEl = $('#filespectempJs').html();
        
        $('#filespectempJs').text('');
		
        let html = '<tr data-id="' + fileSpecId + '" data-nfid="' + fileSpecFileId + '" data-ofid="' + fileSpecId + '">';
		html += '<td>' + identifier + '</td>';
        html += '<td class="nameJs">' + name + '<input type="hidden" name="filespecifications[' + rowCount + '][name]" value="' + name + '"  data-fatreq="{&quot;required&quot;:false}"/><input class="identifierJs" type="hidden" name="filespecifications[' + rowCount + '][identifier]" value="' + identifier + '"  data-fatreq="{&quot;required&quot;:false}"/></td><td class="fileJs">' + fileEl + '</td>';
        html += '<td class="align-right"><ul class="actions actions-tbl">' +
            '<li class="actions-item"><input type="hidden" name="filespecifications[' + rowCount + '][id]" value="' + fileSpecId + '"  data-fatreq="{&quot;required&quot;:false}"/>' +
            '<input type="hidden" name="filespecifications[' + rowCount + '][temp_file_id]" value="' + fileSpecFileId + '"  data-fatreq="{&quot;required&quot;:false}"/>' +
            '<input type="hidden" name="filespecifications[' + rowCount + '][file_id]" value="' + fileSpecFileId + '"  data-fatreq="{&quot;required&quot;:false}"/>' +
            /* '<input type="hidden" name="filespecifications[' + rowCount + '][is_file]" value="' + isFile + '"  data-fatreq="{&quot;required&quot;:false}"/>' + */
            '<a class="actions-link" href="javascript:void(0)"  onclick="editFileSpec(this)">' +
            '<svg class="svg" width="18" height="18"><use xlink:href="/images/admin/retina/sprite-actions.svg#edit"></use></svg>' +
            '</a></li>' +
            '<li class="actions-item">' +
            '<a class="actions-link" href="javascript:void(0)" onclick="deleteFileSpec(this)">' +
            '<svg class="svg" width="18" height="18"><use xlink:href="/images/admin/retina/sprite-actions.svg#delete"></use></svg>' +
            '</a></li>' +
            '</td>';
        html += '</ul></tr>';

        if (appendEle.find('.editRowJs').length) {
            appendEle.find('.editRowJs').replaceWith(html);
        } else {
            appendEle.find('tbody').append(html);
        }

        if (appendEle.find('table').hasClass('hidden')) {
            appendEle.find('table').removeClass('hidden');
        }

        $('#fsp_name').val('');
        $('#fsp_identifier').val('');
        $('#fsp_id').val(0);
        $('#btnAddFileSpecJs').text($('#btnAddFileSpecJs').data('addlbl'));
    };

    validateFileSpeficationForm = function() {
        let validate = true;
        $('#file-specificationsFormJs input').each(function() {
            if ($(this).data('change-event-bind') != 1) {
                $("input").change(function() {
                    $(this).siblings('ul').remove();
                });
                $(this).data('change-event-bind', 1);
            }
            $(this).siblings('ul').remove();
            if ($(this).data('required') == 1 && '' == $(this).val()) {
                let caption = $(this).siblings('label').text().trim();
                errorlist = $(document.createElement("ul")).addClass('errorlist').append(
                    $(document.createElement('li')).append($(document.createElement('a')).html(caption + " " + langLbl.isMandatory, ).attr({ 'href': 'javascript:void(0);' }))
                );
                $(this).after(errorlist);
                validate = false;
            }
        });
        return validate;
    };
	
    editFileSpec = function(el) {
        let trEle = $(el).closest('tr');
        let fileSpecId = parseInt(trEle.data('id'));
        if (fileSpecId == NaN) {
            fileSpecId = 0;
        }

        let name = trEle.find('.nameJs').text();
        let identifier = trEle.find('.identifierJs').val();
        let fileHtml = trEle.find('.fileJs').html();
        trEle.siblings().removeClass('editRowJs');
        trEle.addClass('editRowJs');

        $('#fsp_name').val(name);
        $('#fsp_identifier').val(identifier);
        $('#fsp_id').val(fileSpecId);
        $('#filespectempJs').html(fileHtml);
        
        $('#btnAddFileSpecJs').text($('#btnAddFileSpecJs').data('updatelbl'));
        $('html,body').stop().animate({
            scrollTop: $('#file-specifications').offset().top,
        });
    };

    clearFileSpecForm = function () {
        $('#fsp_name, #fsp_identifier').val('');
        $('#fsp_id').val(0);
        $('#filespectempJs').html('');
        $('#btnAddFileSpecJs').text($('#btnAddFileSpecJs').data('addlbl'));
        $('#file-specificationsListJs tr.editRowJs').removeClass('editRowJs');
    };

    deleteFileSpec = function(el) {
		var agree = confirm(langLbl.confirmRemoveRecord);
        if (!agree) {
            return false;
        }
        let prodSpecId = $(el).closest('tr').data('id');
        let fileSpecLangId = $(el).data('langId');
        let productId = getProductId();
        if (1 > prodSpecId) {
            $(el).closest('tr').remove();
            if ($('#file-specificationsListJs').find('table tbody tr').length == 0) {
                $('#file-specificationsListJs').find('table').addClass('hidden');
                $('#file-specificationsListSeprJs').addClass('hidden');
            }
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Products', 'deleteProdSpec', [productId]), { prodSpecId: prodSpecId, langId:fileSpecLangId }, function(t) {
            fileSpecifications();
        });
    };
	
	/** Specification Media [*/
    uploadFileSpecFile = (inputBtn) => {

        if (inputBtn.files && inputBtn.files[0]) {
            /* if (!validateFileSpeficationForm(inputBtn.files[0])) {
                return;
            } */
            var frmName = $(inputBtn).attr('data-frm')
            
            var formData = new FormData();
            formData.append("frmName", frmName);
            var file = inputBtn.files[0];
            var fileName = file["name"];
            var ext = fileName.split(".").pop().toLowerCase();
            var imageTypes = ["gif", "jpg", "jpeg", "png", "svg", "bmp", "tiff"];
            let langId = getLangId();
            $('#prodspec_is_file').val(1);
            formData.append('file', file);
			$(inputBtn).val("");
			uploadSpecificationFile(formData);
        }
    };

    uploadSpecificationFile = function (formData) {
        var frmName = formData.get("frmName");
		formData.append('product_id', getProductId());
		formData.append('temp_record_id', getTempProductId());
		formData.append('langId', getLangId());

        $.ajax({
            url: fcom.makeUrl('Products', 'setupSpecFiles'),
            type: "post",
            dataType: "json",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#loader-js').html(fcom.getLoader());
            },
            success: function(ans) {
                if (ans.status == 0) {
					$.mbsmessage.error(ans.msg)
                    return;
                }
                $('#hiddenSpecFileIdJs').val(ans.spec_temp_id);
				$('#hiddenSpecFileIdJs').attr('data-is_file', ans.prodspec_is_file);
				$('#filespectempJs').html(ans.file_htm_tag);
				$.mbsmessage.success(ans.msg)
            },
        });
    };
	
	getShippingProfileOptions = function (userId) {
        let langId = getLangId();
        fcom.ajax(fcom.makeUrl('Products', 'getShippingProfileOptions'), { userId, langId }, function (t) {
            if (t.showShippingProfile == 0) {
                $('#shipping_profile').data('showShippingProfile', t.showShippingProfile);
                $('#shipping_profile').html('').parent().parent().addClass('hide');
            } else {
                $('#shipping_profile').data('showShippingProfile', t.showShippingProfile);
                $('#shipping_profile').html('').parent().parent().removeClass('hide');
                $.each(t.shipProfileArr, function (id, name) {
                    $('#shipping_profile').append(`<option value="${id}">${name}</option>`);
                });
            }
            $('#product_fulfillment_type').html('');
            $.each(t.fullfilmentOptions, function (id, name) {
                $('#product_fulfillment_type').append(`<option value="${id}">${name}</option>`);
            });
            /*$('#product_fulfillment_type').val(prodFulfilementType).trigger('change');*/         
        }, { fOutMode: 'json' });
    };
	
	/* [ UPLOAD SIZE CHART IMAGE */
	popupSizeChartImage = function (inputBtn) {
	  if (inputBtn.files && inputBtn.files[0]) {
            /* if (!validateFileSpeficationForm(inputBtn.files[0])) {
                return;
            } */
            var frmName = $(inputBtn).attr('data-frm')
            
            var formData = new FormData();
            formData.append("frmName", frmName);
            var file = inputBtn.files[0];
            formData.append('file', file);
			uploadSizeChartImages(formData);
			$(inputBtn).val("");
        }
	};

	uploadSizeChartImages = function (formData) {
	  var product_id = getProductId();
	  /*var lang_id = document.imageFrm.lang_id.value;*/
	  var lang_id = getLangId();
	  formData.append('temp_record_id', getTempProductId());
	 
	  formData.append("product_id", product_id);
	  formData.append("lang_id", lang_id);
	  $.ajax({
		url: fcom.makeUrl("Products", "setupSizeChartImages"),
		type: "post",
		dataType: "json",
		data: formData,
		cache: false,
		contentType: false,
		processData: false,
		beforeSend: function () {
		  $("#loader-js").html(fcom.getLoader());
		},
		complete: function () {
		  $("#loader-js").html(fcom.getLoader());
		},
		success: function (ans) {
		  if (ans.status == 1) {
			  $('#size-chart-image-js').html(ans.retFileTag);
			  $('#sizechart-temp-id-js').val(ans.size_chart_temp_id);
			  $('#size-chart-card-js').show();
			  $.mbsmessage.success(ans.msg)
          } else {
			  $.mbsmessage.error(ans.msg)
          }
        }
      });
	};
	
	loadImageCropper = function(inputBtn) {
        loadCropper(inputBtn, true);
    }
	
	loadCropper = function (inputBtn, isAdvanceMedia = false) {
        advanceMedia = isAdvanceMedia || false;
        autoOpenSideBar = true;
        
        if (inputBtn.files && inputBtn.files[0]) {
            /*if (!validateFileUpload(inputBtn.files[0])) {
                return;
            }*/

			var frmName = $(inputBtn).closest('form').attr('name');
			var minWidth = document[frmName].min_width.value;
            var minHeight = document[frmName].min_height.value;	
			var file = inputBtn.files[0];
			var obj = {};
			if(isAdvanceMedia == true) {
				obj['option_value_id'] = $('#image_option_id').val();
				obj['img_lang_id'] = $('#image_lang_id').val();
				obj['isAdvanceMedia'] = 1;
			}
            fcom.ajax(fcom.makeUrl('Products', 'imgCropper'), '', function (t) {
				loadCropperSkeleton(isAdvanceMedia);
                t = $.parseJSON(t);
                $("#modalBoxJs .modal-body").html(t.body);
                $("#modalBoxJs .modal-footer").html(t.footer);
				
                var options = {
                    aspectRatio: minWidth / minHeight,
                    data: {
                        width: minWidth,
                        height: minHeight,
                    },
                    minCropBoxWidth: minWidth,
                    minCropBoxHeight: minHeight,
                    toggleDragModeOnDblclick: false,
                    imageSmoothingQuality: 'high',
                    imageSmoothingEnabled: true,
                };
                $(inputBtn).val('');
				setTimeout(function(){
                    cropImage(file, options, 'mediaUpload', inputBtn, '', obj);
                },200);
            });
        }
    };
    
    mediaUpload = function(formData) {

        var frmName = formData.get("frmName");
        var imgLangId = formData.get("img_lang_id");
        var optionValId = formData.get("option_value_id");
        var isAdvanceMedia = formData.get("isAdvanceMedia");
	
        var frm = document.forms[frmName];
        var other_data = $('form[name="' + frmName + '"]').serializeArray();
        
        $.each(other_data, function(key, input) {
            formData.append(input.name, input.value);
        });

		var product_id = getProductId();
		
        action = 'uploadProductImages';
		if(product_id < 1) {
			action = 'uploadTempImages';
		}
		
		/*var lang_id = getLangId();*/
		
		if (optionValId == 'undefined') {
			optionValId = 0;
		}
		
		if (isAdvanceMedia == 'undefined' || isAdvanceMedia == 'null') {
			isAdvanceMedia = 0;
		}
		
		if (imgLangId == 'undefined') {
			imgLangId = 0;
		}
		
		formData.append('temp_record_id', getTempProductId());
		formData.append("product_id", product_id);
		formData.append("lang_id", imgLangId);
		formData.append("option_id", optionValId);
		$.ajax({
			url: fcom.makeUrl("Products", action),
			type: "post",
			dataType: "json",
			data: formData,
			cache: false,
			contentType: false,
			processData: false,
			beforeSend: function () {
			  $("#loader-js").html(fcom.getLoader());
			},
			complete: function () {
			  $("#loader-js").html(fcom.getLoader());
			},
			success: function (ans) {
				if (ans.status == 1) {
					productDefaultImages();
					$("#modalBoxJs .btn-close").trigger('click');
					$.mbsmessage.success(ans.msg);
					if(isAdvanceMedia == 1) {
						imageForm();
						setTimeout(function () {
							if(optionValId > 0) {
								$('#image_option_id').val(optionValId);
							}
							if(imgLangId > 0) {
								$('#image_lang_id').val(imgLangId);
								$('#image_lang_id').trigger('change');
							} else if(optionValId > 0) {
								$('#image_option_id').trigger('change');
							}
						}, 500);
						
						
					}
					
				} else {
					$.mbsmessage.error(ans.msg);	
				}
			}
		});
    };
	
    deleteImage = function (image_id, isSizeChart = 0, isAdvanceMedia = 0) {
        var agree = confirm(langLbl.confirmDelete);
        if (!agree) {
            return false;
        }
		var product_id = getProductId();
		var temp_record_id = getTempProductId();
		var optionValId = 0;
		var langId = 0;
		
		if($('#image_option_id').length > 0) {
			optionValId = $('#image_option_id').val();
		}
		if($('#image_lang_id').length > 0) {
			langId = $('#image_lang_id').val();
		}
		
		var data = 'product_id='+product_id+'&temp_record_id='+temp_record_id+'&image_id='+image_id+'&isSizeChart='+isSizeChart;
        fcom.ajax(fcom.makeUrl('Products', 'deleteProductImage'), data, function (t) {
			var ans = $.parseJSON(t);
			
			if(isSizeChart != 1) {
				productDefaultImages();
				if (isAdvanceMedia == 1) {
					productImages(langId, optionValId);
				}
            }
			if (ans.status == 1) {
				$.mbsmessage.success(ans.msg);
				if(isSizeChart == 1) {
					$('#size-chart-image-js').html('');
					$('#sizechart-temp-id-js').val(0);
				}
			} else {
				$.mbsmessage.error(ans.msg);	
			}
        });
    };
	
	productDefaultImages = function(lang_id = 0, option_id = 0) {
		var product_id = getProductId();
		var temp_record_id = getTempProductId();
        option_id = option_id || 0;
        lang_id = lang_id || 0;
		var data = 'product_id='+product_id+'&temp_record_id='+temp_record_id+'&option_id='+option_id+'&lang_id='+lang_id+'&isDefaultLayout=1';
        fcom.updateWithAjax(fcom.makeUrl('Products', 'productImages'), data, function(t) {
            $('#productDefaultImagesJs li').not(":first").remove();
            $('#productDefaultImagesJs').append(t.html);
            $("#productDefaultImagesJs").sortable({
                items: "li:not(.unsortableJs)",
                stop: function () {
                    var mysortarr = new Array();
                    $(this).find('li').each(function () {
                        mysortarr.push($(this).attr("id"));
                    });

                    var sort = mysortarr.join('-');
                    var record_id = $('#hiddenMediaFrmJs').find('[name="product_id"]').val();
                    var file_type = $('#hiddenMediaFrmJs').find('[name="file_type"]').val();
                    fcom.updateWithAjax(fcom.makeUrl('products', 'setImageOrder'), {
                        product_id,
                        file_type,
                        ids: sort
                    }, function (t) {fcom.displaySuccessMessage(t.msg)});
                }
            }).disableSelection();
        });
    };
	
	productImages = function(lang_id = 0, option_id = 0) {
		var product_id = getProductId();
		var temp_record_id = getTempProductId();
        option_id = option_id || 0;
        lang_id = lang_id || 0;
		var data = 'product_id='+product_id+'&temp_record_id='+temp_record_id+'&option_id='+option_id+'&lang_id='+lang_id+'&isDefaultLayout=0';
        fcom.updateWithAjax(fcom.makeUrl('Products', 'productImages'), data, function(t) {
            $('#productImagesJs').html(t.html);
            $("#productImagesJs").sortable({
                stop: function () {
                    var mysortarr = new Array();
                    $(this).find('li').each(function () {
                        mysortarr.push($(this).attr("id"));
                    });

                    var sort = mysortarr.join('-');
                    var lang_id = $('.language-js').val();
                    var record_id = $('#image_record_id').val();
                    var option_id = $('#image_option_id').val();
                    var file_type = $('#image_file_type').val();
                    fcom.updateWithAjax(fcom.makeUrl('products', 'setImageOrder'), {
                        product_id,
                        file_type,
                        ids: sort
                    });
                }
            }).disableSelection();
        });
    };
	
	imageForm = function() {
        let productId = getProductId();
        let tempProductId = getTempProductId();
        if (1 > productId) {
            if (tempProductId == 'undefined') {
                console.warn('temp product id is manatory');
                return;
            }
        }
        var prodOptions = new Array();
		$('input[name="prod_options[]"]').each(function(index, opval) {
			prodOptions.push(opval.value);
		});
		
		var data = 'prodOptions='+JSON.stringify(prodOptions);
			
        fcom.updateWithAjax(fcom.makeUrl('Products', "imageForm", [productId, tempProductId]), data, function(t) {
			$.bootstrapModal(t.html);
			productImages();
        });
    };
	
	getCustomFields = (catId) => {
        if (catId < 1) {
			disableCustomField();
            return;
        }

        let productId = getProductId();
        fcom.updateWithAjax(fcom.makeUrl('Products', 'productCatCustomFieldsForm', []), { product_id: productId, cat_id: catId, lang_id: getLangId() }, function(res) {
            if (res.status == 1 && res.have_custom_fields == 1) {
                $('#customfields').removeClass('disabled');
                $('#customfields').show();
                $('#customfields-block').collapse('show');
                $('#CustomFieldsFormJs').html(res.html);
                return;
            }
            disableCustomField();
        });
    }
	
	disableCustomField = () => {
        $('#customfields').addClass('disabled');
		$('#customfields').hide();
        $('#customfields-block').collapse('hide');
        $('#CustomFieldsFormJs').html('');
    }
	
});	

$(document).on('change', '#image_option_id', function () {
    let optionId = $(this).val();
    let langId = $('#image_lang_id').val();
    productImages(langId, optionId);
});

$(document).on('change', '#image_lang_id', function () {
    let langId = $(this).val();
    let optionId = $('#image_option_id').val();
    productImages(langId, optionId);
});

