<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="tabs_data form">
    <div class="tabs_body">
        <div class="row">
            <div class="col-md-8">
                <div class="form-border">
                    <h5 class="form-legend">
                        <?php echo Labels::getLabel('LBL_Option_Groups', $adminLangId); ?>
                    </h5>
                    <div class="p-4">
                        <div class="field-set">
                            <div class="caption-wraper"><label class="form-label">
                                    <?php echo Labels::getLabel('LBL_Add_Associated_Product_Option_Groups', $adminLangId); ?></label>
                            </div>
                            <div class="field-wraper">
                                <div class="field_cover">
                                    <?php
                                    $optionData = array();
                                    foreach ($productOptions as $key => $data) {
                                        $optionData[$key]['id'] = $data['option_id'];
                                        $optionData[$key]['value'] = $data['option_name'] . '(' . $data['option_identifier'] . ')';
                                    }
                                    ?>
                                    <input type="text" name="option_groups"
                                        value='<?php echo htmlspecialchars(json_encode($optionData), ENT_QUOTES, 'UTF-8'); ?>'>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12 p-4" id="upc-listing"> </div>
                    </div>
                </div>
            </div>
            <?php
            $tagData = array();
            foreach ($productTags as $key => $data) {
                $tagData[$key]['id'] = $data['tag_id'];
                $tagData[$key]['value'] = $data['tag_identifier'];
            }
            ?>
            <div class="col-md-4">
                <div class="form-border">
                    <h5 class="form-legend"><?php echo Labels::getLabel('LBL_Tags', $adminLangId); ?></h5>
                    <div class="p-4">
                        <div class="field-set">
                            <div class="caption-wraper"><label
                                    class="form-label"><?php echo Labels::getLabel('LBL_Product_Tags', $adminLangId); ?></label>
                            </div>
                            <div class="field-wraper">
                                <div class="field_cover">
                                    <input class="tag_name" type="text" name="tag_name" id="get-tags"
                                        value='<?php echo htmlspecialchars(json_encode($tagData), ENT_QUOTES, 'UTF-8'); ?>'>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <div class="row tabs_footer">
        <div class="col-md-6">
            <div class="field-set">
                <div class="caption-wraper"><label class="form-label"></label></div>
                <div class="field-wraper">
                    <div class="field_cover">
                        <input onclick="productAttributeAndSpecificationsFrm(<?php echo $productId; ?>);" type="button"
                            name="btn_back" value="<?php echo Labels::getLabel('LBL_Back', $adminLangId); ?>"
                            class="btn btn-gray btn-clear">
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6 text-right">
            <?php
            $divLayout = Language::getLayoutDirection($adminLangId);
            ?>
            <div class="field-set <?php echo (trim($divLayout) == 'rtl') ? 'text-left' : '' ?>">
                <div class="caption-wraper"><label class="form-label"></label></div>
                <div class="field-wraper">
                    <div class="field_cover form web_form">
                        <input type="hidden" name="product_id" value="<?php echo $productId; ?>">
                        <input type="submit" class="btn btn-brand" onClick="productShipping(<?php echo $productId; ?>)"
                            value="<?php echo Labels::getLabel('LBL_Save_And_Next', $adminLangId); ?>">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">

    $("document").ready(function () {
        var product_id = '<?php echo $productId; ?>';
        var productOwnerId = '<?php echo $productOwnerId; ?>';
        upcListing(product_id);
        addTagData = function (e) {
            var tag_id = e.detail.tag.id;
            var tag_name = e.detail.tag.title;
            if (tag_id == '') {
                var data = 'tag_id=0&tag_identifier=' + tag_name;
                var o = $.extend(true, { fOutMode: 'json' });
                fcom.ajax(fcom.makeUrl('Tags', 'setup'), data, function (t) {
                    if (t.status != 1) {
                        tagify.removeTags(e.detail.tag);
                        $(document).trigger('close.mbsmessage');
                        fcom.displayErrorMessage(t.msg);
                        return false;
                    }
                    var dataLang = 'tag_id=' + t.tagId + '&tag_name=' + tag_name + '&lang_id=0';
                    fcom.updateWithAjax(fcom.makeUrl('Tags', 'langSetup'), dataLang, function (t2) {
                        fcom.updateWithAjax(fcom.makeUrl('Products', 'updateProductTag'), 'product_id=' + product_id + '&tag_id=' + t.tagId, function (t3) {
                            $(e.detail.tag).attr('id', t.tagId);
                        });
                    });
                }, o);
            } else {
                fcom.updateWithAjax(fcom.makeUrl('Products', 'updateProductTag'), 'product_id=' + product_id + '&tag_id=' + tag_id, function (t) { });
            }
        }
        removeTagData = function (e) {
            var tag_id = e.detail.tag.id;
            if (tag_id == '') {
                return false;
            }
            fcom.updateWithAjax(fcom.makeUrl('Products', 'removeProductTag'), 'product_id=' + product_id + '&tag_id=' + tag_id, function (t) {
            });
        }

        if (productOwnerId != '0') {
            addOption = function (e) {
                var option_id = e.detail.tag.id;
                if (option_id == '') {
                    $(e.detail.tag).remove();
                } else {

                    fcom.ajax(fcom.makeUrl('Products', 'checkOptionLinkedToInventoryExits'), 'product_id=' + product_id + '&option_id=' + option_id, function (t) {
                        ans = jQuery.parseJSON(t);
                        if (ans.status != true) {
                            fcom.displayErrorMessage(ans.msg);
                            $(e.detail.tag).remove();
                            upcListing(product_id);
                            return false;
                        }

                        fcom.ajax(fcom.makeUrl('Products', 'updateProductOption'), 'product_id=' + product_id + '&option_id=' + option_id, function (t) {
                            var rsp = $.parseJSON(t);
                            if (rsp.status == 1) {
                                fcom.displaySuccessMessage(rsp.msg);
                                upcListing(product_id);
                            } else {
                                $(e.detail.tag).remove();
                                fcom.displayErrorMessage(rsp.msg);
                            }
                        });

                    });


                }
            }

            removeOption = function (e) {
                var option_id = e.detail.tag.id;


                fcom.ajax(fcom.makeUrl('Products', 'checkOptionLinkedToInventory'), 'product_id=' + product_id + '&option_id=' + option_id, function (t) {
                    ans = jQuery.parseJSON(t);
                    if (ans.status != true) {
                        fcom.displayErrorMessage(ans.msg);
                        return false;
                    }
                    fcom.updateWithAjax(fcom.makeUrl('Products', 'removeProductOption'), 'product_id=' + product_id + '&option_id=' + option_id, function (t) {
                        upcListing(product_id);
                    });
                });
            }
        } else {
            addOption = function (e) {
                var option_id = e.detail.tag.id;
                if (option_id == '') {
                    $(e.detail.tag).remove();
                } else {
                    fcom.ajax(fcom.makeUrl('Products', 'updateProductOption'), 'product_id=' + product_id + '&option_id=' + option_id, function (t) {
                        var rsp = $.parseJSON(t);
                        if (rsp.status == 1) {
                            fcom.displaySuccessMessage(rsp.msg);
                            upcListing(product_id);
                        } else {
                            $(e.detail.tag).remove();
                            fcom.displayErrorMessage(rsp.msg);
                        }
                    });
                }
            }

            removeOption = function (e) {
                var option_id = e.detail.tag.id;
                fcom.updateWithAjax(fcom.makeUrl('Products', 'removeProductOption'), 'product_id=' + product_id + '&option_id=' + option_id, function (t) {
                    upcListing(product_id);
                });
            }
        }

        getTagsAutoComplete = function (e) {
            var keyword = e.detail.value;
            //tagify.loading(true).dropdown.hide.call(tagify)
            var list = [];
            fcom.ajax(fcom.makeUrl('Tags', 'autoComplete'), { keyword: keyword }, function (t) {
                var ans = $.parseJSON(t);
                for (i = 0; i < ans.length; i++) {
                    list.push({
                        "id": ans[i].id,
                        "value": ans[i].tag_identifier,
                    });
                }
                tagify.settings.whitelist = list;
                tagify.loading(false).dropdown.show.call(tagify, keyword);
            });
        }

        tagify = new Tagify(document.querySelector('input[name=tag_name]'), {
            whitelist: [],
            delimiters: "#",
            editTags: false,
        }).on('add', addTagData).on('remove', removeTagData).on('input', getTagsAutoComplete);


        getOptionsAutoComplete = function (e) {
            var keyword = e.detail.value;
            var listOptions = [];
            fcom.ajax(fcom.makeUrl('Options', 'autoComplete'), { keyword: keyword, product_id: product_id }, function (t) {
                var ans = $.parseJSON(t);
                for (i = 0; i < ans.length; i++) {
                    listOptions.push({
                        "id": ans[i].id,
                        "value": ans[i].name + '(' + ans[i].option_identifier + ')',
                    });
                }
                tagifyOption.settings.whitelist = listOptions;
                tagifyOption.loading(false).dropdown.show.call(tagifyOption, keyword);
            });
        };



        tagifyOption = new Tagify(document.querySelector('input[name=option_groups]'), {
            // enforceWhitelist : true,
            whitelist: [],
            delimiters: "#",
            editTags: false,
        }).on('add', addOption).on('remove', removeOption).on('input', getOptionsAutoComplete);

    });
</script>