<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
if (count($productSpecifications) > 0) { ?>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive table-scrollable js-scrollable tablewrap">
                <?php
                $arr_flds = array(
                    'prodspec_name' => Labels::getLabel('LBL_Specification_Name', $adminLangId),
                    'prodspec_value' => Labels::getLabel('LBL_Specification_Value', $adminLangId),
                    'prodspec_group' => Labels::getLabel('LBL_Specification_Group', $adminLangId),
                    'action' => Labels::getLabel('', $adminLangId)
                );

                $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-bordered table-justified'));
                $th = $tbl->appendElement('thead')->appendElement('tr');
                foreach ($arr_flds as $key => $val) {
                    if ($key == 'prodspec_name' || $key == 'prodspec_value' || $key == 'prodspec_group') {
                        $e = $th->appendElement('th', array('width' => '30%'), $val);
                    } else {
                        $e = $th->appendElement('th', array(), $val);
                    }
                }

                foreach ($productSpecifications as $specification) {
                    $tr = $tbl->appendElement('tr');
                    foreach ($arr_flds as $key => $val) {
                        $td = $tr->appendElement('td');
                        switch ($key) {
                            case 'action':
                                $prodSpecId = $specification['prodspec_id'];
                                $actionArr = [
                                    [
                                        "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                                        "onclick" => 'prodSpecificationSection(' . $langId . ',' . $prodSpecId . ')'
                                    ],
                                    [
                                        "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                                        "onclick" => 'deleteProdSpec(' . $prodSpecId . ',' . $langId . ')'
                                    ]
                                ];
                                $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$prodSpecId], false);
                                break;
                            default:
                                $td->appendElement('plaintext', array(), $specification[$key], true);
                                break;
                        }
                    }
                }
                echo $tbl->getHtml();
                ?>
            </div>
        </div>
    </div>
<?php } ?>