<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="row abcsd">
	<div class="col-md-12">
		<div class="table-responsive table-scrollable js-scrollable tablewrap">
			<?php
			$arr_flds = array(
				'prodspec_identifier' => Labels::getLabel('LBL_Identifier', $adminLangId),
				'prodspec_name' => Labels::getLabel('LBL_File_Title', $adminLangId),
				'prodspec_file' => Labels::getLabel('LBL_File', $adminLangId),
				/* 'prodspec_group' => Labels::getLabel('LBL_Specification_Group', $adminLangId), */
				'action' => Labels::getLabel('', $adminLangId)
			);

			$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-bordered table-justified'));
			$th = $tbl->appendElement('thead')->appendElement('tr');
			foreach ($arr_flds as $key => $val) {
				if ($key == 'prodspec_name' || $key == 'prodspec_value' || $key == 'prodspec_group') {
					$e = $th->appendElement('th', array('width' => '30%'), $val);
				} else {
					$e = $th->appendElement('th', array(), $val);
				}
			}
			
			$tbody = $tbl->appendElement('tbody');
			
			if (count($productSpecifications) > 0) {
				$count = 0;
				foreach ($productSpecifications as $specification) {
					$prodSpecId = $specification['prodspec_id'];
					$tr = $tbody->appendElement('tr', ['data-id' => $prodSpecId, 'data-nfid' => 0]);
					foreach ($arr_flds as $key => $val) {
						$tdAttr = ('action' == $key) ? ['class' => 'align-right'] : ['class' => str_replace(ProdSpecification::DB_TBL_PREFIX, '', $key) . "Js text-break"];
						$td = $tr->appendElement('td', $tdAttr);
						switch ($key) {
							case 'prodspec_file':
								$fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_PRODUCT_SPECIFICATION_FILE, $productId, $prodSpecId, $langId, false, 0, false);
								$fileHtml = '';
								if (!empty($fileData) && $fileData['afile_id'] > 0) {
									$tr->addValueToAttribute('data-ofid', $fileData['afile_id']);
									$fileArr = explode('.', $fileData['afile_name']);
									//$fileType = strtolower($fileArr[1]);
									$fileTypeIndex = count($fileArr) - 1;
									$fileType = strtolower($fileArr[$fileTypeIndex]);
									$imageTypes = array('gif', 'jpg', 'jpeg', 'png', 'svg', 'bmp', 'tiff');

									$attachmentUrl = CommonHelper::generateFullUrl('image', 'productSpecFile', array(AttachedFile::FILETYPE_PRODUCT_SPECIFICATION_FILE, $fileData['afile_record_id'], $fileData['afile_record_subid'], $fileData['afile_lang_id']), CONF_WEBROOT_FRONT_URL);
									if (in_array($fileType, $imageTypes)) {
										$imageSrc = CommonHelper::generateFullUrl('image', 'productSpecFile', array(AttachedFile::FILETYPE_PRODUCT_SPECIFICATION_FILE, $fileData['afile_record_id'], $fileData['afile_record_subid'], $fileData['afile_lang_id'], 50, 50), CONF_WEBROOT_FRONT_URL) . AttachedFile::setTimeParam($fileData['afile_updated_at']);
										$fileHtml = "<a href='" . $attachmentUrl . "' target='_blank' title='" . $fileData['afile_name'] . "'><img src='" . $imageSrc . "' class='img-thumbnail image-small' /> </a>";
									} else {
										$fileHtml = "<a href='" . $attachmentUrl . "' title='" . $fileData['afile_name'] . "' download><svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#icon-download'></use></svg></a>";
									}
								}
								$td->appendElement('plaintext', array(), $fileHtml, true);

								break;
							case 'prodspec_name':
								$columnValue = '';
								if($specification[$key] != '') {
									$columnValue = html_entity_decode($specification[$key], ENT_QUOTES, 'utf-8');
								}

								$identifierVal = '';
								if($specification['prodspec_identifier'] != '') {
									$identifierVal = html_entity_decode($specification['prodspec_identifier'], ENT_QUOTES, 'utf-8');
								}
								
								$inputIdentifier = new HtmlElement(
									'input',
									[
										'name' => 'fspecifications[' . $count . '][identifier]',
										'type' => 'hidden',
										'value' => $identifierVal,
										'data-fatreq' => json_encode(['required' => false])
									]
								);
								$input = new HtmlElement(
									'input',
									[
										'name' => 'fspecifications[' . $count . '][' . str_replace(ProdSpecification::DB_TBL_PREFIX, '', $key) . ']',
										'type' => 'hidden',
										'value' => $columnValue,
										'data-fatreq' => json_encode(['required' => false]),
									]
								);
								$td->appendElement('plaintext', $tdAttr, $specification[$key] . $input->getHtml() . $inputIdentifier->getHtml(), true);
								break;
							case 'action':
								$td->appendElement('input', ['type' => 'hidden', 'name' => 'fspecifications[' . $count . '][id]', 'value' => $prodSpecId]);
								$actionArr = [
									[
										"title" => Labels::getLabel('LBL_Edit', $adminLangId),
										"icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
										"onclick" => 'editFileSpec(this)'
									],
									[
										"title" => Labels::getLabel('LBL_Delete', $adminLangId),
										"icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
										"onclick" => 'deleteFileSpec(this)'
									]
								];
								$this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $prodSpecId], false);
								break;
							default:
								$td->appendElement('plaintext', array(), $specification[$key], true);
								break;
						}
					}
					$count = 0;
				}
			}
			echo $tbl->getHtml();
			?>
		</div>
	</div>
</div>