<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="row">
	<div class="col-md-12">
		<div class="table-responsive table-scrollable js-scrollable tablewrap">
			<?php
			$arr_flds = array(
				'prodspec_identifier' => Labels::getLabel('LBL_Identifier', $adminLangId),
				'prodspec_name' => Labels::getLabel('LBL_Specification_Name', $adminLangId),
				'prodspec_value' => Labels::getLabel('LBL_Value', $adminLangId),
				'prodspec_group' => Labels::getLabel('LBL_Group', $adminLangId),
				'action' => Labels::getLabel('', $adminLangId)
			);

			$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-justified'));
			$th = $tbl->appendElement('thead')->appendElement('tr');
			foreach ($arr_flds as $key => $val) {
				if ($key == 'prodspec_name' || $key == 'prodspec_value' || $key == 'prodspec_group') {
					$e = $th->appendElement('th', array('width' => '30%'), $val);
				} else {
					$e = $th->appendElement('th', array(), $val);
				}
			}

			$count = 0;
			$tbody = $tbl->appendElement('tbody');
			if (count($productSpecifications) > 0) {
				foreach ($productSpecifications as $specification) {
					$prodSpecId = $specification['prodspec_id'];
					$tr = $tbody->appendElement('tr', ['data-id' => $prodSpecId]);
					foreach ($arr_flds as $key => $val) {
						$tdAttr = ['class' => str_replace(ProdSpecification::DB_TBL_PREFIX, '', $key) . "Js"];
						$td = $tr->appendElement('td', $tdAttr);
						switch ($key) {
							case 'action':
								$prodSpecId = $specification['prodspec_id'];

								$td->appendElement('input', ['type' => 'hidden', 'name' => 'specifications[' . $count . '][id]', 'value' => $prodSpecId]);
								$actionArr = [
									[
										"title" => Labels::getLabel('LBL_Edit', $adminLangId),
										"icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
										"onclick" => 'editProdSpec(this)'
									],
									[
										"title" => Labels::getLabel('LBL_Delete', $adminLangId),
										"icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
										"onclick" => 'deleteProdSpec(this)'
									]
								];
								$this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $prodSpecId], false);
								break;
							case 'prodspec_name':
								$columnValue = '';
								if($specification[$key] != '') {
									$columnValue = html_entity_decode($specification[$key], ENT_QUOTES, 'utf-8');
								}

								$identifierVal = '';
								if($specification['prodspec_identifier'] != '') {
									$identifierVal = html_entity_decode($specification['prodspec_identifier'], ENT_QUOTES, 'utf-8');
								}
								$inputIdentifier = new HtmlElement(
									'input',
									[
										'name' => 'specifications[' . $count . '][identifier]',
										'type' => 'hidden',
										'value' => $identifierVal,
										'data-fatreq' => json_encode(['required' => false])
									]
								);
								$input = new HtmlElement(
									'input',
									[
										'name' => 'specifications[' . $count . '][' . str_replace(ProdSpecification::DB_TBL_PREFIX, '', $key) . ']',
										'type' => 'hidden',
										'value' => $columnValue,
										'data-fatreq' => json_encode(['required' => false]),
									]
								);
								$td->appendElement('plaintext', $tdAttr, $specification[$key] . $input->getHtml() . $inputIdentifier->getHtml(), true);
								break;
							default:
								$columnValue = '';
								if($specification[$key] != '') {
									$columnValue = html_entity_decode($specification[$key], ENT_QUOTES, 'utf-8');
								}
								$input = new HtmlElement(
									'input',
									[
										'name' => 'specifications[' . $count . '][' . str_replace(ProdSpecification::DB_TBL_PREFIX, '', $key) . ']',
										'type' => 'hidden',
										'value' => $columnValue,
										'data-fatreq' => json_encode(['required' => false]),
									]
								);
								$td->appendElement('plaintext', $tdAttr, $specification[$key] . $input->getHtml(), true);
								break;
						}
					}
					$count++;
				}
			}
			echo $tbl->getHtml();
			?>
		</div>
	</div>
</div>