<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="content content-space" <?php if (!empty($formLayout)) {
    echo 'dir="' . $formLayout . '"';
} ?>>
    <div class="page-title">
        <div class="row">
            <div class="col--first col-lg-6">
                <h5><?php echo Labels::getLabel('LBL_Manage_Catalog', $adminLangId); ?> </h5>
                <?php $this->includeTemplate('_partial/header/header-breadcrumb.php'); ?>
            </div>
        </div>
    </div>
    <?php
    $frm->addFormTagAttribute('class', 'form');
    $frm->setFormTagAttribute('id', 'addProductfrm');
    $frm->setFormTagAttribute('onsubmit', 'setup($(\'#addProductfrm\'));return false;');

    if ($totalProducts > 0) {
        $fldSeller = $frm->getField('product_seller_id');
        $fldSeller->setfieldTagAttribute('readonly', 'readonly');
    }
    echo $frm->getFormTag();
    ?>
    <div class="add-stock" id="addStock">
        <div class="add-stock-column column-main">
            <div class="card" id="basic-details">
                <div class="card-head">
                    <div class="card-head-label">
                        <h3 class="card-head-title"><?php echo Labels::getLabel('LBL_BASIC_DETAILS', $lang_id); ?></h3>
                        <span
                            class="text-muted"><?php echo Labels::getLabel('LBL_MANAGE_PRODUCT_BASIC_INFORMATION', $lang_id); ?></span>
                    </div>
                    <div class="content-header-toolbar">
                        <div class="input-group">
                            <?php
                            $langFld = $frm->getField('lang_id');
                            $langFld->setfieldTagAttribute('class', 'form-control form-select select-language');
                            $langFld->setfieldTagAttribute('onchange', 'langForm()');
                            echo $langFld->getHtml();
                            ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <?php
                        echo HtmlHelper::getFieldHtml($frm, 'product_identifier', 6, [], Labels::getLabel('MSG_A_UNIQUE_IDENTIFIER_ASSOCIATED_FOR_PRODUCT_NAME', $lang_id));

                        echo HtmlHelper::getFieldHtml($frm, 'product_seller_id', 6, ['id' => 'product_seller_id', 'placeholder' => Labels::getLabel('FRM_SELECT_SELLER', $lang_id)]);

                        echo HtmlHelper::getFieldHtml($frm, 'product_name', 6, [], Labels::getLabel('MSG_A_NAME_OF_THE_PRODUCT_TO_BE_LISTED', $lang_id));

                        echo HtmlHelper::getFieldHtml($frm, 'ptc_prodcat_id', 6, ['id' => 'ptc_prodcat_id', 'placeholder' => Labels::getLabel('FRM_SELECT_CATEGORY', $lang_id)]);

                        echo HtmlHelper::getFieldHtml($frm, 'product_brand_id', 6, ['id' => 'product_brand_id', 'placeholder' => Labels::getLabel('FRM_SELECT_BRAND', $lang_id)]);



                        if ($allowForSale) {
                            echo HtmlHelper::getFieldHtml($frm, 'product_min_selling_price', 6);
                        }

                        echo HtmlHelper::getFieldHtml($frm, 'ptt_taxcat_id_rent', 6, ['id' => 'ptt_taxcat_id_rent'], '', '', ['label' => Labels::getLabel('FRM_TAX_CATEGORIES', $lang_id), 'attr' => ['target' => '__blank', 'href' => UrlHelper::generateUrl('tax'), 'class' => 'lable-btn-underline'], 'attrType' => 'anchor']);

                        echo HtmlHelper::getFieldHtml($frm, 'ptt_taxcat_id', 6, ['id' => 'ptt_taxcat_id']);

                        echo HtmlHelper::getFieldHtml($frm, 'product_model', 6, ['id' => 'product_model']);

                        echo HtmlHelper::getFieldHtml($frm, 'product_warranty', 6, [], Labels::getLabel('MSG_Warranty_In_Days', $lang_id));

                        echo HtmlHelper::getFieldHtml($frm, 'product_youtube_video', 6);
                        echo HtmlHelper::getFieldHtml($frm, 'product_description', 12);
                        ?>
                    </div>
                </div>
            </div>
            <div class="card card-toggle" id="tax-shipping">
                <div class="card-head dropdown-toggle-custom" data-bs-toggle="collapse" data-bs-target="#stock-block4"
                    aria-expanded="true" aria-controls="stock-block4">
                    <div class="card-head-label">
                        <h3 class="card-head-title">
                            <?php echo Labels::getLabel('NAV_SHIPPING_INFORMATION', $lang_id); ?>
                        </h3>
                        <span class="text-muted">
                            <?php echo Labels::getLabel('MSG_SETUP_SHIPPING_INFORMATION_OF_THE_PRODUCT', $lang_id); ?>
                        </span>
                    </div>
                    <div class="card-head-toolbar">
                        <i class="dropdown-toggle-custom-arrow"></i>
                    </div>
                </div>
                <div class="collapse show" id="stock-block4">
                    <div class="card-body">
                        <div class="row">
                            <?php
                            echo HtmlHelper::getFieldHtml($frm, 'product_ship_package', 6);
                            echo HtmlHelper::getFieldHtml($frm, 'shipping_profile', 3, ['id' => 'shipping_profile']);
                            echo HtmlHelper::getFieldHtml($frm, 'product_weight', 3);
                            echo HtmlHelper::getFieldHtml($frm, 'product_weight_unit', 3);
                            echo HtmlHelper::getFieldHtml($frm, 'product_fulfillment_type', 3, ['id' => 'product_fulfillment_type']);
                            ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card card-toggle" id="variants-options">
                <div class="card-head dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                    data-bs-target="#variants-block" aria-expanded="false" aria-controls="variants-block">
                    <div class="card-head-label">
                        <h3 class="card-head-title"><?php echo Labels::getLabel('NAV_VARIANTS_&_OPTIONS', $lang_id); ?>
                        </h3>
                        <span
                            class="text-muted"><?php echo Labels::getLabel('MSG_CUSTOMIZE_PRODUCT_VARIENTS_INCLUDING_SIZE_COLOR_ETC', $lang_id); ?></span>
                    </div>
                    <div class="card-toolbar">
                        <i class="dropdown-toggle-custom-arrow"></i>
                    </div>
                </div>
                <div class="collapse" id="variants-block">
                    <div class="card-body">
                        <?php if (0 < $productId) { ?>
                            <div class="alert alert-custom alert-danger" role="alert">
                                <svg class="svg me-2" width="18" height="18" xmlns="http://www.w3.org/2000/svg"
                                    class="bi bi-exclamation-triangle-fill flex-shrink-0 me-2" viewBox="0 0 16 16"
                                    role="img" aria-label="Warning:">
                                    <path
                                        d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                </svg>
                                <div>
                                    <?php echo Labels::getLabel('ERR_IF_INVENTORY_IS_ALREADY_ADDED_THEN_YOU_CANNOT_UPDATE_OPTIONS.', $lang_id); ?>
                                </div>
                            </div>
                        <?php } ?>
                        <?php
                        $fld = $frm->getField('option_groups');
                        //$fld->addFieldTagAttribute('class', 'form-tagify');
                        //$fld->addFieldTagAttribute('id', 'product-options-js');
                        
                        ?>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo $fld->getHtml(); ?>
                                <div class="list-tag-wrapper scroll scroll-y mt-2 variant-wrapper-js <?php if (empty($productOptions)) {
                                    echo 'd-none';
                                } ?>">
                                    <ul class="list-tags" id="vaiants-list-js">
                                        <?php
                                        if (!empty($productOptions)) {
                                            foreach ($productOptions as $prodOption) {
                                                $optionName = !empty($prodOption['option_name']) ? $prodOption['option_name'] : $prodOption['option_identifier'];
                                                ?>
                                                <li class="list-tags-item" id="variants<?php echo $prodOption['option_id']; ?>">
                                                    <span class="d-flex align-items-center gap-2">
                                                        <?php echo $optionName; ?> &nbsp;
                                                        <i class="remove-variant-js remove_param btn-close"
                                                            data-id="<?php echo $prodOption['option_id']; ?>"></i>
                                                        <input type="hidden" name="prod_options[]"
                                                            value="<?php echo $prodOption['option_id']; ?>" />
                                                    </span>
                                                </li>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-md-12 option-values-js mt-4" <?php if (empty($prodOptValCombArr)) { ?>
                                    style="display:none;" <?php } ?>>
                                <h3 class="card-head-title"><?php echo Labels::getLabel('MSG_Variants', $lang_id); ?>
                                </h3>
                                <div class="list-tag-wrapper scroll scroll-y mt-2">
                                    <ul class="list-tags">
                                        <?php if (!empty($prodOptValCombArr)) { ?>
                                            <?php foreach ($prodOptValCombArr as $row) { ?>
                                                <li class="list-tags-item"><?php echo $row; ?></li>
                                            <?php } ?>
                                        <?php } ?>
                                    </ul>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="card card-toggle" id="media">
                <div class="card-head dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                    data-bs-target="#stock-block2" aria-expanded="false" aria-controls="stock-block2">
                    <div class="card-head-label">
                        <h3 class="card-head-title"><?php echo Labels::getLabel('NAV_MEDIA', $lang_id); ?> </h3>
                        <span
                            class="text-muted"><?php echo Labels::getLabel('MSG_MANAGE_YOUR_PRODUCT_IMAGES_GALLERY', $lang_id); ?>
                        </span>
                    </div>
                    <div class="card-toolbar">
                        <i class="dropdown-toggle-custom-arrow"></i>
                    </div>
                </div>
                <div class="collapse" id="stock-block2">
                    <div class="card-body">
                        <div>
                            <div class="d-flex justify-content-between mb-3">
                                <h6 class="h6 "><?php echo Labels::getLabel('LBL_UPLOADED_MEDIA', $lang_id); ?></h6>
                                <a href="javascript:void(0)" onclick="imageForm();"
                                    class="link-underline"><?php echo Labels::getLabel('LBL_ADVANCE_MEDIA', $lang_id); ?></a>
                            </div>
                            <div class="col-md-12">
                                <?php
                                /* [ MEDIA INSTRUCTIONS START HERE */
                                $tpl = new FatTemplate('', '');
                                $tpl->set('adminLangId', $lang_id);
                                echo $tpl->render(false, false, '_partial/imageUploadInstructions.php', true, true);
                                /* ] */
                                ?>
                            </div>


                            <ul class="uploaded-stocks ui-sortable" id="productDefaultImagesJs">
                                <li class="browse unsortableJs">
                                    <button type="button" class="browse-button"
                                        onclick="$('#hiddenMediaFrmFileJs').click();">
                                        <strong><?php echo Labels::getLabel('LBL_UPLOAD_IMAGES(S)', $lang_id); ?></strong>
                                    </button>
                                </li>
                                <li class="browse unsortableJs">
                                    <button type="button" class="browse-button"
                                        onclick="$('#hiddenMediaFrmFileJs').click();">
                                        <strong><?php echo Labels::getLabel('LBL_UPLOAD_IMAGES(S)', $lang_id); ?></strong>
                                        <span class="text-muted form-text">Png,jpeg accepted</span>
                                        <!--@todo need to make it dynamic -->
                                    </button>
                                </li>
                                <li class="unsortableJs">
                                    <div class="uploaded-stocks-item" data-ratio="1:1">
                                        <img class="uploaded-stocks-img" data-bs-toggle="tooltip" data-placement="top"
                                            src="./images/defaults/product_default_image.jpg" title="" alt=""
                                            data-bs-original-title="">
                                        <div class="uploaded-stocks-actions"><button type="button" class="btn-close"
                                                aria-label="Close"></button></div>
                                    </div>
                                </li>
                            </ul>
                            <div class="form-text text-muted pt-2">
                                <?php echo Labels::getLabel('LBL_Please_keep_image_dimensions_greater_than', $lang_id) . ' ' . $imageSize['width'] . ' x ' . $imageSize['height']; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card card-toggle" id="specifications">
                <div class="card-head dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                    data-bs-target="#specifications-block" aria-expanded="false" aria-controls="specifications-block">
                    <div class="card-head-label">
                        <h3 class="card-head-title"><?php echo Labels::getLabel('NAV_SPECIFICATIONS', $lang_id); ?></h3>
                        <span
                            class="text-muted"><?php echo Labels::getLabel('MSG_MANAGE_PRODUCT_RELATED_SPECIFICATIONS', $lang_id); ?></span>
                    </div>
                    <div class="card-head-toolbar">
                        <i class="dropdown-toggle-custom-arrow"></i>
                    </div>
                </div>
                <div class="collapse" id="specifications-block">
                    <div class="card-body">
                        <div id="specificationsFormJs">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="label">
                                            <?php echo Labels::getLabel('FRM_SPECIFICATION_IDENTIFIER', $lang_id); ?>
                                        </label>
                                        <input type="text" name="sp_identifier" id="sp_identifier" value=""
                                            data-required="1">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="label">
                                            <?php echo Labels::getLabel('FRM_SPECIFICATION_NAME', $lang_id); ?>
                                        </label>
                                        <input type="text" name="sp_label" id="sp_label" value="" data-required="1">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="label">
                                            <?php echo Labels::getLabel('FRM_SPECIFICATION_VALUE', $lang_id); ?>
                                        </label>
                                        <input type="text" name="sp_value" id="sp_value" value="" data-required="1">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="label">
                                            <?php echo Labels::getLabel('FRM_SPECIFICATION_GROUP', $lang_id); ?>
                                        </label>
                                        <input type="text" name="sp_group" id="sp_group" value="" data-required="0">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <button type="button" id="btnClearSpecJs" class="btn btn-outline-brand btn-wide"
                                            onclick="clearProdSpecForm()"
                                            data-updateLbl="<?php echo Labels::getLabel('BTN_UPDATE', $lang_id); ?>"
                                            data-addLbl="<?php echo Labels::getLabel('BTN_ADD', $lang_id); ?>">
                                            <?php echo Labels::getLabel('BTN_CLEAR', $lang_id); ?>
                                        </button>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <div class="form-group">
                                        <input type="hidden" name="sp_id" id="sp_id" value="0" data-required="0">
                                        <button type="button" id="btnAddSpecJs" class="btn btn-brand btn-wide"
                                            onclick="addSpecification()"
                                            data-updateLbl="<?php echo Labels::getLabel('BTN_UPDATE', $lang_id); ?>"
                                            data-addLbl="<?php echo Labels::getLabel('BTN_ADD', $lang_id); ?>">
                                            <?php echo Labels::getLabel('BTN_ADD', $lang_id); ?>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-table">
                        <div id="specificationsListSeprJs" class="separator separator-dashed my-0">
                        </div>
                        <div id="specificationsListJs"></div>

                    </div>
                </div>
            </div>

            <div class="card card-toggle" id="file-specifications">
                <div class="card-head dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                    data-bs-target="#file-specifications-block" aria-expanded="false"
                    aria-controls="file-specifications-block">
                    <div class="card-head-label">
                        <h3 class="card-head-title"><?php echo Labels::getLabel('NAV_FILE_SPECIFICATIONS', $lang_id); ?>
                        </h3>
                        <span
                            class="text-muted"><?php echo Labels::getLabel('MSG_MANAGE_PRODUCT_RELATED_FILE_SPECIFICATIONS', $lang_id); ?>
                        </span>
                    </div>
                    <div class="card-toolbar"> <i class="dropdown-toggle-custom-arrow"></i></div>
                </div>
                <div class="collapse" id="file-specifications-block">
                    <div class="card-body">
                        <div class="col-md-12">
                            <?php
                            /* [ MEDIA INSTRUCTIONS START HERE */
                            $tpl = new FatTemplate('', '');
                            $tpl->set('adminLangId', $lang_id);
                            echo $tpl->render(false, false, '_partial/imageUploadInstructions.php', true, true);
                            /* ] */
                            ?>
                        </div>
                        <div id="file-specificationsFormJs">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="label">
                                            <?php echo Labels::getLabel('FRM_SPECIFICATION_IDENTIFIER', $lang_id); ?>
                                        </label>
                                        <input type="text" name="fsp_identifier" id="fsp_identifier" value=""
                                            data-required="1">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="label">
                                            <?php echo Labels::getLabel('FRM_SPECIFICATION_NAME', $lang_id); ?>
                                        </label>
                                        <input type="text" name="fsp_name" id="fsp_name" value="" data-required="1">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="label">
                                            <span
                                                class="filename"><?php echo Labels::getLabel('LBL_Specification_File_Is_Mandatory', $lang_id); ?></span>
                                        </label>
                                        <input id="hiddenSpecFileFrmFileJs" accept="image/*"
                                            data-name="<?php echo Labels::getLabel("FRM_SPECIFICATION_FILE", $lang_id); ?>"
                                            data-field-caption="<?php echo Labels::getLabel("FRM_SPECIFICATION_FILE", $lang_id); ?>"
                                            data-ids="prodspec_file" type="file" data-frm="fileSpecFrm"
                                            name="prodspec_file" onChange="uploadFileSpecFile(this);">
                                        <div id="filespectempJs"></div>
                                        <input id="hiddenSpecFileIdJs" data-is_file="1" type="hidden"
                                            id="prodspecFileIdJs" name="prodspec_file_id" data-required="1">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <button type="button" id="btnClearFileSpecJs"
                                            class="btn btn-outline-brand btn-wide" onclick="clearFileSpecForm()"
                                            data-updateLbl="<?php echo Labels::getLabel('BTN_UPDATE', $lang_id); ?>"
                                            data-addLbl="<?php echo Labels::getLabel('BTN_ADD', $lang_id); ?>">
                                            <?php echo Labels::getLabel('BTN_CLEAR', $lang_id); ?>
                                        </button>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <input type="hidden" name="fsp_id" id="fsp_id" value="0" data-required="0">
                                    <button type="button" id="btnAddFileSpecJs" class="btn btn-brand btn-wide"
                                        onclick="addFileSpecification()"
                                        data-updatelbl="<?php echo Labels::getLabel('BTN_UPDATE', $lang_id); ?>"
                                        data-addLbl="<?php echo Labels::getLabel('BTN_ADD', $lang_id); ?>">
                                        <?php echo Labels::getLabel('BTN_ADD', $lang_id); ?>
                                    </button>
                                </div>

                            </div>
                        </div>
                        <div id="file-specificationsListSeprJs" class="separator separator-dashed my-4"></div>
                        <div id="file-specificationsListJs"></div>
                    </div>
                </div>
            </div>
            <div class="card card-toggle disabled" id="customfields" style="display:none">
                <div class="card-head dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                    data-bs-target="#customfields-block" aria-expanded="false" aria-controls="specifications-block">
                    <div class="card-head-label">
                        <h3 class="card-head-title"><?php echo Labels::getLabel('NAV_CUSTOM_FIELDS', $lang_id); ?>
                        </h3>
                        <span
                            class="text-muted"><?php echo Labels::getLabel('MSG_MANAGE_PRODUCT_CUSTOM_FIELDS', $lang_id); ?>
                        </span>
                    </div>
                    <div class="card-toolbar"> <i class="dropdown-toggle-custom-arrow"></i></div>
                </div>
                <div class="collapse" id="customfields-block">
                    <div class="card-body">
                        <div id="CustomFieldsFormJs"></div>
                    </div>
                </div>
            </div>

        </div>
        <div class="add-stock-column column-actions">
            <div class="sticky-top">
                <div class="card">
                    <div class="card-body">
                        <?php
                        $fld = $frm->getField('btn_submit');
                        $fld->addFieldTagAttribute('class', 'btn btn-brand btn-block');
                        echo $frm->getFieldHtml('btn_submit');
                        echo $frm->getFieldHtml('product_id');
                        echo $frm->getFieldHtml('temp_record_id');
                        echo $frm->getFieldHtml('product_type');
                        ?>

                        <div class="mt-3">
                            <?php
                            $fld = $frm->getField('product_active');
                            HtmlHelper::configureSwitchForCheckbox($fld);
                            echo '<div class="form-group">
										<div class="setting-block">' . $fld->getHtml() . '</div>
									</div>';

                            $fld = $frm->getField('product_approved');
                            HtmlHelper::configureSwitchForCheckbox($fld);
                            echo '<div class="form-group">
										<div class="setting-block">' . $fld->getHtml() . '</div>
									</div>';

                            $fld = $frm->getField('product_featured');
                            HtmlHelper::configureSwitchForCheckbox($fld);
                            echo '<div class="form-group">
										<div class="setting-block">' . $fld->getHtml() . '</div>
									</div>';
                            $fld = $frm->getField('auto_update_other_langs_data');
                            if (null != $fld) {
                                HtmlHelper::configureSwitchForCheckbox($fld);
                                echo '<div class="form-group">
											<div class="setting-block">' . $fld->getHtml() . '</div>
										</div>';
                            }
                            $fld = $frm->getField('product_cod_enabled');
                            if (null != $fld && $codEnabled) {
                                $fld->developerTags['cbLabelAttributes'] = array('class' => 'checkbox');

                                HtmlHelper::configureSwitchForCheckbox($fld);
                                echo '<div class="form-group">
											<div class="setting-block">' . $fld->getHtml() . '</div>
										</div>';
                            }
                            ?>
                        </div>
                    </div>
                </div>

                <?php
                $fld = $frm->getField('tag_name');
                if (null != $fld) {
                    $fld->addFieldTagAttribute('class', 'form-tagify');
                    $fld->addFieldTagAttribute('id', '$lang_id');
                    ?>

                    <div class="card">
                        <div class="card-head">
                            <div class="card-head-label">
                                <h3 class="card-head-title"> <?php echo Labels::getLabel('FRM_Tags', $lang_id); ?></h3>
                                <span class="text-muted">
                                    <?php echo Labels::getLabel('FRM_BIND_TAGS_TO_MAKE_IT_EASIER_TO_APPEAR_IN_SEARCH_RESULTS', $lang_id); ?>
                                </span>
                            </div>
                        </div>
                        <div class="card-body">
                            <?php echo $fld->getHtml(); ?>
                        </div>
                    </div>
                <?php } ?>

                <div class="card" id="size-chart-card-js" <?php if (empty($productData['sizeChartArr'])) { ?>
                        style="display:none" <?php } ?>>
                    <!--div class="card" style="display:none" id="size-chart-card-js" -->
                    <div class="card-head">
                        <div class="card-head-label">
                            <h3 class="card-head-title"> <?php echo Labels::getLabel('FRM_Size_chart', $lang_id); ?>
                            </h3>
                            <span class="text-muted">
                                <?php echo Labels::getLabel('FRM_Upload_Size_chart_for_better_clarity', $lang_id); ?>
                            </span>
                        </div>
                    </div>
                    <div class="card-body">
                        <input onchange="popupSizeChartImage(this)" accept="image/*" type="file" name="prod_size_chart"
                            value="">
                        <input type="hidden" name="size_chart_temp_id" id="sizechart-temp-id-js">
                        <div id="size-chart-image-js">
                            <?php
                            if (!empty($productData['sizeChartArr'])) {
                                $sizeChart = current($productData['sizeChartArr']);

                                $sizeChartData = [
                                    'recordId' => $sizeChart['afile_id'],
                                    'tempRecord' => applicationConstants::NO,
                                    'langId' => $lang_id,
                                    'imgUrl' => CommonHelper::generateUrl('image', 'productSizeChart', array($sizeChart['afile_record_id'], "THUMB", $sizeChart['afile_id']), CONF_WEBROOT_FRONTEND)
                                ];

                                $this->includeTemplate('products/single-catalog-form/image.php', $sizeChartData);
                                if (0) { ?>
                                    <img src="<?php echo CommonHelper::generateUrl('image', 'productSizeChart', array($sizeChart['afile_record_id'], "THUMB", $sizeChart['afile_id']), CONF_WEBROOT_FRONTEND); ?>"
                                        title="<?php echo $sizeChart['afile_name']; ?>"
                                        alt="<?php echo $sizeChart['afile_name']; ?>">
                                    <?php
                                }
                            }

                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </form>
    <?php echo $frm->getExternalJS(); ?>

    <?php
    $imgFrm->setFormTagAttribute('class', 'hidden');
    $imgFrm->setFormTagAttribute('name', 'hiddenMediaFrm');
    $imgFrm->setFormTagAttribute('id', 'hiddenMediaFrmJs');
    $fld = $imgFrm->getField('prod_image');
    $fld->addFieldTagAttribute('onChange', "loadCropper(this, false)");
    $fld->addFieldTagAttribute('id', "hiddenMediaFrmFileJs");
    $fld->addFieldTagAttribute('data-frm', 'hiddenMediaFrm');
    //$fld->addFieldTagAttribute('accept', "image/*");
    //$fld->addFieldTagAttribute('data-name', Labels::getLabel("FRM_PRODUCT_IMAGE", $lang_id));
    echo $imgFrm->getFormHtml();
    ?>
</div>
<script>
    fcom.resetEditorWidth();
    var catId = '<?php echo $prodCatId; ?>';
    var specificationFileLbl = '<?php echo Labels::getLabel('FRM_Specification_file_is_mandatory', $lang_id); ?>';
    $(function () {
        productDefaultImages();
        getCustomFields(catId);
        prodSpecifications();
        fileSpecifications();
    });

    var totalProducts = '<?php echo $totalProducts; ?>';
    getLangId = function () {
        return $("#addProductfrm [name='lang_id']").val();
    };

    getProductId = function () {
        return $("#addProductfrm [name='product_id']").val();
    };

    getTempProductId = function () {
        return $("#addProductfrm [name='temp_record_id']").val();
    };

    if (totalProducts > 0) {
        $('select[name=\'product_seller_id\']').attr('disabled', true);
    } else {
        $("#product_seller_id").select2({
            closeOnSelect: true,
            dir: '<?php echo $formLayout; ?>',
            allowClear: true,
            theme: "default custom-select2 beautify-select2",
            placeholder: $("#product_seller_id").attr('placeholder'),
            ajax: {
                url: fcom.makeUrl('products', 'autoCompleteUserShopName'),
                dataType: 'json',
                delay: 250,
                method: 'post',
                data: function (params) {
                    return {
                        keyword: params.term,
                        page: params.page,
                        fIsAjax: 1,
                    };
                },
                processResults: function (data, params) {
                    params.page = params.page || 1;
                    return {
                        results: data.results,
                        pagination: {
                            more: params.page < data.pageCount
                        }
                    };
                },
                cache: true
            },
            minimumInputLength: 0
        }).on('select2:selecting', function (e) {
            var item = e.params.args.data;
            getShippingProfileOptions(item.id);
        }).on("select2:unselecting", function (e) {
            getShippingProfileOptions(0);
        });
    }

    $("#product_brand_id").select2({
        closeOnSelect: true,
        dir: '<?php echo $formLayout; ?>',
        allowClear: true,
        theme: "default custom-select2 beautify-select2",
        placeholder: $("#product_brand_id").attr('placeholder'),
        ajax: {
            url: fcom.makeUrl('brands', 'autoCompleteForSelect2', '', '/'),
            dataType: 'json',
            delay: 250,
            method: 'post',
            data: function (params) {
                return {
                    keyword: params.term,
                    page: params.page,
                    fIsAjax: 1,
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: data.results,
                    pagination: {
                        more: params.page < data.pageCount
                    }
                };
            },
            cache: true
        },
        minimumInputLength: 0
    });

    $("#ptc_prodcat_id").select2({
        closeOnSelect: true,
        dir: '<?php echo $formLayout; ?>',
        allowClear: true,
        theme: "default custom-select2 beautify-select2",
        placeholder: $("#ptc_prodcat_id").attr('placeholder'),
        ajax: {
            url: fcom.makeUrl('products', 'categoriesAutocomplete', '', '/'),
            dataType: 'json',
            delay: 250,
            method: 'post',
            data: function (params) {
                return {
                    keyword: params.term,
                    page: params.page,
                    fIsAjax: 1,
                };
            },
            processResults: function (data, params) {
                params.page = 1;
                return {
                    results: data.results,
                };
            },
            cache: true
        },
        minimumInputLength: 0
    }).on('select2:selecting', function (e) {
        var item = e.params.args.data;
        getCustomFields(item.id);
    });

    addTagData = function (e) {
        let rt_id = e.detail.data.id;
    };

    removeTagData = function (e) {
        var tag_id = e.detail.tag.id;
        var product_id = getProductId();
        if (1 > product_id || '' == tag_id) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Products', 'removeProductTag'), 'product_id=' + product_id + '&tag_id=' +
            tag_id,
            function (t) { });
        tagifyProducts();
    };

    getTagsAutoComplete = function (e) {
        var keyword = e.detail.value;
        var list = [];
        fcom.ajax(fcom.makeUrl('Tags', 'autoComplete'), {
            keyword: keyword
        }, function (t) {
            var ans = $.parseJSON(t);
            for (i = 0; i < ans.length; i++) {
                list.push({
                    "id": ans[i].id,
                    "value": ans[i].tag_identifier,
                });
            }
            tagify.settings.whitelist = list;
            tagify.loading(false).dropdown.show.call(tagify, keyword);
        });
    }

    tagify = new Tagify(document.querySelector('input[name=tag_name]'), {
        whitelist: [],
        delimiters: "#",
        editTags: false,
    }).on('add', addTagData).on('remove', removeTagData).on('input', getTagsAutoComplete);


    $("select[name='option_groups']").select2({
        closeOnSelect: true,
        dir: '<?php echo $formLayout; ?>',
        allowClear: true,
        theme: "default custom-select2 beautify-select2",
        placeholder: $("select[name='option_groups']").attr('placeholder'),
        ajax: {
            url: fcom.makeUrl('Options', 'autoComplete'),
            dataType: 'json',
            delay: 250,
            method: 'post',
            data: function (params) {
                var parentForm = $("select[name='option_groups']").closest('form').attr('id');
                var selectedFields = [];
                $('input[name="prod_options[]"]').each(function () {
                    selectedFields.push($(this).val());
                });

                return {
                    keyword: params.term,
                    page: params.page,
                    fIsAjax: 1,
                    product_id: getProductId(),
                    /*selProdId: $("#" + parentForm + " input[name='vflds_id']").val(),*/
                    selectedFields: selectedFields,
                };
            },
            processResults: function (data, params) {
                params.page = 1;
                return {
                    results: data
                };
            },
            cache: true
        },
        minimumInputLength: 0,
        templateResult: function (result) {
            return result.name;
        },
        templateSelection: function (result) {
            return result.name || result.text;
        }
    }).on('select2:selecting', function (e) {
        var parentForm = $(this).closest('form').attr('id');
        var item = e.params.args.data;
        $('input[name=\'option_groups\']').val('');
        $('#variants' + item.id).remove();
        $('#vaiants-list-js').append('<li class="list-tags-item"  id="variants' + item.id +
            '"><span class="d-flex align-items-center gap-2"> ' + item
                .name +
            '&nbsp; <i class="remove-variant-js remove_param btn-close" data-id="' + item.id +
            '"></i><input type="hidden" name="prod_options[]" value="' + item.id + '" /></span></li>');
        validateAttachedOptions(item.id);
        setTimeout(function () {
            $("select[name='option_groups']").val('').trigger('change');
        }, 200);

    });

    $('#vaiants-list-js').delegate('.remove-variant-js', 'click', function () {
        var thisobj = this;
        let productId = getProductId();
        if (productId > 0) {
            var option_id = $(this).data('id');
            fcom.ajax(fcom.makeUrl("Products", "checkOptionLinkedToInventory"), "product_id=" + productId +
                "&option_id=" + option_id,
                function (t) {
                    ans = jQuery.parseJSON(t);
                    if (ans.status != true) {
                        var agree = alert(ans.msg);
                        return false;
                    }
                    $(thisobj).parents('li').remove();
                    loadOptionValues();
                });
        } else {
            $(this).parents('li').remove();
            loadOptionValues();
        }
        toggleWrapper();
    });

    loadOptionValues = function () {
        var optionsData = $('input[name="prod_options[]"]').serializeArray();
        if (optionsData.length == 0) {
            $('.option-values-js').hide();
            //$('#sizechart-temp-id-js').val(0);
            $('#size-chart-card-js').hide();
            //$('.delete-size-chart-js').trigger('click');
        } else {
            fcom.ajax(fcom.makeUrl("Products", "loadOptionValues"), optionsData, function (t) {
                var ans = $.parseJSON(t);
                if (ans.optionValArr == '') {
                    $('.option-values-js').hide();
                    $('#size-chart-card-js').hide();
                    //$('#sizechart-temp-id-js').val(0);
                    //$('.delete-size-chart-js').trigger('click');
                } else {
                    if (ans.sizeChartCanBeAttached == 1) {
                        $('#size-chart-card-js').show();
                    } else {
                        $('#size-chart-card-js').hide();
                        //$('#sizechart-temp-id-js').val(0);
                        //$('.delete-size-chart-js').trigger('click');
                    }

                    var optionsValHtml = '';
                    $.each(ans.optionValArr, function (id, name) {
                        optionsValHtml += '<li>' + name + '</li>';
                    });
                    $('.option-values-js .list-tags').html(optionsValHtml);
                    $('.option-values-js').show();
                }
            });
        }
    };

    validateAttachedOptions = function (selectedOptionId) {
        var optionsData = $('input[name="prod_options[]"]').serializeArray();
        fcom.ajax(fcom.makeUrl("Products", "validateAttachedOptions"), optionsData, function (t) {
            var ans = $.parseJSON(t);
            if (ans.status == 0) {
                $.mbsmessage.error(ans.msg);
                $('#variants' + selectedOptionId).remove();
            } else {
                if (ans.sizeChartCanBeAttached == 1) {
                    $('#size-chart-card-js').show();
                }

                var optionsValHtml = '';
                $.each(ans.optionValArr, function (id, name) {
                    optionsValHtml += '<li>' + name + '</li>';
                });
                $('.option-values-js .list-tags').html(optionsValHtml);
                $('.option-values-js').show();
            }
            toggleWrapper();
        });
    };

    toggleWrapper = function () {
        setTimeout(function () {
            if ($('.variant-wrapper-js ul li').length === 0) {
                $('.variant-wrapper-js').addClass('d-none');
            } else {
                $('.variant-wrapper-js').removeClass('d-none');
            }
        }, 300);
    }

    var editors = oUtil.arrEditor;
    var lang_id_js = '<?php echo $lang_id; ?>';
    for (x in editors) {
        var oEdit1 = eval(editors[x]);
        var layout = langLbl['language' + lang_id_js];
        $('#idContent' + editors[x]).contents().find("body").css('direction', layout);
        $('#idArea' + oEdit1.oName + ' td[dir="ltr"]').attr('dir', layout);
    }
</script>
<style>
#customFormFieldsJs .list-inline-fluid {
	flex-flow: wrap;
}
</style>