<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$frmPromotion->setFormTagAttribute('class', 'form web_form form_horizontal');
$frmPromotion->setFormTagAttribute('onsubmit', 'setupPromotion(this); return(false);');
$frmPromotion->developerTags['colClassPrefix'] = 'col-md-';
$frmPromotion->developerTags['fld_default_col'] = 12;

$shopFld = $frmPromotion->getField('promotion_shop');
$shopFld->setWrapperAttribute('class', 'promotion_shop_fld');
$shopFld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('LBL_Note:_Used_to_promote_shop.', $adminLangId) . '</small>';

$shopCpcFld = $frmPromotion->getField('promotion_shop_cpc');
$shopCpcFld->setWrapperAttribute('class', 'promotion_shop_fld');
$shopCpcFld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('MSG_PPC_cost_per_click_for_shop', $adminLangId) . '</small>';

$productFld = $frmPromotion->getField('promotion_product');
$productFld->setWrapperAttribute('class', 'promotion_product_fld');
$productFld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('LBL_Note:_Used_to_promote_product.', $adminLangId) . '</small>';

$productCpcFld = $frmPromotion->getField('promotion_product_cpc');
$productCpcFld->setWrapperAttribute('class', 'promotion_product_fld');
$productCpcFld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('MSG_PPC_cost_per_click_for_Product', $adminLangId) . '</small>';

$locationFld = $frmPromotion->getField('banner_blocation_id');
$locationFld->setWrapperAttribute('class', 'location_fld');

$bannerPosFld = $frmPromotion->getField('banner_position');
$bannerPosFld->setWrapperAttribute('class', 'banner_position_fld');

$urlFld = $frmPromotion->getField('banner_url');
$urlFld->setWrapperAttribute('class', 'banner_url_fld');
$urlFld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('LBL_Note:_Used_to_promote_through_banner.', $adminLangId) . '</small>';

$slideUrlFld = $frmPromotion->getField('slide_url');
$slideUrlFld->setWrapperAttribute('class', 'slide_url_fld');
$slideUrlFld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('LBL_Note:_Used_to_promote_through_slider.', $adminLangId) . '</small>';

$slideCpcFld = $frmPromotion->getField('promotion_slides_cpc');
$slideCpcFld->setWrapperAttribute('class', 'slide_url_fld');
$slideCpcFld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('MSG_PPC_cost_per_click_for_Slides', $adminLangId) . '</small>';
$recordId = $promotionId;
$tabsButtons = [
	[
		'attr' => [
			'onclick' => 'addPromotionForm(' . $recordId . ');',
			'title' => Labels::getLabel('LBL_General', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_General', $adminLangId),
		'isActive' => true
	],
	[
		'attr' => [
			'onclick' => $promotionId ? "promotionLangForm(" . $promotionId . "," . FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1) . ");" : "",
			'title' => Labels::getLabel('LBL_Language_Data', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Language_Data', $adminLangId),
		'isActive' => false
	]
	
];
if ($promotionType == Promotion::TYPE_BANNER || $promotionType == Promotion::TYPE_SLIDES) {
$tabsButtons[] = 
	[
		'attr' => [
			'onclick' => ($promotionId > 0) ? "promotionMediaForm(" . $promotionId .");" : "",
			'title' => Labels::getLabel('LBL_Media', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Media', $adminLangId),
		'isActive' => false
	];
}

$formTitle = Labels::getLabel('LBL_Promotion_Setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>

<?php echo $frmPromotion->getFormHtml(); ?>
<script type="text/javascript">
	var bannerLayoutData = '<?php echo json_encode($bannerLayoutData); ?>';

	jQuery('.time').datetimepicker({
		datepicker: false,
		format: 'H:i:00',
	});

	$('.modal').on('hidden.bs.modal', function () {
		$(this).find('.time').datetimepicker('destroy');
		$(this).find('.xdsoft_datetimepicker').remove();
	});


	$("document").ready(function () {
		var PROMOTION_TYPE_BANNER = <?php echo Promotion::TYPE_BANNER; ?>;
		var PROMOTION_TYPE_SHOP = <?php echo Promotion::TYPE_SHOP; ?>;
		var PROMOTION_TYPE_PRODUCT = <?php echo Promotion::TYPE_PRODUCT; ?>;
		var PROMOTION_TYPE_SLIDES = <?php echo Promotion::TYPE_SLIDES; ?>;

		$("select[name='promotion_type']").change(function () {
			var promotionType = $(this).val();
			$(".promotion_shop_fld").hide();
			$(".promotion_product_fld").hide();
			$(".banner_url_fld").hide();
			$(".location_fld").hide();
			$(".banner_position_fld").hide();
			$(".slide_url_fld").hide();

			if (promotionType == PROMOTION_TYPE_BANNER) {
				$(".banner_url_fld").show();
				$(".location_fld").show();
			}

			if (promotionType == PROMOTION_TYPE_SHOP) {
				$(".promotion_shop_fld").show();
			}

			if (promotionType == PROMOTION_TYPE_PRODUCT) {
				$(".promotion_product_fld").show();
			}

			if (promotionType == PROMOTION_TYPE_SLIDES) {
				$(".slide_url_fld").show();
			}

			fcom.updateWithAjax(fcom.makeUrl('Promotions', 'getTypeData', [<?php echo $promotionId; ?>, promotionType]), '', function (t) {
				$.systemMessage.close();
				if (t.promotionType == PROMOTION_TYPE_SHOP) {
					$("input[name='promotion_shop']").val(t.label);
				} else if (t.promotionType == PROMOTION_TYPE_PRODUCT) {
					$("input[name='promotion_product']").val(t.label);
				}
				$("input[name='promotion_record_id']").val(t.value);
			});
		});

		$("select[name='promotion_type']").trigger('change');

		$('input[name=\'promotion_product\']').autocomplete({
			'classes': {
				"ui-autocomplete": "custom-ui-autocomplete"
			},
			'source': function (request, response) {
				$.ajax({
					url: fcom.makeUrl('Promotions', 'autoCompleteSelprods', [$('input[name=\'promotion_user_id\']').val()]),
					data: { keyword: request['term'], fIsAjax: 1 },
					dataType: 'json',
					type: 'post',
					success: function (json) {

						response($.map(json, function (item) {
							return { label: item['name'], value: item['name'], id: item['id'] };
						}));
					},
				});
			},
			select: function (event, ui) {
				$("input[name='promotion_record_id']").val(ui.item.id);
			}
		});

		bannerLayoutData = $.parseJSON(bannerLayoutData);
		$('select[name="banner_blocation_id"]').on('change', function () {
			var positionId = parseInt($(this).val());
			if (positionId > 0) {
				var layoutType = bannerLayoutData[positionId].collection_layout_type;
				if (layoutType == <?php echo Collections::TYPE_BANNER_LAYOUT4; ?>) {
					$(".banner_position_fld").show();
				} else {
					$(".banner_position_fld").hide();
				}
			}
		})
		$('select[name="banner_blocation_id"]').trigger('change');

	});
</script>
<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>