<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$mediaFrm->setFormTagAttribute('class', 'form web_form form_horizontal');
$mediaFrm->setFormTagAttribute('onsubmit', 'setupPromotion(this); return(false);');
$mediaFrm->developerTags['colClassPrefix'] = 'col-md-';
$mediaFrm->developerTags['fld_default_col'] = 12;

$fld1 = $mediaFrm->getField('banner_image');
$fld1->addFieldTagAttribute('onChange', 'popupImage(this)');
$fld1->htmlAfterField = '<div class="img-crop--js"></div>';


$langFld = $mediaFrm->getField('lang_id');
$langFld->addFieldTagAttribute('class', 'language-js');
$screenFld = $mediaFrm->getField('banner_screen');
$screenFld->addFieldTagAttribute('class', 'display-js');

$htmlAfterField = '';
$width = 1350;
$height = 405;

if (!empty($bannerSizeArr)) {
    if ($promotionType == Promotion::TYPE_BANNER) {
        $width = $bannerSizeArr[applicationConstants::SCREEN_DESKTOP]['width'];
        $height = $bannerSizeArr[applicationConstants::SCREEN_DESKTOP]['height'];
    } elseif ($promotionType == Promotion::TYPE_SLIDES) {
        $width = $bannerSizeArr['width'];
        $height = $bannerSizeArr['height'];
    }
    $htmlAfterField = '<span class="form-text text-muted uploadimage--info" > ' . Labels::getLabel('LBL_Preferred_Dimensions', $adminLangId) . ' ' . $width . ' * ' . $height . '</span>';
}
$fld1->htmlAfterField = $htmlAfterField;
$recordId = $promotionId;
$tabsButtons = [
	[
		'attr' => [
			'onclick' => 'addPromotionForm(' . $recordId . ');',
			'title' => Labels::getLabel('LBL_General', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_General', $adminLangId),
		'isActive' => false
	],
	[
		'attr' => [
			'onclick' => $promotionId ? "promotionLangForm(" . $promotionId . "," . FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1) . ");" : "",
			'title' => Labels::getLabel('LBL_Language_Data', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Language_Data', $adminLangId),
		'isActive' => false
	]
	
];
if ($promotionType == Promotion::TYPE_BANNER || $promotionType == Promotion::TYPE_SLIDES) {
$tabsButtons[] = 
	[
		'attr' => [
			'onclick' => ($promotionId > 0) ? "promotionMediaForm(" . $promotionId .");" : "",
			'title' => Labels::getLabel('LBL_Media', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Media', $adminLangId),
		'isActive' => true
	];
}

$formTitle = Labels::getLabel('LBL_Promotion_Setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>
<?php
$tpl = new FatTemplate('', '');
$tpl->set('adminLangId', $adminLangId);
echo $tpl->render(false, false, '_partial/imageUploadInstructions.php', true, true);
echo $mediaFrm->getFormHtml(); ?>
<div id="image-listing-js"></div>

<script>
    $('input[name=banner_min_width]').val(<?php echo $width; ?>);
    $('input[name=banner_min_height]').val(<?php echo $height; ?>);
    var aspectRatio = <?php echo $width / $height; ?>;

    $(document).on('change', '.display-js', function () {
        var promotionType = <?php echo $promotionType ?>;
        var screenDesktop = <?php echo applicationConstants::SCREEN_DESKTOP ?>;
        var screenIpad = <?php echo applicationConstants::SCREEN_IPAD ?>;

        <?php if ($promotionType == Promotion::TYPE_SLIDES) { ?>
            if ($(this).val() == screenDesktop) {
                var swidth = <?php echo $bannerSizeArr['width']; ?>;
                var sheight = <?php echo $bannerSizeArr['height']; ?>;

                $('.uploadimage--info').html(langLbl.preferredDimensions + ' ' + swidth + ' * ' + sheight);
                $('input[name=banner_min_width]').val(swidth);
                $('input[name=banner_min_height]').val(sheight);
                aspectRatio = swidth / sheight;
            } else if ($(this).val() == screenIpad) {
                var ipwidth = <?php echo $bannerSizeArr['width']; ?>;
                var ipheight = <?php echo $bannerSizeArr['height']; ?>;
                $('.uploadimage--info').html(langLbl.preferredDimensions + ' ' + ipwidth + ' * ' + ipheight);
                $('input[name=banner_min_width]').val(ipwidth);
                $('input[name=banner_min_height]').val(ipheight);
                aspectRatio = ipwidth / ipheight;
            } else {
                var mbwidth = <?php echo $bannerSizeArr['width']; ?>;
                var mbheight = <?php echo $bannerSizeArr['height']; ?>;
                $('.uploadimage--info').html(langLbl.preferredDimensions + ' ' + mbwidth + ' * ' + mbheight);
                $('input[name=banner_min_width]').val(mbwidth);
                $('input[name=banner_min_height]').val(mbheight);
                aspectRatio = mbwidth / mbheight;
            }
        <?php } elseif ($promotionType == Promotion::TYPE_BANNER) { ?>
            if ($(this).val() == screenDesktop) {
                var swidth = <?php echo $bannerSizeArr[applicationConstants::SCREEN_DESKTOP]['width']; ?>;
                var sheight = <?php echo $bannerSizeArr[applicationConstants::SCREEN_DESKTOP]['height']; ?>;

                $('.uploadimage--info').html(langLbl.preferredDimensions + ' ' + swidth + ' * ' + sheight);
                $('input[name=banner_min_width]').val(swidth);
                $('input[name=banner_min_height]').val(sheight);
                aspectRatio = swidth / sheight;
            } else if ($(this).val() == screenIpad) {
                var ipwidth = <?php echo $bannerSizeArr[applicationConstants::SCREEN_IPAD]['width']; ?>;
                var ipheight = <?php echo $bannerSizeArr[applicationConstants::SCREEN_IPAD]['height']; ?>;
                $('.uploadimage--info').html(langLbl.preferredDimensions + ' ' + ipwidth + ' * ' + ipheight);
                $('input[name=banner_min_width]').val(ipwidth);
                $('input[name=banner_min_height]').val(ipheight);
                aspectRatio = ipwidth / ipheight;
            } else {
                var mbwidth = <?php echo $bannerSizeArr[applicationConstants::SCREEN_MOBILE]['width']; ?>;
                var mbheight = <?php echo $bannerSizeArr[applicationConstants::SCREEN_MOBILE]['height']; ?>;
                $('.uploadimage--info').html(langLbl.preferredDimensions + ' ' + mbwidth + ' * ' + mbheight);
                $('input[name=banner_min_width]').val(mbwidth);
                $('input[name=banner_min_height]').val(mbheight);
                aspectRatio = mbwidth / mbheight;
            }
        <?php } ?>
    });
</script>

				
<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>