<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
$arr_flds = array(
    'rfq_id' => Labels::getLabel('LBL_Request_ID', $adminLangId),
    'buyer_name' => Labels::getLabel('LBL_Buyer_Name', $adminLangId),
    'seller_name' => Labels::getLabel('LBL_Seller_Name', $adminLangId),
    'selprod_title' => Labels::getLabel('LBL_Product_name', $adminLangId),
    'rfq_quantity' => Labels::getLabel('LBL_Qty', $adminLangId),
    //'rfq_capacity' => Labels::getLabel('LBL_Capacity', $adminLangId),
    'rfq_added_on' => Labels::getLabel('LBL_Date', $adminLangId),
    'rfq_status' => Labels::getLabel('LBL_Status', $adminLangId),
    'rfq_updated_on' => Labels::getLabel('LBL_UPDATED_ON', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);

$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-justified'));
$th = $tbl->appendElement('thead')->appendElement('tr', array('class' => ''));
foreach ($arr_flds as $key => $val) {
    if ($key == 'selprod_title') {
        $e = $th->appendElement('th', array('width' => '20%'), $val);
    } else if ($key == 'seller_name') {
        $e = $th->appendElement('th', array('width' => '15%'), $val);
    } else {
        $e = $th->appendElement('th', array(), $val);
    }

}

// CommonHelper::printArray($arr_listing, true);
foreach ($arr_listing as $sn => $row) {
    $link = CommonHelper::generateUrl('RequestForQuotes', 'requestView', array($row['rfq_id']));
    $tr = $tbl->appendElement('tr', array('class' => ''));

    foreach ($arr_flds as $key => $val) {
        $rfqId = $row['rfq_id'];
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'rfq_id':
                $td->appendElement('plaintext', array(), '#' . $row[$key], true);
                break;
            case 'rfq_status':
                $statusHtml = RequestForQuote::getStatusHtml($adminLangId, $row[$key]);
                $td->appendElement('plaintext', [], $statusHtml, true);
                break;
            case 'rfq_added_on':
                $date = FatDate::format($row[$key]);
                $dateHtml = "";
                if (strpos($date, ' ') !== false) {
                    list($formattedDate, $formattedTime) = explode(' ', $date);
                    $dateHtml = "<date class='date'>" . $formattedDate . " <time>" . $formattedTime . "</time></date>";
                } else {
                    $dateHtml = "<date class='date'>" . $date . "</date>";
                }
                $td->appendElement('plaintext', array(), $dateHtml, true);
                break;
            case 'rfq_updated_on':
                $date = FatDate::format($row[$key]);
                $dateHtml = "";
                if (strpos($date, ' ') !== false) {
                    list($formattedDate, $formattedTime) = explode(' ', $date);
                    $dateHtml = "<date class='date'>" . $formattedDate . " <time>" . $formattedTime . "</time></date>";
                } else {
                    $dateHtml = "<date class='date'>" . $date . "</date>";
                }
                $td->appendElement('plaintext', array(), $dateHtml, true);
                break;
            case 'action':
                $actionArr = [
                    [
                        "title" => Labels::getLabel('LBL_View', $adminLangId),
                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#eye'></use></svg>",
                        "href" => CommonHelper::generateUrl('RequestForQuotes', 'view', array($row['rfq_id']))
                    ]
                ];

                if (true === RequestForQuote::canAdminUpdateStatus($row['rfq_status'])) {
                    $actionArr[] = [
                        "title" => Labels::getLabel('LBL_Close_RFQ', $adminLangId),
                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#close'></use></svg>",
                        "onclick" => "changeRfqStatus('$rfqId')"
                    ];
                }
                $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $rfqId], false);
                break;
            case 'buyer_name':
                $buyerName = "<a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Users') . "\", " . $row['buyer_user_id'] . ")'>" . $row['buyer_name'] . "</a>";

                $td->appendElement('plaintext', array(), $buyerName, true);
                break;
            case 'seller_name':
                $shopName = "<a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Shops') . "\", " . $row['shop_id'] . ")'>" . $row['shop_name'] . "</a>";
                $sellerName = "<a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Users') . "\", " . $row['seller_user_id'] . ")'>" . $row['seller_name'] . "</a>";

                $td->appendElement('plaintext', array(), 'Shop: ' . $shopName . '<br>' . $sellerName, true);
                break;
            case 'selprod_title': 
                $productName = $row['selprod_title'];
                if (empty($productName)) {
                    $productName = $row['product_name'];
                }
                $td->appendElement('plaintext', array(), $productName, true);
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}



echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</div>
<?php
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmRfqSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'pageSize' => $pageSize, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);


