<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');

$arrFlds = array(
    'n' => Labels::getLabel('LBL_#', $adminLangId),
    'user_name' => Labels::getLabel('LBL_Name', $adminLangId),
    'credential_username' => Labels::getLabel('LBL_Email', $adminLangId),
    'user_phone' => Labels::getLabel('LBL_Phone', $adminLangId),
    'user_regdate' => Labels::getLabel('LBL_Registered_On', $adminLangId),
    'credential_verified' => Labels::getLabel('LBL_Verified', $adminLangId),
);

if ($canVerify || $canEdit) {
    $arrFlds['action'] = Labels::getLabel('LBL_Action(s)', $adminLangId);
}

$tbl = new HtmlElement('table', array('border' => '1', 'class'=>'table table-justified'));
$tr = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arrFlds as $val) {
    $tr->appendElement('th', array(), $val);
}

$n = $i = ($pageNumber - 1) * $pageSize + 1;
foreach ($data as $row) {
    $row['n'] = $n;
    $tr = $tbl->appendElement('tr');
    if (0 == $row['credential_active']) {
        $tr->addValueToAttribute('class', 'inactive');
    }
    foreach ($arrFlds as $fld => $caption) {
        switch ($fld) {
            case 'user_regdate':
                $tr->appendElement('td', array(), FatDate::format($row[$fld], true, true, FatApp::getConfig('CONF_TIMEZONE', FatUtility::VAR_STRING, date_default_timezone_get())));
                break;
            case 'credential_verified':
                $tr->appendElement('td', array(), (($row[$fld] == 1) ? Labels::getLabel('LBL_Yes', $adminLangId) : Labels::getLabel('LBL_No', $adminLangId)));
                break;
            case 'action':
                $actionArr = [];
                if ($canVerify) {
                    if ($row['credential_verified'] == 0) {
                        $actionArr[] = [
                            "title" => Labels::getLabel('LBL_Verify', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#active'></use></svg>",
                            "onclick" => 'verifyUser(' . $row['user_id'] . ', 1)'
                        ];
                    } else {
                        $actionArr[] = [
                            "title" => Labels::getLabel('LBL_Unverify', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#in-active'></use></svg>",
                            "onclick" => 'verifyUser(' . $row['user_id'] . ', 0)'
                        ];
                    }
                }

                if ($canEdit) {
                    if ($row['credential_active'] == 0) {
                        $actionArr[] = [
                            "title" => Labels::getLabel('LBL_Activate', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#active'></use></svg>",
                            "onclick" => 'activateUser(' . $row['user_id'] . ', 1)'
                        ];
                    } else {
                        $actionArr[] = [
                            "title" => Labels::getLabel('LBL_Deactivate', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#in-active'></use></svg>",
                            "onclick" => 'activateUser(' . $row['user_id'] . ', 0)'
                        ];
                    }
                }

                $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$row['user_id']], false);

                break;
            default:
                $tr->appendElement('td', array(), $row[$fld]);
                break;
        }
    }

    $n++;
}



echo $tbl->getHtml();
if (count($data) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmUserSearchPaging'
)); // We need the form always to reload listing
if ($pageCount > 1) {
    echo FatUtility::getPageString(
        ' <a href="javascript:void(0);" onclick="showUserSearchPage(xxpagexx);">xxpagexx</a>',
        $pageCount,
        $pageNumber,
        $lnkcurrent = ' xxpagexx',
        ' ... ',
        1,
        ' <a href="javascript:void(0);" onclick="showUserSearchPage(xxpagexx);">First</a>',
        ' <a href="javascript:void(0);" onclick="showUserSearchPage(xxpagexx);">Last</a>',
        ' <a href="javascript:void(0);" onclick="showUserSearchPage(xxpagexx);">Pre</a>',
        ' <a href="javascript:void(0);" onclick="showUserSearchPage(xxpagexx);">Next</a>'
    );
}
