<div class="page">
    <div class="content content-space">
        <div class="row">
            <div class="col-lg-12 col-md-12 space">
                <div class="page-title">
                    <div class="row">
                        <div class="col--first col-lg-6">

                            <h5><?php echo Labels::getLabel('LBL_Order_Details', $adminLangId); ?></h5>
                            <?php $this->includeTemplate('_partial/header/header-breadcrumb.php'); ?>
                        </div>
                    </div>
                </div>
                <section class="card section">
                    <div class="card-head">
                        <h4>
                            <?php 
                                $backUrl = UrlHelper::generateUrl('SellerOrders');
                                if ($order['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) {
                                    $backUrl = UrlHelper::generateUrl('SellerOrders', 'rental');
                                }
                            ?>
                            <a class="btn-back redirect--js" href="<?php echo $backUrl; ?>">
                                <svg class="svg" width="24" height="24">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_FRONTEND; ?>images/admin/retina/sprite-actions.svg#back">
                                    </use>
                                </svg>
                            </a>
                            <?php echo Labels::getLabel('LBL_Seller_Order_Details', $adminLangId); ?>
                        </h4>
                        <?php $ul = new HtmlElement("ul", array("class" => "actions actions--centered"));
                        $li = $ul->appendElement("li", array('class' => 'droplink'));
                        $li->appendElement('a', array('href' => 'javascript:void(0)', 'class' => 'button small green', 'title' => Labels::getLabel('LBL_Edit', $adminLangId)), '<i class="ion-android-more-horizontal icon"></i>', true);
                        /* $innerDiv = $li->appendElement('div', array('class' => 'dropwrap'));
                        $innerUl = $innerDiv->appendElement('ul', array('class' => 'linksvertical'));
                        $innerLi = $innerUl->appendElement('li');
                        $innerLi->appendElement('a', array('href' => UrlHelper::generateUrl('SellerOrders'), 'class' => 'button small green redirect--js', 'title' => Labels::getLabel('LBL_Back_to_Orders', $adminLangId)), Labels::getLabel('LBL_Back_to_Orders', $adminLangId), true); */
                        echo $ul->getHtml(); ?>
                    </div>
                    <div class="card-body">

                        <div class="listview listview-3">
                            <dl class="list">
                                <dt><?php echo Labels::getLabel('LBL_Invoice_Id', $adminLangId); ?></dt>
                                <dd><?php echo $order["op_invoice_number"]; ?></dd>
                            </dl>
                            <dl class="list">
                                <dt><?php echo Labels::getLabel('LBL_Order_Date', $adminLangId); ?></dt>
                                <dd><?php echo FatDate::format($order["order_date_added"], true); ?></dd>
                            </dl>
                            <dl class="list">
                                <dt><?php echo Labels::getLabel('LBL_Status', $adminLangId); ?></dt>
                                <dd><?php echo $order["orderstatus_name"]; ?></dd>
                            </dl>
                            <dl class="list">
                                <dt><?php echo Labels::getLabel('LBL_Customer/Guest', $adminLangId); ?></dt>
                                <dd><?php echo $order["buyer_user_name"] . ' (' . $order['buyer_username'] . ')'; ?></dd>
                            </dl>
                            <dl class="list">
                                <dt><?php echo Labels::getLabel('LBL_Payment_Method', $adminLangId); ?></dt>
                                <dd><?php echo CommonHelper::displayNotApplicable($adminLangId, $order["plugin_name"]); ?></dd>
                            </dl>
                            <dl class="list">
                                <dt><?php echo Labels::getLabel('LBL_Commission_Charged', $adminLangId); ?> [<?php echo $order["op_commission_percentage"] ?>%]</dt>
                                <dd><?php echo CommonHelper::displayMoneyFormat($order['op_commission_charged'], true, true); ?></dd>
                            </dl>
                            <dl class="list">
                                <dt><?php echo Labels::getLabel('LBL_Cart_Total', $adminLangId); ?></dt>
                                <dd><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order, 'CART_TOTAL'), true, true); ?></dd>
                            </dl>
                            <dl class="list">
                                <dt><?php echo Labels::getLabel('LBL_Delivery/Shipping', $adminLangId); ?></dt>
                                <dd>+<?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order, 'SHIPPING'), true, true); ?></dd>
                            </dl>
                            <dl class="list">
                                <dt><?php echo Labels::getLabel('LBL_VAT', $adminLangId); ?></dt>
                                <dd>+<?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order, 'TAX'), true, true); ?></dd>
                            </dl>
                            <dl class="list">
                                <dt><?php echo Labels::getLabel('LBL_Total_Paid', $adminLangId); ?></dt>
                                <dd><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order), true, true); ?></dd>
                            </dl>
                        </div>
                    </div>
                </section>
                <div class="row">
                    <?php
                    /*    $shipDetailColClass = 'col-lg-6';
                        if (!empty($order['shippingAddress'])) {
                            $shipDetailColClass = 'col-lg-4';
                        } */
                        $shipDetailColClass = 'col-lg-4';
                    ?>            
                    <div class="<?php echo $shipDetailColClass; ?>">
                        <section class="card section">
                            <div class="card-head">
                                <h4><?php echo Labels::getLabel('LBL_Seller_Details', $adminLangId); ?>
                                </h4>
                            </div>
                            <div class="card-body">
                                <div class="address-group">
                                    <p><strong><?php echo Labels::getLabel('LBL_Shop_Name', $adminLangId); ?>:
                                            </strong><?php echo $order["op_shop_name"] ?><br><strong><?php echo Labels::getLabel('LBL_Name', $adminLangId); ?>:
                                            </strong><?php echo $order["op_shop_owner_name"] ?><br><strong><?php echo Labels::getLabel('LBL_Email_ID', $adminLangId); ?>:
                                            </strong>
                                            <?php echo $order["op_shop_owner_email"] ?><br><strong><?php echo Labels::getLabel('LBL_Phone', $adminLangId); ?>:
                                            </strong><?php echo $order['op_shop_owner_phone_code'] . ' ' . $order["op_shop_owner_phone"] ?>
                                    </p>
                                </div>

                            </div>
                        </section>
                    </div>
                    <div class="<?php echo $shipDetailColClass; ?>">
                        <section class="card section">
                            <div class="card-head">
                                <h4><?php echo Labels::getLabel('LBL_Customer_Details', $adminLangId); ?>
                                </h4>
                            </div>
                            <div class="card-body">
                                <div class="address-group">
                                    <p><strong><?php echo Labels::getLabel('LBL_Name', $adminLangId); ?>:
                                            </strong><?php echo $order["buyer_name"] ?><br><strong><?php echo Labels::getLabel('LBL_UserName', $adminLangId); ?>:
                                            </strong><?php echo $order["buyer_username"]; ?><br><strong><?php echo Labels::getLabel('LBL_Email_ID', $adminLangId); ?>:</strong><?php echo $order["buyer_email"] ?><br><strong><?php echo Labels::getLabel('LBL_Phone', $adminLangId); ?>:</strong>
                                            <?php echo $order["user_dial_code"] . ' ' . $order["buyer_phone"] ?>
                                    </p>
                                </div>

                            </div>
                        </section>
                    </div>

                    <div class="<?php echo $shipDetailColClass; ?>">
                        <section class="card section">
                            <div class="card-head">
                                <h4><?php echo Labels::getLabel('LBL_Billing_Details', $adminLangId); ?>
                                </h4>
                            </div>
                            <div class="card-body">
                                <div class="address-group">
                                    <p><strong><?php echo $order['billingAddress']['oua_name']; ?></strong><br>
                                                <?php
                                                $billingAddress = '';
                                                if ($order['billingAddress']['oua_address1'] != '') {
                                                    $billingAddress .= $order['billingAddress']['oua_address1'] . '<br>';
                                                }

                                                if ($order['billingAddress']['oua_address2'] != '') {
                                                    $billingAddress .= $order['billingAddress']['oua_address2'] . '<br>';
                                                }

                                                if ($order['billingAddress']['oua_city'] != '') {
                                                    $billingAddress .= $order['billingAddress']['oua_city'] . ',';
                                                }

                                                if ($order['billingAddress']['oua_zip'] != '') {
                                                    $billingAddress .= ' ' . $order['billingAddress']['oua_state'];
                                                }

                                                if ($order['billingAddress']['oua_zip'] != '') {
                                                    $billingAddress .= '-' . $order['billingAddress']['oua_zip'];
                                                }

                                                if ($order['billingAddress']['oua_phone'] != '') {
                                                    $billingAddress .= '<br>' . Labels::getLabel('LBL_Phone:', $adminLangId) . ' ' . $order['billingAddress']['oua_dial_code'] . ' ' . $order['billingAddress']['oua_phone'];
                                                }
                                                echo $billingAddress;
                                                ?>
                                    </p>
                                </div>

                            </div>
                        </section>
                    </div>
                    
                    <?php if (!empty($order['shippingAddress'])) { ?>
                        <div class="<?php echo $shipDetailColClass; ?>">
                            <section class="card section">
                                <div class="card-head">
                                    <h4><?php echo Labels::getLabel('LBL_Shipping_Details', $adminLangId); ?>
                                    </h4>
                                </div>
                                <div class="card-body">
                                    <div class="address-group">
                                        <p><strong><?php echo $order['shippingAddress']['oua_name']; ?></strong><br>
                                            <?php
                                            $shippingAddress = '';
                                            if ($order['shippingAddress']['oua_address1'] != '') {
                                                $shippingAddress .= $order['shippingAddress']['oua_address1'] . '<br>';
                                            }

                                            if ($order['shippingAddress']['oua_address2'] != '') {
                                                $shippingAddress .= $order['shippingAddress']['oua_address2'] . '<br>';
                                            }

                                            if ($order['shippingAddress']['oua_city'] != '') {
                                                $shippingAddress .= $order['shippingAddress']['oua_city'] . ',';
                                            }

                                            if ($order['shippingAddress']['oua_zip'] != '') {
                                                $shippingAddress .= ' ' . $order['shippingAddress']['oua_state'];
                                            }

                                            if ($order['shippingAddress']['oua_zip'] != '') {
                                                $shippingAddress .= '-' . $order['shippingAddress']['oua_zip'];
                                            }

                                            if ($order['shippingAddress']['oua_phone'] != '') {
                                                $shippingAddress .= '<br>' . Labels::getLabel('LBL_Phone:', $adminLangId) . ' ' . $order['shippingAddress']['oua_dial_code'] . ' ' . $order['shippingAddress']['oua_phone'];
                                            }

                                            echo $shippingAddress; ?>
                                        </p>
                                    </div>

                                </div>
                            </section>
                        </div>
                    <?php } ?>
                   
                </div>
                <section class="card section">
                    <div class="card-head">
                        <h4><?php echo Labels::getLabel('LBL_Order_Details', $adminLangId); ?></h4>
                    </div>
                    <div class="card-body">
                        <table class="table">
                            <tr>
                                <th>#</td>
                                <th><?php echo Labels::getLabel('LBL_Product_Name', $adminLangId); ?></th>
                                <th><?php echo Labels::getLabel('LBL_Shipping', $adminLangId); ?></th>
                                <th><?php echo Labels::getLabel('LBL_Unit Price', $adminLangId); ?> </th>
                                <th><?php echo Labels::getLabel('LBL_Qty', $adminLangId); ?></th>
                                <th><?php echo Labels::getLabel('LBL_Shipping', $adminLangId); ?></th>
                                <th><?php echo Labels::getLabel('LBL_Tax', $adminLangId); ?></th>
                                <th><?php echo Labels::getLabel('LBL_Total', $adminLangId); ?></th>
                            </tr>
                            <tr>
                                <td>#</td>
                                <td><?php
                                $txt = '';
                                if ($order['op_selprod_title'] != '') {
                                    $txt .= $order['op_selprod_title'] . '<br/>';
                                }
                                $txt .= $order['op_product_name'];
                                $txt .= '<br/>';
                                if (!empty($order['op_brand_name'])) {
                                    $txt .= Labels::getLabel('LBL_Brand', $adminLangId) . ': ' . $order['op_brand_name'];
                                }
                                if (!empty($order['op_brand_name']) && !empty($order['op_selprod_options'])) {
                                    $txt .= ' | ';
                                }
                                if ($order['op_selprod_options'] != '') {
                                    $txt .= $order['op_selprod_options'];
                                }
                                if ($order['op_selprod_sku'] != '') {
                                    $txt .= '<br/>' . Labels::getLabel('LBL_SKU', $adminLangId) . ':   ' . $order['op_selprod_sku'];
                                }
                                if ($order['op_product_model'] != '') {
                                    $txt .= '<br/>' . Labels::getLabel('LBL_Model', $adminLangId) . ':   ' . $order['op_product_model'];
                                }
                                echo $txt;
                                ?></td>
                                <td><strong><?php echo Labels::getLabel('LBL_Shipping_Class', $adminLangId); ?>:
                                    </strong><?php echo CommonHelper::displayNotApplicable($adminLangId, $order["op_shipping_duration_name"]); ?><br />
                                    <strong><?php echo Labels::getLabel('LBL_Duration', $adminLangId); ?>:
                                    </strong><?php echo CommonHelper::displayNotApplicable($adminLangId, $order["op_shipping_durations"]); ?>
                                </td>
                                <td><?php echo CommonHelper::displayMoneyFormat($order["op_unit_price"], true, true); ?>
                                </td>
                                <td><?php echo $order["op_qty"] ?></td>
                                <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order, 'shipping'), true, true); ?>
                                </td>
                                <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order, 'TAX'), true, true); ?>
                                </td>
                                <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order), true, true); ?>
                                </td>
                            </tr>
                        </table>
                    </div>
                </section>



                <?php if (!$notEligible) { ?>
                    <section class="card section">
                        <div class="card-head">
                            <h4><?php echo Labels::getLabel('LBL_Reason_For_Cancellation', $adminLangId); ?></h4>
                        </div>
                        <div class="card-body extra">
                            <?php
                            $frm->setFormTagAttribute('onsubmit', 'cancelReason(this,' . $order['opd_sold_or_rented'] . '); return(false);');
                            $frm->setFormTagAttribute('class', 'form web_form');
                            $frm->developerTags['colClassPrefix'] = 'col-md-';
                            $frm->developerTags['fld_default_col'] = 12;
                            echo $frm->getFormHtml(); ?>
                        </div>
                    </section>
                <?php } ?>

            </div>
        </div>
    </div>
</div>