<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>

<div class='page'>
    <div class='content content-space'>
        <div class="row">
            <div class="col-lg-12 col-md-12 space">
                <div class="page-title">
                    <div class="row">
                        <div class="col--first col-lg-6">

                            <h5><?php echo Labels::getLabel('LBL_Manage_Seller_Orders', $adminLangId); ?> </h5>
                            <?php
                            if ($isRental) {
                                $this->includeTemplate('_partial/header/header-breadcrumb.php', array("hrefRental" => "/rental"));
                            } else {
                                $this->includeTemplate('_partial/header/header-breadcrumb.php');
                            }
                            ?>
                        </div>
                    </div>
                </div>
                <section class="card searchform_filter advance-search">
                    <div class="card-head">
                        <h4> <?php echo Labels::getLabel('LBL_Search...', $adminLangId); ?></h4>
                    </div>
                    <div class="card-body extra togglewrap">
                        <?php
                        $frmSearch->setFormTagAttribute('onsubmit', 'searchSellerOrders(this,1); return(false);');
                        $frmSearch->setFormTagAttribute('class', 'form web_form');
                        $frmSearch->developerTags['colClassPrefix'] = 'col-md-';
                        $frmSearch->developerTags['fld_default_col'] = 3;

                        $keywordFld = $frmSearch->getField('keyword');
                        // $keywordFld->developerTags['col'] = 6;
                        $keywordFld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('LBL_Search_in_list', $adminLangId) . '</small>';

                        $buyerFld = $frmSearch->getField('buyer');
                        // $buyerFld->developerTags['col'] = 3;
                        $buyerFld->htmlAfterField = '<small class="text--small form-text text-muted"></small>';

                        $statusFld = $frmSearch->getField('op_status_id');
                        // $statusFld->developerTags['col'] = 3;

                        $shopFld = $frmSearch->getField('shop_name');
                        // $shopFld->developerTags['col'] = 4;
                        $shopFld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('LBL_Search_in_Shop_Name,_Seller_Name,_Seller_UserName_and_Seller_EmailId,_Seller_Phone', $adminLangId) . '</small>';

                        $customerFld = $frmSearch->getField('customer_name');
                        if (null != $customerFld) {
                            // $customerFld->developerTags['col'] = 6;
                            $customerFld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('LBL_Search_in_Customer_Name,_Customer_User_Name,_Customer_Email_Id,_Customer_Phone', $adminLangId) . '</small>';
                        }

                        $dateFromFld = $frmSearch->getField('date_from');
                        $dateFromFld->setFieldTagAttribute('class', 'calender field--calender');
                        // $dateFromFld->developerTags['col'] = 4;

                        $dateToFld = $frmSearch->getField('date_to');
                        $dateToFld->setFieldTagAttribute('class', 'calender field--calender');
                        // $dateToFld->developerTags['col'] = 4;

                        $priceFromFld = $frmSearch->getField('price_from');
                        if (null != $priceFromFld) {
                            // $priceFromFld->developerTags['col'] = 2;
                        }

                        $priceToFld = $frmSearch->getField('price_to');
                        if (null != $priceToFld) {
                            // $priceToFld->developerTags['col'] = 2;
                        }

                        $submitBtnFld = $frmSearch->getField('btn_submit');
                        // $submitBtnFld->developerTags['col'] = 4;
                        // $submitBtnFld->developerTags['noCaptionTag'] = true;

                        $btn_clear = $frmSearch->getField('btn_clear');
                        $btn_clear->addFieldTagAttribute('onclick', 'clearSellerOrderSearch()');
                        echo $frmSearch->getFormHtml();
                        ?>
                    </div>
                </section>

                <section class="card section">
                    <div class="card-head">
                        <h4><?php echo Labels::getLabel('LBL_Seller_Orders_List', $adminLangId); ?> </h4>
                    </div>
                    <div class="card-table">
                        <div class="table-responsive table-scrollable js-scrollable tablewrap">
                            <div id="ordersListing">
                                <?php echo Labels::getLabel('LBL_Processing...', $adminLangId); ?>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
</div>