<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php

$plugin = new Plugin();
$keyName = $plugin->getDefaultPluginKeyName(Plugin::TYPE_SHIPPING_SERVICES);

$arr_flds = array(
    'op_invoice_number' => Labels::getLabel('LBL_INV_No', $adminLangId),
    'vendor' => Labels::getLabel('LBL_Seller', $adminLangId),
    'buyer_name' => Labels::getLabel('LBL_Customer', $adminLangId),
    'order_date_added' => Labels::getLabel('LBL_Date', $adminLangId),
    'order_net_amount' => Labels::getLabel('LBL_Amount', $adminLangId),
    'op_status_id' => Labels::getLabel('LBL_Status', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $val) {
    $e = $th->appendElement('th', array(), $val);
}
$sr_no = $page == 1 ? 0 : $pageSize * ($page - 1);

foreach ($vendorOrdersList as $sn => $row) {
    $sr_no++;
    $tr = $tbl->appendElement('tr');

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'op_invoice_number':
                $td->appendElement('a', array('target' => '_blank', 'href' => UrlHelper::generateUrl('SellerOrders', 'view', array($row['op_id']))), $row[$key], true);
                break;
            case 'vendor':
                $td->appendElement('plaintext', array(), '<strong>' . Labels::getLabel('LBL_Seller_Name', $adminLangId) . ':  </strong>', true);
                if ($canViewUsers) {
                    $td->appendElement('a', array('href' => 'javascript:void(0)', 'onClick' => 'redirectfunc("' . UrlHelper::generateUrl('Users') . '", ' . $row['op_selprod_user_id'] . ')'), $row['op_shop_owner_name'], true);
                } else {
                    $td->appendElement('plaintext', array(), $row['op_shop_owner_name'], true);
                }
                $txt = '<br/><strong>' . Labels::getLabel('LBL_Shop', $adminLangId) . ':  </strong>' . $row['op_shop_name'];
                $txt .= '<br/><strong>' . Labels::getLabel('LBL_User_Name', $adminLangId) . ':  </strong>' . $row['op_shop_owner_username'];
                $txt .= '<br/><strong>' . Labels::getLabel('LBL_Email', $adminLangId) . ':   </strong><a href="mailto:' . $row['op_shop_owner_email'] . '">' . $row['op_shop_owner_email'] . '</a>';
                /* $txt .= '<br/><strong>'.Labels::getLabel('LBL_Phone',$adminLangId).':   </strong>'.$row['op_shop_owner_phone']; */
                $td->appendElement('plaintext', array(), $txt, true);
                break;
            case 'buyer_name':
                $td->appendElement('plaintext', array(), '<strong>' . Labels::getLabel('LBL_Name', $adminLangId) . ':  </strong>', true);
                if ($canViewUsers) {
                    $td->appendElement('a', array('href' => 'javascript:void(0)', 'onClick' => 'redirectfunc("' . UrlHelper::generateUrl('Users') . '", ' . $row['user_id'] . ')'), $row[$key], true);
                } else {
                    $td->appendElement('plaintext', array(), $row[$key], true);
                }
                $txt = '<br/><strong>' . Labels::getLabel('LBL_User_Name', $adminLangId) . ':  </strong>' . $row['buyer_username'];
                $txt .= '<br/><strong>' . Labels::getLabel('LBL_Email', $adminLangId) . ':  </strong><a href="mailto:' . $row['buyer_email'] . '">' . $row['buyer_email'] . '</a>';
                $txt .= '<br/><strong>' . Labels::getLabel('LBL_Phone', $adminLangId) . ':  </strong>' . $row['user_dial_code'] . ' ' . $row['buyer_phone'];
                $td->appendElement('plaintext', array(), $txt, true);
                break;
            case 'order_net_amount':
                $amt = CommonHelper::orderProductAmount($row, 'netamount', false, User::USER_TYPE_SELLER) + $row['addon_amount'];
                $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($amt, true, true), true);
                break;
            case 'op_status_id':
                if (Orders::ORDER_PAYMENT_CANCELLED == $row["order_payment_status"]) {
                    $status = Labels::getLabel('LBL_CANCELLED', $adminLangId);
                    $labelClass = 'badge-danger';
                } else {
                    $status = $row['orderstatus_name'];
                    $labelClass = isset($classArr[$row['orderstatus_color_class']]) ? $classArr[$row['orderstatus_color_class']] : 'badge-info';
                }
              //  $td->appendElement('span', array('class' => 'badge badge-inline ' . $labelClass), $status. '<br>', true);
                $td->appendElement('span', array('class' => 'badge badge-inline ' . $labelClass), $status , true);
                if($row['op_payment_status'] == Orders::ORDER_PAYMENT_PARTIAL){
                    $td->appendElement('span', array('class' => 'badge badge-inline badge-info mt-2','style'=>'display:table-caption'), Labels::getLabel('LBL_PARTIAL_PAID', $adminLangId), true);
                }
                break;
            case 'order_date_added':
                $timeZone = FatApp::getConfig('CONF_TIMEZONE', FatUtility::VAR_STRING, date_default_timezone_get());
                $date = FatDate::format($row[$key], true, true, $timeZone);
                $dateHtml = "";
                if (strpos($date, ' ') !== false) {
                    list($formattedDate, $formattedTime) = explode(' ', $date);
                    $dateHtml = "<date class='date'>" . $formattedDate . " <time>" . $formattedTime . "</time></date>";
                } else {
                    $dateHtml = "<date class='date'>" . $date . "</date>";
                }

                $td->appendElement('plaintext', array(), $dateHtml, true);
                break;
            case 'action':
                $actionArr = [
                    [
                        "title" => Labels::getLabel('LBL_View_Order_Detail', $adminLangId),
                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#eye'></use></svg>",
                        "href" => UrlHelper::generateUrl('SellerOrders', 'view', array($row['op_id']))
                    ]
                ];
                $orderObj = new Orders($row['order_id']);
                $notAllowedStatues = $orderObj->getNotAllowedOrderCancellationStatuses();
                if (!in_array($row["op_status_id"], $notAllowedStatues) && $canEdit && $row['opd_product_type'] != SellerProduct::PRODUCT_TYPE_ADDON) {
                    $actionArr[] = [
                        "title" => Labels::getLabel('LBL_Cancel_Order', $adminLangId),
                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#close'></use></svg>",
                        "href" => UrlHelper::generateUrl('SellerOrders', 'CancelOrder', array($row['op_id']))
                    ];
                }
                $shipBySeller = CommonHelper::canAvailShippingChargesBySeller($row['op_selprod_user_id'], $row['opshipping_by_seller_user_id']);
                if ($row['op_product_type'] == Product::PRODUCT_TYPE_PHYSICAL && !$shipBySeller && true === $canShipByPlugin && ('CashOnDelivery' == $row['plugin_code'] || Orders::ORDER_PAYMENT_PAID == $row['order_payment_status']) && !empty($row['opshipping_carrier_code']) && !empty($row['opshipping_service_code']) && $row['opshipping_type'] == Shipping::SHIPPING_SERVICES) {
                    if (empty($row['opship_response']) && empty($row['opship_tracking_number'])) {
                        if ('EasyPost' != $keyName) {
                            $actionArr[] = [
                                "title" => Labels::getLabel('LBL_GENERATE_LABEL', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#icon-download'></use></svg>",
                                "onclick" => 'generateLabel(' . $row['op_id'] . ')'
                            ];
                        }
                    } elseif (!empty($row['opship_response'])) {
                        $actionArr[] = [
                            "title" => Labels::getLabel('LBL_PREVIEW_LABEL', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#export'></use></svg>",
                            "href" => UrlHelper::generateUrl("ShippingServices", 'previewLabel', [$row['op_id']]),
                            "target" => "_blank"
                        ];
                    }
                }
                $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['op_id']], false);
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}

echo $tbl->getHtml();
if (count($vendorOrdersList) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</div>
<?php
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmVendorOrderSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'pageSize' => $pageSize, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
