<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

$arr_flds = array(
    'select_all' => Labels::getLabel('LBL_Select_all', $adminLangId),
    'product_name' => Labels::getLabel('LBL_Name', $adminLangId),
   // 'selprod_price' => Labels::getLabel('LBL_Original_Price', $adminLangId),
    'credential_username' => Labels::getLabel('LBL_Seller', $adminLangId),
    'splprice_start_date' => Labels::getLabel('LBL_Start_Date', $adminLangId),
    'splprice_end_date' => Labels::getLabel('LBL_End_Date', $adminLangId),
  //  'splprice_price' => Labels::getLabel('LBL_Special_Price', $adminLangId),
    'splprice_hour_price' => Labels::getLabel('LBL_Hour_Price', $adminLangId),
    'splprice_day_price' => Labels::getLabel('LBL_Day_Price', $adminLangId),
    'splprice_week_price' => Labels::getLabel('LBL_Week_Price', $adminLangId),
    'splprice_month_price' => Labels::getLabel('LBL_Month_Price', $adminLangId),
    'action' => '',
);

if(!applicationConstants::checkActiveRentalDurations(ProductRental::DURATION_TYPE_HOUR)){
    unset($arr_flds['splprice_hour_price']);
}
if(!applicationConstants::checkActiveRentalDurations(ProductRental::DURATION_TYPE_DAY)){
    unset($arr_flds['splprice_day_price']);
}
if(!applicationConstants::checkActiveRentalDurations(ProductRental::DURATION_TYPE_WEEK)){
    unset($arr_flds['splprice_week_price']);
}
if(!applicationConstants::checkActiveRentalDurations(ProductRental::DURATION_TYPE_MONTH)){
    unset($arr_flds['splprice_month_price']);
}
if (!$canEdit) {
    unset($arr_flds['select_all'], $arr_flds['action']);
}
$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified splPriceList-js'));
$th = $tbl->appendElement('thead')->appendElement('tr', array('class' => 'hide--mobile'));
foreach ($arr_flds as $column => $lblTitle) {
    if ('select_all' == $column) {
        $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $lblTitle . '" type="checkbox" onclick="selectAll($(this))" class="selectAll-js"></label>', true);
    } else {
        $th->appendElement('th', array(), $lblTitle);
    }
}

foreach ($arrListing as $sn => $row) {
    $tr = $tbl->appendElement('tr', array());
    $splPriceId = $row['splprice_id'];
    $selProdId = $row['selprod_id'];
    $editListingFrm = new Form('editListingFrm-' . $splPriceId, array('id' => 'editListingFrm-' . $splPriceId));
    foreach ($arr_flds as $column => $lblTitle) {
        $tr->setAttribute('id', 'row-' . $splPriceId);
        $td = $tr->appendElement('td');
        switch ($column) {
            case 'select_all':
                $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="selprod_ids[' . $splPriceId . ']" value=' . $selProdId . '></label>', true);
                break;
            case 'product_name':
                // last Param of getProductDisplayTitle function used to get title in html form.
                $productName = SellerProduct::getProductDisplayTitle($selProdId, $adminLangId, true);
                $td->appendElement('plaintext', array(), $productName, true);
                break;
            case 'selprod_price':
                if ($productFor == Product::PRODUCT_FOR_RENT) {
                    //$price = CommonHelper::displayMoneyFormat($row['sprodata_rental_price'], true, true);
                    $price = CommonHelper::displayMoneyFormat($row['sprodata_rental_price'], true, true);
                } else {
                    $price = CommonHelper::displayMoneyFormat($row[$column], true, true);
                }
                $td->appendElement('plaintext', array(), $price, true);
                break;
            case 'credential_username':
                $td->appendElement('a', array('href' => 'javascript:void(0)', 'onClick' => 'redirectfunc("' . UrlHelper::generateUrl('Users') . '", ' . $row['selprod_user_id'] . ')'), $row[$column], true);
                /* $td->appendElement('plaintext', array(), $row[$column], true); */
                break;
            case 'splprice_start_date':
            case 'splprice_end_date':
                $date = date('Y-m-d', strtotime($row[$column]));
                $attr = array(
                    'readonly' => 'readonly',
                    'placeholder' => $lblTitle,
                    'data-selprodid' => $selProdId,
                    'data-id' => $splPriceId,
                    'data-oldval' => $date,
                    'data-price' => $row['selprod_price'],
                    'id' => $column . '-' . $splPriceId,
                    'class' => 'date_js js--splPriceCol hide sp-input calender',
                );
                $editListingFrm->addDateField($lblTitle, $column, $date, $attr);

                $td->appendElement('div', array("class" => '', "title" => Labels::getLabel('LBL_Click_To_Edit', $adminLangId)), $date, true);
                $td->appendElement('plaintext', array(), $editListingFrm->getFieldHtml($column), true);
                break;
            case 'splprice_price':
                $selprodPrice = ($productFor == Product::PRODUCT_FOR_RENT) ? $row['sprodata_rental_price'] : $row['selprod_price'];
                $input = '<input type="text" data-price="' . $selprodPrice . '" data-id="' . $splPriceId . '" value="' . $row[$column] . '" data-selprodid="' . $selProdId . '" name="' . $column . '" data-oldval="' . $row[$column] . '" data-displayoldval="' . CommonHelper::displayMoneyFormat($row[$column], true, true) . '" class="js--splPriceCol hide sp-input"/>';
                $td->appendElement('div', array("class" => '', "title" => Labels::getLabel('LBL_Click_To_Edit', $adminLangId)), CommonHelper::displayMoneyFormat($row[$column], true, true), true);
                $td->appendElement('plaintext', array(), $input, true);

                /* $discountPrice = $row['selprod_price'] - $row[$column];
                $discountPercentage = round(($discountPrice/$row['selprod_price'])*100, 2);
                $discountPercentage = $discountPercentage."% ".Labels::getLabel('LBL_off', $adminLangId);
                $td->appendElement('div', array("class" => 'ml-3 js--percentVal'), $discountPercentage, true); */
                $discountText = '';
                if (($productFor == Product::PRODUCT_FOR_RENT && $row['sprodata_rental_price'] > $row[$column]) || ($productFor == Product::PRODUCT_FOR_SALE && $row['selprod_price'] > $row[$column])) {
                    $discountPrice = $selprodPrice - $row[$column];
                    $discountPercentage = round(($discountPrice / $selprodPrice) * 100, 2);
                    $discountText = $discountPercentage . "% " . Labels::getLabel('LBL_off', $adminLangId);
                }

                if (($productFor == Product::PRODUCT_FOR_RENT && $row['sprodata_rental_price'] < $row[$column]) || ($productFor == Product::PRODUCT_FOR_SALE && $row['selprod_price'] < $row[$column])) {
                    $discountValue = $selprodPrice - $row[$column];
                    $discountValue = abs($discountValue);
                    $discountText = Labels::getLabel('LBL_Extra_charges', $adminLangId) . ": " . CommonHelper::displayMoneyFormat($discountValue, true, true);
                }

                $td->appendElement('div', array("class" => 'ml-3 js--percentVal'), $discountText, true);

                break;
            case 'splprice_hour_price':
                $selprodPrice = $row['sprodata_hour_rental_price'];
                if($selprodPrice <= 0){
                    $td->appendElement('plaintext', array(), Labels::getLabel('LBL_Disabled', $adminLangId), true);
                }else if($row[$column] > 0){
                    $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat( $row[$column], true, true), true);
                    $discountText = '';
                    if ($productFor == Product::PRODUCT_FOR_RENT && $selprodPrice > $row[$column]) {
                        $discountPrice = $selprodPrice - $row[$column];
                        $discountPercentage = round(($discountPrice / $selprodPrice) * 100, 2);
                        $discountText = $discountPercentage . "% " . Labels::getLabel('LBL_off', $adminLangId);
                    }
                    if ($productFor == Product::PRODUCT_FOR_RENT && $selprodPrice < $row[$column]) {
                        $discountValue = $selprodPrice - $row[$column];
                        $discountValue = abs($discountValue);
                        $discountText = Labels::getLabel('LBL_Extra_charges', $adminLangId) . ": " . CommonHelper::displayMoneyFormat($discountValue, true, true);
                    }
                    $td->appendElement('div', array("class" => 'ml-3 js--percentVal'), $discountText, true);
                }else{
                    $td->appendElement('plaintext', array(), Labels::getLabel('LBL_Not_Configured', $adminLangId), true);
                }
                
                break;

            case 'splprice_day_price':
                $selprodPrice = $row['sprodata_day_rental_price'];
                if($selprodPrice <= 0){
                    $td->appendElement('plaintext', array(),Labels::getLabel('LBL_Disabled', $adminLangId), true);
                }else if($row[$column] > 0){
                    $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($row[$column], true, true), true);
                    $discountText = '';
                    if ($productFor == Product::PRODUCT_FOR_RENT && $selprodPrice > $row[$column]) {
                        $discountPrice = $selprodPrice - $row[$column];
                        $discountPercentage = round(($discountPrice / $selprodPrice) * 100, 2);
                        $discountText = $discountPercentage . "% " . Labels::getLabel('LBL_off', $adminLangId);
                    }
                    if ($productFor == Product::PRODUCT_FOR_RENT && $selprodPrice < $row[$column]) {
                        $discountValue = $selprodPrice - $row[$column];
                        $discountValue = abs($discountValue);
                        $discountText = Labels::getLabel('LBL_Extra_charges', $adminLangId) . ": " . CommonHelper::displayMoneyFormat($discountValue, true, true);
                    }
                    $td->appendElement('div', array("class" => 'ml-3 js--percentVal'), $discountText, true);
                }else{
                    $td->appendElement('plaintext', array(), Labels::getLabel('LBL_Not_Configured', $adminLangId), true);
                }
                break;

            case 'splprice_week_price':
                $selprodPrice = $row['sprodata_week_rental_price'];
                if($selprodPrice <= 0){
                    $td->appendElement('plaintext', array(), Labels::getLabel('LBL_Disabled', $adminLangId), true);
                }else if($row[$column] > 0){
                    $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($row[$column], true, true), true);
                    $discountText = '';
                    if ($productFor == Product::PRODUCT_FOR_RENT && $selprodPrice > $row[$column]) {
                        $discountPrice = $selprodPrice - $row[$column];
                        $discountPercentage = round(($discountPrice / $selprodPrice) * 100, 2);
                        $discountText = $discountPercentage . "% " . Labels::getLabel('LBL_off', $adminLangId);
                    }
                    if ($productFor == Product::PRODUCT_FOR_RENT && $selprodPrice < $row[$column]) {
                        $discountValue = $selprodPrice - $row[$column];
                        $discountValue = abs($discountValue);
                        $discountText = Labels::getLabel('LBL_Extra_charges', $adminLangId) . ": " . CommonHelper::displayMoneyFormat($discountValue, true, true);
                    }
                    $td->appendElement('div', array("class" => 'ml-3 js--percentVal'), $discountText, true);
                }else{
                    $td->appendElement('plaintext', array(), Labels::getLabel('LBL_Not_Configured', $adminLangId), true);
                }
                
                break;

            case 'splprice_month_price':
                $selprodPrice = $row['sprodata_month_rental_price'];
                if($selprodPrice <= 0){
                    $td->appendElement('plaintext', array(), Labels::getLabel('LBL_Disabled', $adminLangId), true);
                }else if($row[$column] > 0){
                    $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($row[$column], true, true), true);
                    $discountText = '';
                    if ($productFor == Product::PRODUCT_FOR_RENT && $selprodPrice > $row[$column]) {
                        $discountPrice = $selprodPrice - $row[$column];
                        $discountPercentage = round(($discountPrice / $selprodPrice) * 100, 2);
                        $discountText = $discountPercentage . "% " . Labels::getLabel('LBL_off', $adminLangId);
                    }
                    if ($productFor == Product::PRODUCT_FOR_RENT && $selprodPrice < $row[$column]) {
                        $discountValue = $selprodPrice - $row[$column];
                        $discountValue = abs($discountValue);
                        $discountText = Labels::getLabel('LBL_Extra_charges', $adminLangId) . ": " . CommonHelper::displayMoneyFormat($discountValue, true, true);
                    }
                    $td->appendElement('div', array("class" => 'ml-3 js--percentVal'), $discountText, true);
                }else{
                    $td->appendElement('plaintext', array(), Labels::getLabel('LBL_Not_Configured', $adminLangId), true);
                }
                break;
            case 'action':
                if ($canEdit) {
                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                            "onclick" => "addSpecialPriceForm(" . $splPriceId . ")"
                        ],
                        [
                            "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                            "onclick" => "deleteSellerProductSpecialPrice(" . $splPriceId . ")"
                        ]
                    ];
                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$splPriceId], false);
                }
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$column], true);
                break;
        }
    }
}


$frm = new Form('frmSplPriceListing', array('id' => 'frmSplPriceListing'));
$frm->setFormTagAttribute('class', 'form web_form last_td_nowrap');

echo $frm->getFormTag();
echo $tbl->getHtml(); 
if (count($arrListing) == 0) {
    
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</form>
<?php
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmSearchSpecialPricePaging'));

$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'callBackJsFunc' => 'goToSearchPage', 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
