<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="card-head">
    <h4><?php echo Labels::getLabel('LBL_Catalog_Listing', $adminLangId); ?></h4>
    <a href="javascript:void(0);" onClick="addNewCatalogRequest()"
        class="themebtn btn btn-primary btn-sm"><?php echo Labels::getLabel('LBL_Request_to_add_catalog', $adminLangId); ?></a>
</div>
<div class="card-body">
    <?php
    $arr_flds = array(
        'listserial' => Labels::getLabel('LBL_#', $adminLangId),
        'scatrequest_reference' => Labels::getLabel('LBL_Reference_number', $adminLangId),
        'scatrequest_title' => Labels::getLabel('LBL_Title', $adminLangId),
        'scatrequest_status' => Labels::getLabel('LBL_Status', $adminLangId),
        'action' => Labels::getLabel('LBL_Action(s)', $adminLangId)
    );
    $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-justified'));
    $th = $tbl->appendElement('thead')->appendElement('tr', array('class' => 'hide--mobile'));
    foreach ($arr_flds as $val) {
        $e = $th->appendElement('th', array(), $val);
    }

    $sr_no = ($page == 1) ? 0 : ($pageSize * ($page - 1));
    foreach ($arr_listing as $sn => $row) {
        $sr_no++;
        $tr = $tbl->appendElement('tr', array('class' => ''));

        foreach ($arr_flds as $key => $val) {
            $td = $tr->appendElement('td');
            switch ($key) {
                case 'listserial':
                    $td->appendElement('plaintext', array(), '<span class="caption--td">' . $val . '</span>' . $sr_no, true);
                    break;
                case 'scatrequest_title':
                    $td->appendElement('plaintext', array(), '<span class="caption--td">' . $val . '</span>' . $row[$key] . '<br>', true);
                    break;
                case 'scatrequest_status':
                    $td->appendElement('plaintext', array(), '<span class="caption--td">' . $val . '</span>' . $catalogReqStatusArr[$row[$key]], true);
                    break;
                case 'action':
                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_View', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#eye'></use></svg>",
                            "onclick" => 'viewRequestedCatalog(' . $row['scatrequest_id'] . ')'
                        ]
                    ];
                    
                    if ($row['scatrequest_status'] == User::CATALOG_REQUEST_PENDING) {
                        $actionArr[] = [
                                "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                                "onclick" => 'deleteRequestedCatalog(' . $row['scatrequest_id'] . ')'
                        ];
                    }

                    $actionArr[] = [
                            "title" => Labels::getLabel('LBL_Messages', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#comment'></use></svg>",
                            "onclick" => 'messageForm(' . $row['scatrequest_id'] . ')'
                    ];
                    
                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$row['scatrequest_id']], false);

                    break;
                default:
                    $td->appendElement('plaintext', array(), '<span class="caption--td">' . $val . '</span>' . $row[$key], true);
                    break;
            }
        }
    }
    echo $tbl->getHtml();
    if (count($arr_listing) == 0) {
          $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId), false);
    }
    $postedData['page'] = $page;
    echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmCatalogReqSearchPaging'));

    $pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'callBackJsFunc' => 'goToCatalogReqSearchPage', 'adminLangId' => $adminLangId);
    $this->includeTemplate('_partial/pagination.php', $pagingArr, false);
    ?>
</div>