<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
    $arr_flds = array(
        'listserial' => Labels::getLabel('LBL_#', $adminLangId),
        'product_name' => Labels::getLabel('LBL_Product_Name', $adminLangId),
        'selprod_stock' => Labels::getLabel('LBL_Stock_left', $adminLangId),
        'selprod_threshold_stock_level' => Labels::getLabel('LBL_Threshold_Stock', $adminLangId),
        'selprod_threshold_email_sent_on' => Labels::getLabel('LBL_Last_Email_Sent', $adminLangId),
        'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
    );
    $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
    $th = $tbl->appendElement('thead')->appendElement('tr');
    foreach ($arr_flds as $val) {
        $e = $th->appendElement('th', array(), $val);
    }

    $sr_no = $page == 1 ? 0 : $pageSize * ($page - 1);
    foreach ($arr_listing as $sn => $row) {
        $sr_no++;
        $tr = $tbl->appendElement('tr');
        $tr->setAttribute("id", $row['selprod_id']);

        if ($row['selprod_threshold_stock_level'] < $row['selprod_stock']) {
            $tr->setAttribute("class", "fat-inactive");
        }
        foreach ($arr_flds as $key => $val) {
            $td = $tr->appendElement('td');
            switch ($key) {
                case 'listserial':
                    $td->appendElement('plaintext', array(), $sr_no);
                    break;
                case 'action':
                    if ($canEdit) {
                        $actionArr = [
                            [
                                "title" => Labels::getLabel('LBL_Email_Seller', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#send-email'></use></svg>",
                                "onclick" => "sendMailForm(" . $row['selprod_user_id'] . "," . $row['selprod_id'] . ")"
                            ]
                        ];
                        $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$key], false);
                    }
                    break;
                default:
                    $td->appendElement('plaintext', array(), $row[$key], true);
                    break;
            }
        }
    }
    echo $tbl->getHtml();
    if (count($arr_listing) == 0) {
        $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
    }
    ?>
</div>
<?php
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmProductSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'pageSize' => $pageSize, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
