<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<section class="card section">
    <div class="card-head">
        <h4><?php echo Labels::getLabel('LBL_Volume_Discount', $adminLangId); ?></h4>
        <a class=" btn-default btn btn-brand btn-sm" href="javascript:void(0); "
            onClick="sellerProductVolumeDiscountForm(<?php echo $selprod_id; ?>, 0);"><?php echo Labels::getLabel('LBL_Add_New_Volume_Discount', $adminLangId) ?></a>
        <?php /* <a class="btn-default btn btn-brand btn-sm" target='_blank' href="<?php echo UrlHelper::generateUrl('SellerProducts', 'volumeDiscount', array($selprod_id)); ?>" style='float:right;'><?php echo Labels::getLabel('LBL_Manage_Volume_Discount', $adminLangId)?></a> */ ?>
    </div>
    <div class="card-body extra">
        <div class="row">
            <div class="col-sm-12">
                <div class="border-box border-box--space">
                    <div class="need-remove  tabs_nav responsive">
                        <div class="tabs_panel_wrap">
                            <div class="tabs_panel">
                                <?php
                                $arr_flds = array(
                                    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
                                    'voldiscount_min_qty' => Labels::getLabel('LBL_Minimum_Purchase_Quantity', $adminLangId),
                                    'voldiscount_percentage' => Labels::getLabel('LBL_Discount', $adminLangId) . ' (%)',
                                    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
                                );
                                $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-justified'));
                                $th = $tbl->appendElement('thead')->appendElement('tr', array('class' => 'hide--mobile'));
                                foreach ($arr_flds as $val) {
                                    $e = $th->appendElement('th', array(), $val);
                                }

                                $sr_no = 0;
                                foreach ($arrListing as $sn => $row) {
                                    $sr_no++;
                                    $tr = $tbl->appendElement('tr', array());

                                    foreach ($arr_flds as $key => $val) {
                                        $td = $tr->appendElement('td');
                                        switch ($key) {
                                            case 'listserial':
                                                $td->appendElement('plaintext', array(), '' . $sr_no, true);
                                                break;
                                            case 'action':
                                                $actionArr = [
                                                    [
                                                        "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                                                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                                                        "onclick" => "sellerProductVolumeDiscountForm(" . $selprod_id . ", " . $row['voldiscount_id'] . ")"
                                                    ],
                                                    [
                                                        "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                                                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                                                        "onclick" => "deleteSellerProductVolumeDiscount(" . $row['voldiscount_id'] . ")"
                                                    ]
                                                ];
                                                $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['voldiscount_id']], false);
                                                break;
                                            default:
                                                $td->appendElement('plaintext', array(), '' . $row[$key], true);
                                                break;
                                        }
                                    }
                                }
                                if (count($arrListing) == 0) {
                                    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId), false);
                                } else {
                                    echo $tbl->getHtml();
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>