<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

$zoneIds = [];
$countryStatesArr = [];
$zoneCountries = [];
if (!empty($zoneLocations)) {
    $zoneIds = array_column($zoneLocations, 'shiploc_zone_id');
    $zoneIds = array_unique(array_map('intval', $zoneIds));
    foreach ($zoneLocations as $location) {
        $selectedCountryId = $location['shiploc_country_id'];
        $selectedStateId = $location['shiploc_state_id'];
        $selectedZoneId = $location['shiploc_zone_id'];
        $zoneCountries[$selectedZoneId][] = $selectedCountryId;
        $countryStatesArr[$selectedCountryId][] = $selectedStateId;
    }
}
$excludeCountryStates = [];
$exZoneIds = [];

if (!empty($excludeLocations)) {
    $exZoneIds = array_column($excludeLocations, 'shiploc_zone_id');
    $exZoneIds = array_unique(array_map('intval', $exZoneIds));
    foreach ($excludeLocations as $exLocation) {
        $disableCountryId = $exLocation['shiploc_country_id'];
        $disableStateId = $exLocation['shiploc_state_id'];
        $excludeCountryStates[$disableCountryId][] = $disableStateId;
    }
}
$selectedCountryArr = [];
$formTitle = Labels::getLabel('LBL_Zone_Setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
$formId = 'shippingZoneFrm';
?>
<form name="frmzone" onsubmit="setupZone(this); return(false);" method="post" class="form web_form form_horizontal"
    id="shippingZoneFrm">
    <div class="portlet__body">
        <input type="hidden" name="shipprozone_id"
            value="<?php echo (!empty($zone_data)) ? $zone_data['shipprozone_id'] : 0; ?>">
        <input type="hidden" name="shipzone_id" value="<?php echo $zone_id; ?>">
        <input type="hidden" name="shipzone_profile_id" value="<?php echo $profile_id; ?>">
        <!--<input type="hidden" name="selected_ship_zone"> -->
        <div class="row">
            <div class="col-md-12">
                <div class="form-group mb-20 zone-main-field--js">
                    <input type="text" placeholder="<?php echo Labels::getLabel("LBL_Zone_Name", $adminLangId); ?>"
                        name="shipzone_name" class="form-control shipzone_name"
                        value="<?php echo (!empty($zone_data)) ? $zone_data['shipzone_name'] : ''; ?>" required>
                    <span
                        class="form-text text-muted"><?php echo Labels::getLabel("LBL_Customers_will_not_see_this.", $adminLangId); ?></span>
                </div>
            </div>
        </div>
        <div class="row simplebar-resize-wrapper mb-20 list-zones">
            <div class="col-sm-12">
                <div class="row">
                    <div class="col-md-12 mb-4">
                        <div class="form-group mb-20 zone-main-field--js">
                            <input type="text"
                                placeholder="<?php echo Labels::getLabel("LBL_Search_Country_By_Name", $adminLangId); ?>"
                                class="filterCountryJs form-control shipzone_name" />
                        </div>
                    </div>
                </div>
                <div class="field-wraper">
                    <div class="field_cover">
                        <div class="rounded-row mb-2">
                            <label class="checkbox">
                                <span data-zoneid="-1"><input type="checkbox" name="rest_of_the_world" value="-1"
                                        class="checkbox_zone_-1"
                                        <?php echo (in_array(-1, $zoneIds)) ? 'checked' : ''; ?>
                                        <?php echo (in_array(-1, $exZoneIds)) ? 'disabled' : ''; ?>></span><?php echo Labels::getLabel("LBL_REST_OF_THE_WORLD", $adminLangId); ?>

                            </label>
                        </div>
                    </div>
                </div>

                <div class="checkbox_container--js ">

                    <?php
                        if (!empty($zones)) {
                            foreach ($zones as $zone) {
                                $countCounties = 0;
                                if (!empty($zoneCountries)) {
                                    $cZoneCountries = (isset($zoneCountries[$zone['zone_id']])) ? $zoneCountries[$zone['zone_id']] : array();
                                    $countCounties = count(array_unique($cZoneCountries));
                                }
                                $countries = (isset($zone['countries'])) ? $zone['countries'] : array();
                                $totalCountries = count($countries); ?>
                    <div class="rounded-row list-zones-head">

                        <label class="checkbox">
                            <span class=" zone--js" data-zoneid="<?php echo $zone['zone_id']; ?>">
                                <input type="checkbox" name="shiploc_zone_ids[]" value="<?php echo $zone['zone_id']; ?>"
                                    class="countries-js checkbox_zone_<?php echo $zone['zone_id']; ?>"
                                    <?php echo ($countCounties == $totalCountries && $countCounties != 0) ? 'checked' : ''; ?>>
                                
                            </span><?php echo $zone['zone_name']; ?>
                        </label>
                        <label class="out-of-state dropdown-toggle-custom zone-collapse--js"
                            data-zoneid="<?php echo $zone['zone_id']; ?>" data-toggle="collapse"
                            data-target="#listing_zone_<?php echo $zone['zone_id']; ?>" aria-expanded="false"
                            aria-controls="listing_zone_<?php echo $zone['zone_id']; ?>">
                            <i class="dropdown-toggle-custom-arrow"></i>
                        </label>
                    </div>
                    <?php
                                if (!empty($countries)) { ?>
                    <div class="collapse multi-collapse <?php echo (in_array($zone['zone_id'], $zoneIds)) ? "show" : ""; ?>"
                        id="listing_zone_<?php echo $zone['zone_id']; ?>">
                        <ul class="list-states child-checkbox-ul zone_<?php echo $zone['zone_id']; ?>">
                            <?php foreach ($countries as $country) {
                                                $statesCount = count($country['states']);
                                                $countryId = $country['country_id'];
                                                $disabled = '';
                                                $checked = '';
                                                $countryStates = [];
                                                $selectedStatesCount = 0;

                                                if (!empty($countryStatesArr) && isset($countryStatesArr[$countryId])) {
                                                    $countryStates = $countryStatesArr[$countryId];
                                                    $selectedStatesCount = count($countryStates);
                                                    if (!in_array('-1', $countryStates)) {
                                                        $selectedCountryArr[] = $countryId;
                                                    }
                                                }
                                                if (!empty($countryStates) && in_array('-1', $countryStates)) {
                                                    $checked = 'checked';
                                                    $selectedStatesCount = $statesCount;
                                                }
                                                if (!empty($excludeCountryStates) && isset($excludeCountryStates[$countryId])) {
                                                    $disabled = 'disabled';
                                                }

                                                ?>
                            <li class="list-states-item">
                                <div class="list-zones-head">
                                    <label class="checkbox">
                                        <?php
                                                                        $countryDisabled = '';
                                                                        $availableCountryStatesCount = $statesCount;
                                                                        if (isset($excludeCountryStates[$countryId])) {
                                                                            if (isset($excludeCountryStates[$countryId][0]) && $excludeCountryStates[$countryId][0] == "-1") {
                                                                                $availableCountryStatesCount = 0;
                                                                                $countryDisabled = 'disabled';
                                                                            } else {
                                                                                $availableCountryStatesCount = $statesCount - count($excludeCountryStates[$countryId]);
                                                                            }
                                                                        }
                                                                        ?>
                                        <span class=" country--js " data-countryid="<?php echo $countryId; ?>"
                                            data-statecount="<?php echo $statesCount; ?>"
                                            data-availablecount="<?php echo $availableCountryStatesCount ?>">
                                            <input <?php echo $countryDisabled ?> type="checkbox"
                                                <?php if ($availableCountryStatesCount == $statesCount) { ?>
                                                name="shiploc_country_ids[]" <?php } ?>
                                                value="<?php echo $zone['zone_id']; ?>-<?php echo $countryId; ?>"
                                                class="checkbox_country_<?php echo $countryId; ?>"
                                                <?php echo $checked; ?>>
                                        </span><?php echo $country['country_name']; ?>
                                    </label>
                                    <?php if ($statesCount > 0) { ?>
                                    <label
                                        class="out-of-state dropdown-toggle-custom link_<?php echo $countryId; ?> containChild-js"
                                        data-toggle="collapse" href="#state_list_<?php echo $countryId; ?>"
                                        aria-expanded="false" aria-controls="state_list_<?php echo $countryId; ?>"
                                        data-countryid="<?php echo $countryId; ?>" data-loadedstates="0">
                                        <span class="statecount--js selectedStateCount--js_<?php echo $countryId; ?> "
                                            data-totalcount="<?php echo $statesCount; ?>"><?php echo $selectedStatesCount; ?>
                                        </span>
                                        <?php echo Labels::getLabel("LBL_of", $adminLangId); ?>

                                        <span class="totalStates "><?php echo $statesCount; ?></span>
                                        <i class="dropdown-toggle-custom-arrow"></i>
                                    </label>
                                    <?php } ?>

                                </div>
                                <?php if (!empty($country['states'])) { ?>
                                <div class="collapse" id="state_list_<?php echo $countryId; ?>">
                                    <ul class="child-checkbox-ul list-country-zone_states country_<?php echo $countryId; ?>"
                                        class="">
                                        <?php
                                                                $countrySelected = $excludeCountryStates[$countryId] ?? [];
                                                                foreach ($country['states'] as $state) {
                                                                    $stateChecked = '';
                                                                    $countryStates = [];
                                                                    $exCountryStates = [];

                                                                    if (!empty($countryStatesArr) && isset($countryStatesArr[$countryId])) {
                                                                        $countryStates = $countryStatesArr[$countryId];
                                                                    }
                                                                    if ((!empty($countryStates) && (in_array('-1', $countryStates) || in_array($state['state_id'], $countryStates)))) {
                                                                        $stateChecked = 'checked';
                                                                    }
                                                                    $stateDisabled = '';
                                                                    $allstatesSelected = !empty($countrySelected) ? current($countrySelected) : 0;
                                                                    if (-1 == $allstatesSelected || (!empty($countrySelected) && in_array($state['state_id'], $countrySelected))) {
                                                                        $stateDisabled = ' disabled';
                                                                    }
                                                                    ?>
                                        <li>

                                            <label class="checkbox">
                                                <span data-stateid="<?php echo $state['state_id']; ?>">
                                                    <input type="checkbox" name="shiploc_state_ids[]"
                                                        value="<?php echo $zone['zone_id']; ?>-<?php echo $countryId; ?>-<?php echo $state['state_id']; ?>"
                                                        class="state--js" <?php echo $stateChecked; ?>
                                                        <?php echo $stateDisabled; ?>>

                                                </span>
                                                <?php echo $state['state_name']; ?>
                                            </label>

                                        </li>
                                        <?php } ?>
                                    </ul>
                                </div>
                                <?php } ?>
                            </li>
                            <?php
                                            } ?>
                        </ul>
                    </div>
                    <?php } ?>
                    <?php
                            }
                        }
                        ?>
                </div>
            </div>
        </div>
    </div>
    <input type="hidden" value="<?php echo implode(',' , $selectedCountryArr);?>" name="selected_countries">
</form>

<script>
function areAllCheckboxesCheckedAndDisabled(zoneId = '') {
    if (zoneId == '') {
        return;
    }
    var allCheckedAndDisabled = true;
    $('.zone_' + zoneId + ' input[type="checkbox"]').each(function() {
        if (!$(this).is(':disabled')) {
            allCheckedAndDisabled = false;
            return false; // Exit the loop early since one checkbox is not checked or disabled
        }
    });
    if (allCheckedAndDisabled) {
        $(".checkbox_zone_" + zoneId).attr('disabled', true);
    }
    return allCheckedAndDisabled;
}
$(document).on('keyup', '.filterCountryJs', function() {
    var searchTxt = $(this).val();
    var filter = $(this).val().trim();
    var activeZoneIds = [];
    $('.checkbox_container--js .country--js').each(function(index, el) {
        var val = $(el).find('input[type="checkbox"]').attr('value');
        var idsArr = val.split('-');
        var zoneId = parseInt(idsArr[0]);
        if ($(el).parent('label').text().trim().search(new RegExp(filter, "i")) >= 0) {
            if (jQuery.inArray(zoneId, activeZoneIds) === -1) {
                activeZoneIds.push(zoneId);
            }
            $(el).parents('li').show();
        } else {
            if ($(el).find('input[type="checkbox"]').prop('checked') == false) {
                $(el).parents('li').hide();
            }
        }
    });
    $('.checkbox_container--js .zone--js').each(function(index, el) {
        var zoneId = $(el).data('zoneid');
        if (jQuery.inArray(zoneId, activeZoneIds) === -1) {
            $('a[data-target="#listing_zone_' + zoneId + '"]').parents('.field-wraper').hide();
            $('#listing_zone_' + zoneId).removeClass('show');
        } else {
            $('a[data-target="#listing_zone_' + zoneId + '"]').parents('.field-wraper').show();
            $('#listing_zone_' + zoneId).addClass('show');
        }
    });
});

$(function() {

    <?php if (!empty($zones)) {
            foreach ($zones as $zone) {
                ?>
    areAllCheckboxesCheckedAndDisabled(<?php echo $zone['zone_id']; ?>);
    <?php
            }
        } ?>
});
</script>

<style>
.zone-collapse--js {
    position: absolute;
    right: 0;
}
</style>


<?php 

require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>