<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="generalForm"></div>
<?php
$frm->setFormTagAttribute('class', 'form web_form  form_horizontal');
$frm->setFormTagAttribute('onsubmit', 'setupShop(this); return(false);');
$frm->developerTags['colClassPrefix'] = 'col-md-';
$frm->developerTags['fld_default_col'] = 12;
$countryFld = $frm->getField('shop_country_code');
$countryFld->setFieldTagAttribute('id', 'geo_country_code');
$countryFld->setFieldTagAttribute('class', 'addressSelection-js');
$countryFld->setFieldTagAttribute('onChange', 'getStatesByCountryCode(this.value,' . $stateId . ',\'#geo_state_code\', \'state_code\')');

$stateFld = $frm->getField('shop_state');
$stateFld->setFieldTagAttribute('id', 'geo_state_code');
$stateFld->setFieldTagAttribute('class', 'addressSelection-js');

$fld = $frm->getField('shop_featured');
$fld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('LBL_Featured_Shops_will_be_listed_on_Featured_Shops_Page._Featured_Shops_will_get_priority,', $adminLangId) . '</small>';
$urlFld = $frm->getField('urlrewrite_custom');
$urlFld->setFieldTagAttribute('id', "urlrewrite_custom");
/* $urlFld->htmlAfterField = "<small class='text--small form-text text-muted'>" . UrlHelper::generateFullUrl('shops', 'View', array($shop_id), CONF_WEBROOT_FRONT_URL) . '</small>';
$urlFld->setFieldTagAttribute('onkeyup', "getSlugUrl(this,this.value,'')"); */
$urlFld->htmlAfterField = "<small  class='text--small form-text text-muted'>" . UrlHelper::generateFullUrl('shops', 'View', array($shop_id), CONF_WEBROOT_FRONT_URL) . '</small>';
$urlFld->setFieldTagAttribute('onkeyup', "getUniqueSlugUrl(this,this.value,$shop_id)");

$postalCode = $frm->getField('shop_postalcode');
$postalCode->setFieldTagAttribute('id', "geo_postal_code");

$latFld = $frm->getField('shop_lat');
$latFld->setFieldTagAttribute('id', "lat");
$lngFld = $frm->getField('shop_lng');
$lngFld->setFieldTagAttribute('id', "lng");
$recordId = $shop_id;
$tabsButtons = [
    [
        'attr' => [
            'onclick' => 'shopForm(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_General', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_General', $adminLangId),
        'isActive' => true
    ],
    [
        'attr' => [
            'onclick' => 'addShopLangForm(' . $recordId . ',' . FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1) . ')',
            'title' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => 'shopMediaForm(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_MEDIA', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_MEDIA', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => 'shopCollections(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_Collections', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Collections', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'href' => 'javascript:void(0)',
            'onclick' => 'shopAgreement(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_Shop_Agreement', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Shop_Agreement', $adminLangId),
        'isActive' => false
    ]
];
$formTitle = Labels::getLabel('LBL_Shop_Setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>
<?php echo $frm->getFormHtml(); ?>

<?php /* if (trim(FatApp::getConfig('CONF_GOOGLEMAP_API_KEY', FatUtility::VAR_STRING, '')) != '') { ?>
    <div id="map" style="width:100%; height:500px"></div>

    <div class="form-on-map">
        <div class="form-on-map-group">
            <div class="form-on-map-field">
                <input class="form-on-map-input location_autocomplete location-selected" id="ga-autoComplete" data-field-caption="<?php echo Labels::getLabel('LBL_Address', $adminLangId); ?>" data-fatreq="{&quot;required&quot;:true}" type="text" name="ga_autocomplete" placeholder="<?php echo Labels::getLabel('LBL_Add_Shop_Location', $adminLangId); ?>">
                <button class="icn-detect" type="button" onclick="loadGeoLocation(); return false;">
                    <svg class="svg" width="16" height="16">
                        <use xlink:href="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/dashboard/retina/sprite.svg#location-detect">
                        </use>
                    </svg>
                </button>
            </div>
            <input class="btn btn-brand btn-locate" data-field-caption="" data-fatreq="{&quot;required&quot;:false}" type="button" name="btn_locate" value="<?php echo Labels::getLabel('LBL_Locate', $adminLangId); ?>" onclick="searchLocation(); return false;">
        </div>
    </div>
<?php } */  ?>

<?php 
$CONF_ENABLE_GEO_LOCATION = (trim(FatApp::getConfig("CONF_GOOGLEMAP_API_KEY", FatUtility::VAR_STRING, '')) != '') ? 1 : 0;
?>

<script language="javascript">
    var CONF_ENABLE_GEO_LOCATION = <?php echo $CONF_ENABLE_GEO_LOCATION; ?>;
    $(document).ready(function () {
        stylePhoneNumberFld();

        $('select[name="shop_partial_payment_type"]').on('change', function () {
            var selectedValue = $(this).val();  
            
            if (selectedValue == 1) {
                $('input[name="shop_partial_payment_percentage"]').removeAttr('disabled');
            } else {
                $('input[name="shop_partial_payment_percentage"]').attr('disabled', 'disabled').val(100);
            }
        });
        $('select[name="shop_partial_payment_type"]').trigger('change');
    });
</script>

<?php if (trim(FatApp::getConfig('CONF_GOOGLEMAP_API_KEY', FatUtility::VAR_STRING, '')) != '') { ?>
    <script>
        $(document).ready(function () {
            var lat = (!$('#lat').val()) ? '<?php echo FatApp::getConfig('CONF_GEO_DEFAULT_LAT', FatUtility::VAR_FLOAT, 0); ?>' : $('#lat').val();
            var lng = (!$('#lng').val()) ? '<?php echo FatApp::getConfig('CONF_GEO_DEFAULT_LNG', FatUtility::VAR_FLOAT, 0); ?>' : $('#lng').val();
            initAutocomplete();
            initMap(lat, lng);
        });
    </script>
<?php } ?>
<?php
if (isset($countryIso) && !empty($countryIso)) { ?>
    <script>
        langLbl.defaultCountryCode = '<?php echo $countryIso; ?>';
    </script>
<?php } ?>
<style>
    .pac-container {
        z-index: 1061;
    }
</style>
<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>
