<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

$frm->setFormTagAttribute('class', 'form web_form  form_horizontal layout--' . $formLayout);
$frm->setFormTagAttribute('onsubmit', 'setupShopLang(this); return(false);');
$frm->setFormTagAttribute('dir', $formLayout);
$frm->developerTags['colClassPrefix'] = 'col-md-';
$frm->developerTags['fld_default_col'] = 12;

$paymentPolicyfld = $frm->getField('shop_payment_policy');
$paymentPolicyfld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('LBL_Shop_payment_terms_comments', $adminLangId) . '</small>';

$paymentPolicyfld = $frm->getField('shop_delivery_policy');
$paymentPolicyfld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('LBL_Shop_delivery_policy_comments', $adminLangId) . '</small>';

$paymentPolicyfld = $frm->getField('shop_refund_policy');
$paymentPolicyfld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('LBL_Shop_refund_policy_comments', $adminLangId) . '</small>';

$paymentPolicyfld = $frm->getField('shop_additional_info');
$paymentPolicyfld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('LBL_Shop_additional_info_comments', $adminLangId) . '</small>';

$paymentPolicyfld = $frm->getField('shop_seller_info');
$paymentPolicyfld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('LBL_Shop_seller_info_comments', $adminLangId) . '</small>';

$langFld = $frm->getField('lang_id');
$langFld->setfieldTagAttribute('onChange', "addShopLangForm(" . $shop_id . ", this.value);");
$recordId = $shop_id;
$tabsButtons = [
    [
        'attr' => [
            'onclick' => 'shopForm(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_General', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_General', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => 'addShopLangForm(' . $recordId . ',' . FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1) . ')',
            'title' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        'isActive' => true
    ],
    [
        'attr' => [
            'onclick' => 'shopMediaForm(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_MEDIA', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_MEDIA', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => 'shopCollections(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_Collections', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Collections', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'href' => 'javascript:void(0)',
            'onclick' => 'shopAgreement(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_Shop_Agreement', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Shop_Agreement', $adminLangId),
        'isActive' => false
    ]
];
$formTitle = Labels::getLabel('LBL_Shop_Setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>
<?php
$translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
$siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
if (!empty($translatorSubscriptionKey) && $shop_lang_id != $siteDefaultLangId) { ?>
    <div class="row justify-content-end">
        <div class="col-auto mb-4">
            <button type="button" class="btn btn-outline-gray btn-icon btn-language" onclick="addShopLangForm(<?php echo $shop_id; ?>, <?php echo $shop_lang_id; ?>, 1)" title="<?php echo Labels::getLabel('LBL_AUTOFILL_LANGUAGE_DATA', $adminLangId); ?>" data-action="">
                <svg class="svg" width="24" height="24">
                    <use xlink:href="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/retina/sprite-actions.svg#translate"></use>
                </svg>
            </button>
        </div>
    </div>
<?php } ?>
<div class="">
    <?php echo $frm->getFormHtml(); ?>
</div>
<?php 
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>